/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.swinger.util;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public final class JavaFXLoader {
    public static boolean addToSystemClassLoader(File file) {
        if (ClassLoader.getSystemClassLoader() instanceof URLClassLoader) {
            URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            try {
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)classLoader, file.toURI().toURL());
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }
        return false;
    }

    public static boolean loadJavaFX() {
        if (JavaFXLoader.isJavaFXLoaded()) {
            return true;
        }
        File javaFxJar = new File(System.getProperty("java.home"), "lib/jfxrt.jar");
        if (javaFxJar.isFile()) {
            try {
                JavaFXLoader.addToSystemClassLoader(javaFxJar);
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isJavaFXLoaded() {
        try {
            JavaFXLoader.class.getClassLoader().loadClass("javafx.embed.swing.JFXPanel");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

