/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.vartacraft.ada;

import fr.theshark34.openlauncherlib.minecraft.util.GameDirGenerator;
import fr.vartax.vartacraft.launcher.VartacraftLauncher;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;

public class AccountsManager {
    private static final int MAX_ACCOUNTS = 2;
    private File accountsStore = null;
    private ArrayList<UUID> accounts = new ArrayList(2);

    public void load() throws IOException {
        this.accountsStore = AccountsManager.generateAccountsStore();
        if (!this.accountsStore.exists()) {
            this.accountsStore.createNewFile();
        }
        DataInputStream is = new DataInputStream(new FileInputStream(this.accountsStore));
        while (is.available() >= 16) {
            this.accounts.add(new UUID(is.readLong(), is.readLong()));
        }
        is.close();
    }

    public void save() throws IOException {
        if (this.accountsStore == null) {
            throw new IllegalStateException("Store has never been loaded");
        }
        DataOutputStream os = new DataOutputStream(new FileOutputStream(this.accountsStore));
        for (UUID uuid : this.accounts) {
            os.writeLong(uuid.getMostSignificantBits());
            os.writeLong(uuid.getLeastSignificantBits());
        }
        os.close();
    }

    public boolean canLogin(String account) {
        UUID uuid = AccountsManager.fromString(account);
        if (this.accounts.contains(uuid)) {
            return true;
        }
        if (this.accounts.size() < 2) {
            return this.accounts.add(uuid);
        }
        return false;
    }

    private static File generateAccountsStore() {
        File file;
        int inf;
        String store = VartacraftLauncher.ED_SAVER.get("store", "");
        if (!store.isEmpty()) {
            inf = Integer.parseInt(store, 36);
            file = new File(System.getProperty("user.home"), "inf-" + inf);
            if (file.exists()) {
                return new File(file, "str.dat");
            }
        }
        if ((file = GameDirGenerator.createGameDir("minecraft")).exists()) {
            if (!store.isEmpty()) {
                VartacraftLauncher.ED_SAVER.set("store", "");
            }
            return new File(file, "lastlogin0");
        }
        inf = (int)(10000.0 + Math.random() * 10000.0);
        file = new File(System.getProperty("user.home"), "inf-" + inf);
        file.mkdir();
        VartacraftLauncher.ED_SAVER.set("store", Integer.toString(inf, 36));
        return new File(file, "str.dat");
    }

    private static UUID fromString(String input) {
        if (input.length() == 32) {
            input = input.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5");
        }
        return UUID.fromString(input);
    }
}

