/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.vartacraft.launcher.utils;

import fr.theshark34.swinger.Swinger;
import fr.vartax.vartacraft.launcher.LauncherFrame;
import fr.vartax.vartacraft.launcher.VartacraftLauncher;
import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;

public class TrayManager {
    private static TrayIcon trayIcon;

    public static void createTray() {
        if (!SystemTray.isSupported()) {
            return;
        }
        SystemTray tray = SystemTray.getSystemTray();
        BufferedImage image = Swinger.getResource("icon.png");
        PopupMenu menu = new PopupMenu();
        MenuItem showItem = new MenuItem("Afficher le Launcher");
        showItem.addActionListener(e -> {
            LauncherFrame.getInstance().setVisible(true);
            LauncherFrame.getInstance().setState(0);
        });
        MenuItem quitItem = new MenuItem("Quitter Vartacraft");
        quitItem.addActionListener(e -> VartacraftLauncher.shutdown());
        menu.add(showItem);
        menu.addSeparator();
        menu.add(quitItem);
        trayIcon = new TrayIcon(image, "Vartacraft Launcher", menu);
        trayIcon.setImageAutoSize(true);
        trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LauncherFrame.getInstance().setVisible(true);
                    LauncherFrame.getInstance().setState(0);
                }
            }
        });
        try {
            tray.add(trayIcon);
        }
        catch (AWTException e2) {
            System.err.println("Impossible d'ajouter l'ic\u00f4ne \u00e0 la barre des t\u00e2ches.");
            e2.printStackTrace();
        }
    }

    public static void displayMessage(String title, String message) {
        if (trayIcon != null) {
            trayIcon.displayMessage(title, message, TrayIcon.MessageType.INFO);
        }
    }
}

