/*
 * Decompiled with CFR 0.152.
 */
package net.wytrem.wylog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.wytrem.wylog.BasicLogger;
import net.wytrem.wylog.ConsoleHandler;
import net.wytrem.wylog.FileHandler;
import net.wytrem.wylog.ILogHandler;
import net.wytrem.wylog.LogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerFactory {
    public static int minLogLevel = LogLevel.INFO.getIntLevel();
    public static final ArrayList<ILogHandler> sharedHandlers = new ArrayList<ILogHandler>(){
        private static final long serialVersionUID = 1L;
        {
            ConsoleHandler handler = new ConsoleHandler();
            this.add(handler);
        }
    };

    public static final FileHandler addSharedFileHandler(File loggingFile) throws IOException {
        FileHandler handler = new FileHandler(loggingFile);
        sharedHandlers.add(handler);
        return handler;
    }

    public static final void addSharedHandler(ILogHandler handler) {
        sharedHandlers.add(handler);
    }

    public static final BasicLogger getLogger(String name) {
        return new BasicLogger(name);
    }

    public static final BasicLogger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getSimpleName());
    }

    public static void setMinLogLevel(int lvl) {
        minLogLevel = lvl;
    }
}

