/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.defaults;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.interfaces.ReachedSet;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;

public final class ProgramLocationDependentReachedSet<StateT extends AbstractState<StateT> & ProgramLocationDependent>
implements ReachedSet<StateT> {
    private final Map<JvmCfaNode, Set<StateT>> locationToStates = new LinkedHashMap<JvmCfaNode, Set<StateT>>();

    @Override
    public boolean add(StateT abstractState) {
        return this.locationToStates.computeIfAbsent(((ProgramLocationDependent)abstractState).getProgramLocation(), x -> new LinkedHashSet()).add(abstractState);
    }

    @Override
    public boolean addAll(Collection<? extends StateT> abstractStates) {
        boolean result = false;
        for (AbstractState state : abstractStates) {
            result |= this.add(state);
        }
        return result;
    }

    @Override
    public boolean remove(StateT abstractState) {
        JvmCfaNode location = ((ProgramLocationDependent)abstractState).getProgramLocation();
        return this.locationToStates.containsKey(location) && this.locationToStates.get(location).remove(abstractState);
    }

    @Override
    public boolean removeAll(Collection<? extends StateT> abstractStates) {
        boolean result = false;
        for (AbstractState state : abstractStates) {
            result |= this.remove(state);
        }
        return result;
    }

    @Override
    public Collection<StateT> asCollection() {
        int initialSize = this.locationToStates.values().size();
        return this.locationToStates.values().stream().reduce(new LinkedHashSet(initialSize), (x, y) -> {
            x.addAll(y);
            return x;
        });
    }

    @Override
    public Collection<StateT> getReached(StateT abstractState) {
        return this.getReached(((ProgramLocationDependent)abstractState).getProgramLocation());
    }

    @Override
    public Collection<StateT> getReached(JvmCfaNode location) {
        return this.locationToStates.getOrDefault(location, Collections.emptySet());
    }

    @Override
    public void clear() {
        this.locationToStates.clear();
    }
}

