/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import proguard.analysis.cpa.algorithms.CpaAlgorithm;
import proguard.analysis.cpa.bam.BamCache;
import proguard.analysis.cpa.bam.BamCpa;
import proguard.analysis.cpa.bam.BlockAbstraction;
import proguard.analysis.cpa.defaults.BreadthFirstWaitlist;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.domain.memory.BamLocationDependentJvmMemoryLocation;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationAbstractState;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationCpa;
import proguard.analysis.cpa.jvm.domain.memory.TraceExtractor;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSink;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSource;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.classfile.Signature;

public class TaintAnalyzerResult {
    private final TaintAnalysisResult taintAnalysisResult;
    private final JvmMemoryLocationCpa<SetAbstractState<JvmTaintSource>> traceReconstructionCpa;
    @Nullable
    private TraceExtractor<SetAbstractState<JvmTaintSource>> traceExtractor;

    TaintAnalyzerResult(BamCpa<SetAbstractState<JvmTaintSource>> executedTaintCpa, ProgramLocationDependentReachedSet<JvmAbstractState<SetAbstractState<JvmTaintSource>>> mainMethodReachedSet, Collection<? extends JvmTaintSink> taintSinks, JvmMemoryLocationCpa<SetAbstractState<JvmTaintSource>> traceReconstructionCpa) {
        this.taintAnalysisResult = new TaintAnalysisResult(executedTaintCpa, mainMethodReachedSet, taintSinks);
        this.traceReconstructionCpa = traceReconstructionCpa;
    }

    public TaintAnalysisResult getTaintAnalysisResult() {
        return this.taintAnalysisResult;
    }

    public TraceExtractor<SetAbstractState<JvmTaintSource>> getTraceReconstructionResult() {
        if (this.traceExtractor == null) {
            this.traceExtractor = new TraceReconstructionResult(this.traceReconstructionCpa, this.taintAnalysisResult);
        }
        return this.traceExtractor;
    }

    private static class TraceReconstructionResult
    implements TraceExtractor<SetAbstractState<JvmTaintSource>> {
        private final ProgramLocationDependentReachedSet<JvmMemoryLocationAbstractState<SetAbstractState<JvmTaintSource>>> traceReconstructionReachedSet;
        private final TaintAnalysisResult taintAnalysisResult;

        private TraceReconstructionResult(JvmMemoryLocationCpa<SetAbstractState<JvmTaintSource>> traceReconstructionCpa, TaintAnalysisResult taintAnalysisResult) {
            this.traceReconstructionReachedSet = this.runTraceReconstruction(traceReconstructionCpa, taintAnalysisResult);
            this.taintAnalysisResult = taintAnalysisResult;
        }

        private ProgramLocationDependentReachedSet<JvmMemoryLocationAbstractState<SetAbstractState<JvmTaintSource>>> runTraceReconstruction(JvmMemoryLocationCpa<SetAbstractState<JvmTaintSource>> traceCpa, TaintAnalysisResult taintAnalysisResult) {
            CpaAlgorithm<SetAbstractState<JvmTaintSource>> cpaAlgorithm = new CpaAlgorithm<SetAbstractState<JvmTaintSource>>(traceCpa);
            BreadthFirstWaitlist waitlist = new BreadthFirstWaitlist();
            ProgramLocationDependentReachedSet<JvmMemoryLocationAbstractState<SetAbstractState<JvmTaintSource>>> reachedSet = new ProgramLocationDependentReachedSet<JvmMemoryLocationAbstractState<SetAbstractState<JvmTaintSource>>>();
            List initialStates = taintAnalysisResult.getEndpoints().stream().map(JvmMemoryLocationAbstractState::new).collect(Collectors.toList());
            waitlist.addAll(initialStates);
            reachedSet.addAll(initialStates);
            cpaAlgorithm.run(reachedSet, waitlist);
            return reachedSet;
        }

        @Override
        public Collection<BamLocationDependentJvmMemoryLocation<SetAbstractState<JvmTaintSource>>> getEndPoints() {
            return this.taintAnalysisResult.getEndpoints();
        }

        @Override
        public ProgramLocationDependentReachedSet<JvmMemoryLocationAbstractState<SetAbstractState<JvmTaintSource>>> getTraceReconstructionReachedSet() {
            return this.traceReconstructionReachedSet;
        }
    }

    public static class TaintAnalysisResult {
        private final ProgramLocationDependentReachedSet<JvmAbstractState<SetAbstractState<JvmTaintSource>>> mainMethodReachedSet;
        private final BamCpa<SetAbstractState<JvmTaintSource>> executedTaintCpa;
        private final Collection<? extends JvmTaintSink> taintSinks;
        @Nullable
        private Map<BamLocationDependentJvmMemoryLocation<SetAbstractState<JvmTaintSource>>, List<JvmTaintSink>> endpointToTriggeredSinks = null;

        private TaintAnalysisResult(BamCpa<SetAbstractState<JvmTaintSource>> executedTaintCpa, ProgramLocationDependentReachedSet<JvmAbstractState<SetAbstractState<JvmTaintSource>>> mainMethodReachedSet, Collection<? extends JvmTaintSink> taintSinks) {
            this.executedTaintCpa = executedTaintCpa;
            this.mainMethodReachedSet = mainMethodReachedSet;
            this.taintSinks = taintSinks;
        }

        public BamCache<SetAbstractState<JvmTaintSource>> getTaintResultCache() {
            return this.executedTaintCpa.getCache();
        }

        public ProgramLocationDependentReachedSet<JvmAbstractState<SetAbstractState<JvmTaintSource>>> getMainMethodReachedSet() {
            return this.mainMethodReachedSet;
        }

        public Collection<BamLocationDependentJvmMemoryLocation<SetAbstractState<JvmTaintSource>>> getEndpoints() {
            if (this.endpointToTriggeredSinks == null) {
                this.endpointToTriggeredSinks = this.calculateEndpointsMapping(this.executedTaintCpa, this.taintSinks);
            }
            return this.endpointToTriggeredSinks.keySet();
        }

        public Map<BamLocationDependentJvmMemoryLocation<SetAbstractState<JvmTaintSource>>, List<JvmTaintSink>> getEndpointToTriggeredSinks() {
            if (this.endpointToTriggeredSinks == null) {
                this.endpointToTriggeredSinks = this.calculateEndpointsMapping(this.executedTaintCpa, this.taintSinks);
            }
            return this.endpointToTriggeredSinks;
        }

        private Map<BamLocationDependentJvmMemoryLocation<SetAbstractState<JvmTaintSource>>, List<JvmTaintSink>> calculateEndpointsMapping(BamCpa<SetAbstractState<JvmTaintSource>> executedTaintCpa, Collection<? extends JvmTaintSink> taintSinks) {
            HashMap<BamLocationDependentJvmMemoryLocation<SetAbstractState<JvmTaintSource>>, List<JvmTaintSink>> endpointToSinks = new HashMap<BamLocationDependentJvmMemoryLocation<SetAbstractState<JvmTaintSource>>, List<JvmTaintSink>>();
            Map<Signature, Map<JvmTaintSink, Set<JvmMemoryLocation>>> fqnToSinkLocations = JvmTaintSink.convertSinksToMemoryLocations(taintSinks);
            executedTaintCpa.getCache().values().stream().map(BlockAbstraction::getReachedSet).forEach(reachedSet -> reachedSet.asCollection().forEach(state -> state.getProgramLocation().getLeavingEdges().forEach(edge -> this.createEndpointsForEdgeIfTainted((ProgramLocationDependentReachedSet<JvmAbstractState<SetAbstractState<JvmTaintSource>>>)reachedSet, (JvmAbstractState<SetAbstractState<JvmTaintSource>>)state, (JvmCfaEdge)edge, fqnToSinkLocations, (Map<BamLocationDependentJvmMemoryLocation<SetAbstractState<JvmTaintSource>>, List<JvmTaintSink>>)endpointToSinks))));
            return endpointToSinks;
        }

        private void createEndpointsForEdgeIfTainted(ProgramLocationDependentReachedSet<JvmAbstractState<SetAbstractState<JvmTaintSource>>> reachedSet, JvmAbstractState<SetAbstractState<JvmTaintSource>> state, JvmCfaEdge edge, Map<Signature, Map<JvmTaintSink, Set<JvmMemoryLocation>>> signatureToSinkLocations, Map<BamLocationDependentJvmMemoryLocation<SetAbstractState<JvmTaintSource>>, List<JvmTaintSink>> endPointToSinks) {
            signatureToSinkLocations.getOrDefault(edge.targetSignature(), Collections.emptyMap()).entrySet().stream().filter(sinkToMemoryLocations -> ((JvmTaintSink)sinkToMemoryLocations.getKey()).matchCfaEdge(edge)).forEach(sinkToMemoryLocations -> ((Set)sinkToMemoryLocations.getValue()).stream().filter(memoryLocation -> this.isStateTaintedForMemoryLocation(state, (JvmMemoryLocation)memoryLocation, (JvmTaintSink)sinkToMemoryLocations.getKey())).forEach(memoryLocation -> this.createAndAddEndpoint(reachedSet, state, (JvmMemoryLocation)memoryLocation, (JvmTaintSink)sinkToMemoryLocations.getKey(), endPointToSinks)));
        }

        private void createAndAddEndpoint(ProgramLocationDependentReachedSet<JvmAbstractState<SetAbstractState<JvmTaintSource>>> reachedSet, JvmAbstractState<SetAbstractState<JvmTaintSource>> state, JvmMemoryLocation taintLocation, JvmTaintSink sink, Map<BamLocationDependentJvmMemoryLocation<SetAbstractState<JvmTaintSource>>, List<JvmTaintSink>> endPointToSinks) {
            BamLocationDependentJvmMemoryLocation memoryLocation = new BamLocationDependentJvmMemoryLocation(taintLocation, state.getProgramLocation(), reachedSet);
            endPointToSinks.computeIfAbsent(memoryLocation, x -> new ArrayList()).add(sink);
        }

        private boolean isStateTaintedForMemoryLocation(JvmAbstractState<SetAbstractState<JvmTaintSource>> state, JvmMemoryLocation memoryLocation, JvmTaintSink sink) {
            SetAbstractState extractedState = memoryLocation.extractValueOrDefault(state, SetAbstractState.bottom());
            return extractedState.stream().anyMatch(sink.isValidForSource);
        }
    }
}

