/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.util;

import java.util.function.Function;
import proguard.analysis.cpa.algorithms.CpaAlgorithm;
import proguard.analysis.cpa.bam.BamCache;
import proguard.analysis.cpa.bam.BamCacheImpl;
import proguard.analysis.cpa.bam.BamCpa;
import proguard.analysis.cpa.bam.CpaWithBamOperators;
import proguard.analysis.cpa.bam.NoOpRebuildOperator;
import proguard.analysis.cpa.defaults.DepthFirstWaitlist;
import proguard.analysis.cpa.defaults.HashMapAbstractState;
import proguard.analysis.cpa.defaults.MergeJoinOperator;
import proguard.analysis.cpa.defaults.NeverAbortOperator;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.defaults.SimpleCpa;
import proguard.analysis.cpa.defaults.StaticPrecisionAdjustment;
import proguard.analysis.cpa.defaults.StopJoinOperator;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.value.JvmCfaReferenceValueFactory;
import proguard.analysis.cpa.jvm.domain.value.JvmValueAbstractState;
import proguard.analysis.cpa.jvm.domain.value.JvmValueTransferRelation;
import proguard.analysis.cpa.jvm.domain.value.ValueAbstractState;
import proguard.analysis.cpa.jvm.domain.value.ValueExpandOperator;
import proguard.analysis.cpa.jvm.domain.value.ValueReduceOperator;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmShallowHeapAbstractState;
import proguard.classfile.ClassPool;
import proguard.classfile.MethodSignature;
import proguard.evaluation.ExecutingInvocationUnit;
import proguard.evaluation.value.ParticularValueFactory;

public class ValueAnalyzer {
    private final Function<MethodSignature, BamCpa<ValueAbstractState>> cpaCreator;
    private final Function<MethodSignature, JvmValueAbstractState> initialStateCreator;

    private ValueAnalyzer(Function<MethodSignature, BamCpa<ValueAbstractState>> cpaCreator, Function<MethodSignature, JvmValueAbstractState> initialStateCreator) {
        this.cpaCreator = cpaCreator;
        this.initialStateCreator = initialStateCreator;
    }

    public ValueAnalysisResult analyze(MethodSignature mainSignature) {
        BamCpa<ValueAbstractState> cpa = this.cpaCreator.apply(mainSignature);
        CpaAlgorithm<ValueAbstractState> cpaAlgorithm = new CpaAlgorithm<ValueAbstractState>(cpa);
        DepthFirstWaitlist<JvmValueAbstractState> waitList = new DepthFirstWaitlist<JvmValueAbstractState>();
        ProgramLocationDependentReachedSet<JvmValueAbstractState> reachedSet = new ProgramLocationDependentReachedSet<JvmValueAbstractState>();
        JvmValueAbstractState initialState = this.initialStateCreator.apply(mainSignature);
        waitList.add(initialState);
        reachedSet.add(initialState);
        cpaAlgorithm.run(reachedSet, waitList);
        return new ValueAnalysisResult(cpa, reachedSet);
    }

    public static class Builder {
        private final JvmCfa cfa;
        private int maxCallStackDepth = 10;
        private AbortOperator abortOperator = NeverAbortOperator.INSTANCE;
        private final ExecutingInvocationUnit.Builder invocationUnitBuilder;

        public Builder(JvmCfa cfa, ClassPool programClassPool, ClassPool libraryClassPool) {
            this.cfa = cfa;
            this.invocationUnitBuilder = new ExecutingInvocationUnit.Builder(programClassPool, libraryClassPool).setEnableSameInstanceIdApproximation(true);
        }

        public Builder(JvmCfa cfa, ExecutingInvocationUnit.Builder invocationUnitBuilder) {
            this.cfa = cfa;
            this.invocationUnitBuilder = invocationUnitBuilder;
        }

        public ValueAnalyzer build() {
            ParticularValueFactory valueFactory = new ParticularValueFactory(new JvmCfaReferenceValueFactory(this.cfa));
            ExecutingInvocationUnit invocationUnit = this.invocationUnitBuilder.build(valueFactory);
            JvmValueTransferRelation valueTransferRelation = new JvmValueTransferRelation(valueFactory, invocationUnit);
            SimpleCpa intraproceduralCpa = new SimpleCpa(valueTransferRelation, new MergeJoinOperator(), new StopJoinOperator(), new StaticPrecisionAdjustment(), this.abortOperator);
            boolean reduceHeap = true;
            CpaWithBamOperators<ValueAbstractState> interProceduralCpa = new CpaWithBamOperators<ValueAbstractState>(intraproceduralCpa, new ValueReduceOperator(valueFactory, invocationUnit, reduceHeap), new ValueExpandOperator(valueFactory, invocationUnit, this.cfa, reduceHeap), new NoOpRebuildOperator());
            BamCacheImpl cache = new BamCacheImpl();
            return new ValueAnalyzer(mainMethodSignature -> new BamCpa(interProceduralCpa, this.cfa, (MethodSignature)mainMethodSignature, cache, this.maxCallStackDepth), mainMethodSignature -> new JvmValueAbstractState(valueFactory, invocationUnit, (JvmCfaNode)this.cfa.getFunctionEntryNode(mainMethodSignature), new JvmFrameAbstractState<ValueAbstractState>(), new JvmShallowHeapAbstractState<JvmCfaNode, ValueAbstractState>(new HashMapAbstractState(), JvmCfaNode.class, ValueAbstractState.UNKNOWN), new HashMapAbstractState<String, ValueAbstractState>()));
        }

        public Builder setMaxCallStackDepth(int maxCallStackDepth) {
            this.maxCallStackDepth = maxCallStackDepth;
            return this;
        }

        public Builder setAbortOperator(AbortOperator abortOperator) {
            this.abortOperator = abortOperator;
            return this;
        }
    }

    public static class ValueAnalysisResult {
        private final BamCache<ValueAbstractState> resultCache;
        private final ProgramLocationDependentReachedSet<JvmAbstractState<ValueAbstractState>> mainMethodReachedSet;

        private ValueAnalysisResult(BamCpa<ValueAbstractState> executedCpa, ProgramLocationDependentReachedSet<JvmAbstractState<ValueAbstractState>> mainMethodReachedSet) {
            this.resultCache = executedCpa.getCache();
            this.mainMethodReachedSet = mainMethodReachedSet;
        }

        public BamCache<ValueAbstractState> getResultCache() {
            return this.resultCache;
        }

        public ProgramLocationDependentReachedSet<JvmAbstractState<ValueAbstractState>> getMainMethodReachedSet() {
            return this.mainMethodReachedSet;
        }
    }
}

