/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import proguard.classfile.MethodDescriptor;
import proguard.classfile.MethodInfo;

public class BasicMethodInfo
implements MethodInfo {
    private final String methodName;
    private final MethodDescriptor descriptor;

    public BasicMethodInfo(@NotNull String methodName, @NotNull MethodDescriptor descriptor) {
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(descriptor);
        this.methodName = methodName;
        this.descriptor = descriptor;
    }

    public BasicMethodInfo(MethodInfo method) {
        this(method.getMethodName(), method.getDescriptor());
    }

    @Override
    @NotNull
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    @NotNull
    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicMethodInfo)) {
            return false;
        }
        BasicMethodInfo that = (BasicMethodInfo)o;
        return Objects.equals(this.methodName, that.getMethodName()) && Objects.equals(this.descriptor, that.getDescriptor());
    }

    public int hashCode() {
        return Objects.hash(this.methodName, this.descriptor);
    }

    public String toString() {
        return this.methodName + this.descriptor;
    }
}

