/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberInfoBlock;
import proguard.classfile.attribute.LineOrigin;

public class StructuredLineNumberInfo
extends LineNumberInfo {
    private final int blockId;
    private final String sourceMethod;
    private final int sourceLineStart;
    private final int sourceLineEnd;
    private final List<LineOrigin> origin;
    private static final Map<Integer, String> sourceMap = new HashMap<Integer, String>();

    @Override
    public String getSourceMethod() {
        return this.sourceMethod;
    }

    @Override
    public int getSourceLineStart() {
        return this.sourceLineStart;
    }

    @Override
    public int getSourceLineEnd() {
        return this.sourceLineEnd;
    }

    @Override
    public int getBlockId() {
        return this.blockId;
    }

    @Override
    public List<LineOrigin> getOrigin() {
        return this.origin;
    }

    private StructuredLineNumberInfo(int u2startPc, int u2lineNumber, int blockId, List<LineOrigin> origin, String sourceMethod, int sourceLineStart, int sourceLineEnd) {
        super(u2startPc, u2lineNumber);
        this.blockId = blockId;
        this.origin = origin;
        this.sourceMethod = sourceMethod;
        this.sourceLineStart = sourceLineStart;
        this.sourceLineEnd = sourceLineEnd;
    }

    @Override
    public String getSource() {
        if (this.sourceMethod != null && this.sourceLineStart != -1 && this.sourceLineEnd != -1) {
            return sourceMap.computeIfAbsent(this.blockId, id -> this.sourceMethod + ":" + this.sourceLineStart + ":" + this.sourceLineEnd);
        }
        return this.sourceMethod;
    }

    @Override
    public LineNumberInfoBlock getBlock() {
        return new Block(this.blockId, new ArrayList<LineOrigin>(this.origin), this.sourceMethod, this.sourceLineStart, this.sourceLineEnd);
    }

    public Block getBlock(LineOrigin ... addedOrigins) {
        ArrayList<LineOrigin> origins = new ArrayList<LineOrigin>();
        origins.addAll(this.origin);
        origins.addAll(Arrays.asList(addedOrigins));
        return new Block(this.blockId, origins, this.sourceMethod, this.sourceLineStart, this.sourceLineEnd);
    }

    public static class Block
    implements LineNumberInfoBlock {
        private static int idCounter = 0;
        private final int blockId;
        private final String sourceMethod;
        private final int sourceLineStart;
        private final int sourceLineEnd;
        private final List<LineOrigin> origin;

        private static synchronized int getNewId() {
            return idCounter++;
        }

        Block(int blockId, List<LineOrigin> origin, String sourceMethod, int sourceLineStart, int sourceLineEnd) {
            this.blockId = blockId;
            this.sourceMethod = sourceMethod;
            this.sourceLineStart = sourceLineStart;
            this.sourceLineEnd = sourceLineEnd;
            this.origin = origin;
        }

        public Block(List<LineOrigin> origin, String sourceMethod, int sourceLineStart, int sourceLineEnd) {
            this(Block.getNewId(), origin, sourceMethod, sourceLineStart, sourceLineEnd);
        }

        public Block(LineOrigin origin, String sourceMethod, int sourceLineStart, int sourceLineEnd) {
            this(Block.getNewId(), new ArrayList<LineOrigin>(Arrays.asList(origin)), sourceMethod, sourceLineStart, sourceLineEnd);
        }

        public Block(LineOrigin origin) {
            this(origin, null, -1, -1);
        }

        @Override
        public StructuredLineNumberInfo line(int u2startPc, int u2lineNumber) {
            return new StructuredLineNumberInfo(u2startPc, u2lineNumber, this.blockId, this.origin, this.sourceMethod, this.sourceLineStart, this.sourceLineEnd);
        }
    }
}

