/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.MaxStackSizeComputer;
import proguard.util.ArrayUtil;

public class StackSizeComputer
implements AttributeVisitor {
    private final MaxStackSizeComputer maxSackSizeComputer;
    private int[] stackSizesBefore = new int[8096];
    private int[] stackSizesAfter = new int[8096];

    public StackSizeComputer() {
        this.maxSackSizeComputer = new MaxStackSizeComputer((offset, stackSizeBefore, stackSizeAfter) -> {
            this.stackSizesBefore[offset] = stackSizeBefore;
            this.stackSizesAfter[offset] = stackSizeAfter;
        });
    }

    public boolean isReachable(int instructionOffset) {
        return this.maxSackSizeComputer.isReachable(instructionOffset);
    }

    public int getStackSizeBefore(int instructionOffset) {
        if (!this.maxSackSizeComputer.isReachable(instructionOffset)) {
            throw new IllegalArgumentException("Unknown stack size before unreachable instruction offset [" + instructionOffset + "]");
        }
        return this.stackSizesBefore[instructionOffset];
    }

    public int getStackSizeAfter(int instructionOffset) {
        if (!this.maxSackSizeComputer.isReachable(instructionOffset)) {
            throw new IllegalArgumentException("Unknown stack size after unreachable instruction offset [" + instructionOffset + "]");
        }
        return this.stackSizesAfter[instructionOffset];
    }

    public int getMaxStackSize() {
        return this.maxSackSizeComputer.getMaxStackSize();
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int codeLength = codeAttribute.u4codeLength;
        this.stackSizesBefore = ArrayUtil.ensureArraySize(this.stackSizesBefore, codeLength, 0);
        this.stackSizesAfter = ArrayUtil.ensureArraySize(this.stackSizesAfter, codeLength, 0);
        codeAttribute.accept(clazz, method, (AttributeVisitor)this.maxSackSizeComputer);
    }
}

