/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.TypeAnnotation;
import proguard.classfile.attribute.annotation.TypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.target.LocalVariableTargetElement;
import proguard.classfile.attribute.annotation.target.LocalVariableTargetInfo;
import proguard.classfile.attribute.annotation.target.OffsetTargetInfo;
import proguard.classfile.attribute.annotation.target.TargetInfo;
import proguard.classfile.attribute.annotation.target.TypeArgumentTargetInfo;
import proguard.classfile.attribute.annotation.target.visitor.LocalVariableTargetElementVisitor;
import proguard.classfile.attribute.annotation.target.visitor.TargetInfoVisitor;
import proguard.classfile.attribute.annotation.visitor.TypeAnnotationVisitor;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.UninitializedType;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.InstructionWriter;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.editor.VariableSizeUpdater;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.ClassPrinter;
import proguard.util.ArrayUtil;

public class CodeAttributeComposer
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
LineNumberInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
TypeAnnotationVisitor,
TargetInfoVisitor,
LocalVariableTargetElementVisitor {
    private static final boolean DEBUG = false;
    private static final int MAXIMUM_LEVELS = 32;
    private static final int INVALID = -1;
    private final boolean allowExternalBranchTargets;
    private final boolean allowExternalExceptionOffsets;
    private final boolean shrinkInstructions;
    private final boolean absoluteBranchOffsets;
    private int maximumCodeLength;
    private int codeLength;
    private int exceptionTableLength;
    private int lineNumberTableLength;
    private int level = -1;
    private byte[] code = new byte[8096];
    private int[] oldInstructionOffsets = new int[8096];
    private final int[] codeFragmentOffsets = new int[32];
    private final int[] codeFragmentLengths = new int[32];
    private final int[][] instructionOffsetMap = new int[32][];
    private ExceptionInfo[] exceptionTable = new ExceptionInfo[16];
    private LineNumberInfo[] lineNumberTable = new LineNumberInfo[1024];
    private int expectedStackMapFrameOffset;
    private final StackSizeUpdater stackSizeUpdater = new StackSizeUpdater();
    private final VariableSizeUpdater variableSizeUpdater = new VariableSizeUpdater();
    private final InstructionWriter instructionWriter = new InstructionWriter();
    private ConstantPoolEditor constantPoolEditor;

    public CodeAttributeComposer() {
        this(false, false, true);
    }

    public CodeAttributeComposer(boolean allowExternalBranchTargets, boolean allowExternalExceptionOffsets, boolean shrinkInstructions) {
        this(allowExternalBranchTargets, allowExternalExceptionOffsets, shrinkInstructions, false);
    }

    public CodeAttributeComposer(boolean allowExternalBranchTargets, boolean allowExternalExceptionOffsets, boolean shrinkInstructions, boolean absoluteBranchOffsets) {
        this.allowExternalBranchTargets = allowExternalBranchTargets;
        this.allowExternalExceptionOffsets = allowExternalExceptionOffsets;
        this.shrinkInstructions = shrinkInstructions;
        this.absoluteBranchOffsets = absoluteBranchOffsets;
    }

    public void reset() {
        this.maximumCodeLength = 0;
        this.codeLength = 0;
        this.exceptionTableLength = 0;
        this.lineNumberTableLength = 0;
        this.level = -1;
        this.instructionWriter.reset(this.code.length);
    }

    public void beginCodeFragment(int maximumCodeFragmentLength) {
        ++this.level;
        if (this.level >= 32) {
            throw new IllegalArgumentException("Maximum number of code fragment levels exceeded [" + this.level + "]");
        }
        this.maximumCodeLength += maximumCodeFragmentLength;
        this.ensureCodeLength(this.maximumCodeLength);
        if (this.instructionOffsetMap[this.level] == null || this.instructionOffsetMap[this.level].length <= maximumCodeFragmentLength) {
            if (maximumCodeFragmentLength < 8096) {
                maximumCodeFragmentLength = 8096;
            }
            this.instructionOffsetMap[this.level] = new int[maximumCodeFragmentLength + 1];
        }
        Arrays.fill(this.instructionOffsetMap[this.level], 0, maximumCodeFragmentLength + 1, -1);
        this.codeFragmentOffsets[this.level] = this.codeLength;
        this.codeFragmentLengths[this.level] = maximumCodeFragmentLength;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public void appendInstruction(int oldInstructionOffset, Instruction instruction) {
        if (this.shrinkInstructions) {
            instruction = instruction.shrink();
        }
        int newCodeLength = this.codeLength + instruction.length(this.codeLength);
        this.ensureCodeLength(newCodeLength);
        this.ensureFragmentLength(oldInstructionOffset + 1);
        this.oldInstructionOffsets[this.codeLength] = oldInstructionOffset;
        this.instructionOffsetMap[this.level][oldInstructionOffset] = this.codeLength;
        instruction.accept(null, null, new CodeAttribute(0, 0, 0, 0, this.code, 0, null, 0, null), this.codeLength, this.instructionWriter);
        this.codeLength = newCodeLength;
    }

    public void appendLabel(int oldInstructionOffset) {
        this.ensureCodeLength(this.codeLength + 1);
        this.ensureFragmentLength(oldInstructionOffset + 1);
        this.oldInstructionOffsets[this.codeLength] = oldInstructionOffset;
        this.instructionOffsetMap[this.level][oldInstructionOffset] = this.codeLength;
    }

    public void appendInstructions(Instruction[] instructions) {
        for (int index = 0; index < instructions.length; ++index) {
            this.appendInstruction(instructions[index]);
        }
    }

    public void appendInstruction(Instruction instruction) {
        if (this.shrinkInstructions) {
            instruction = instruction.shrink();
        }
        int newCodeLength = this.codeLength + instruction.length(this.codeLength);
        this.ensureCodeLength(newCodeLength);
        this.oldInstructionOffsets[this.codeLength] = 0;
        instruction.accept(null, null, new CodeAttribute(0, 0, 0, 0, this.code, 0, null, 0, null), this.codeLength, this.instructionWriter);
        this.codeLength = newCodeLength;
    }

    public void appendException(ExceptionInfo exceptionInfo) {
        this.addException(exceptionInfo, this.exceptionTableLength);
    }

    public void addException(ExceptionInfo exceptionInfo, int index) {
        this.visitExceptionInfo(null, null, null, exceptionInfo);
        if (exceptionInfo.u2startPC == exceptionInfo.u2endPC) {
            return;
        }
        this.exceptionTable = index == this.exceptionTableLength ? ArrayUtil.add(this.exceptionTable, this.exceptionTableLength++, exceptionInfo) : ArrayUtil.insert(this.exceptionTable, this.exceptionTableLength++, index, exceptionInfo);
    }

    public int insertLineNumber(LineNumberInfo lineNumberInfo) {
        return this.insertLineNumber(0, lineNumberInfo);
    }

    public int insertLineNumber(int minimumIndex, LineNumberInfo lineNumberInfo) {
        this.visitLineNumberInfo(null, null, null, lineNumberInfo);
        this.lineNumberTable = ArrayUtil.extendArray(this.lineNumberTable, this.lineNumberTableLength + 1);
        int index = this.lineNumberTableLength++;
        while (index > minimumIndex && (this.lineNumberTable[index - 1].u2startPC > lineNumberInfo.u2startPC || this.lineNumberTable[index - 1].u2startPC >= lineNumberInfo.u2startPC && this.lineNumberTable[index - 1].u2lineNumber >= 0)) {
            this.lineNumberTable[index--] = this.lineNumberTable[index];
        }
        this.lineNumberTable[index] = lineNumberInfo;
        return index;
    }

    public void appendLineNumber(LineNumberInfo lineNumberInfo) {
        this.visitLineNumberInfo(null, null, null, lineNumberInfo);
        this.lineNumberTable = ArrayUtil.add(this.lineNumberTable, this.lineNumberTableLength++, lineNumberInfo);
    }

    public void endCodeFragment() {
        Instruction instruction;
        if (this.level < 0) {
            throw new IllegalArgumentException("Code fragment not begun [" + this.level + "]");
        }
        for (int instructionOffset = this.codeFragmentOffsets[this.level]; instructionOffset < this.codeLength; instructionOffset += instruction.length(instructionOffset)) {
            instruction = InstructionFactory.create(this.code, instructionOffset);
            if (this.oldInstructionOffsets[instructionOffset] < 0) continue;
            instruction.accept(null, null, null, instructionOffset, this);
            instruction.accept(null, null, new CodeAttribute(0, 0, 0, 0, this.code, 0, null, 0, null), instructionOffset, this.instructionWriter);
        }
        this.maximumCodeLength += this.codeLength - this.codeFragmentOffsets[this.level] - this.codeFragmentLengths[this.level];
        if (this.allowExternalExceptionOffsets) {
            for (int index = 0; index < this.exceptionTableLength; ++index) {
                ExceptionInfo exceptionInfo = this.exceptionTable[index];
                exceptionInfo.u2startPC = this.remapExceptionOffset(exceptionInfo.u2startPC);
                exceptionInfo.u2endPC = this.remapExceptionOffset(exceptionInfo.u2endPC);
                exceptionInfo.u2handlerPC = this.remapExceptionOffset(exceptionInfo.u2handlerPC);
            }
        }
        --this.level;
    }

    public void addCodeAttribute(ProgramClass programClass, ProgramMethod programMethod) {
        this.addCodeAttribute(programClass, programMethod, new ConstantPoolEditor(programClass));
    }

    public void addCodeAttribute(ProgramClass programClass, ProgramMethod programMethod, ConstantPoolEditor constantPoolEditor) {
        CodeAttribute codeAttribute = new CodeAttribute(constantPoolEditor.addUtf8Constant("Code"));
        this.constantPoolEditor = constantPoolEditor;
        this.visitCodeAttribute(programClass, programMethod, codeAttribute);
        this.constantPoolEditor = null;
        new AttributesEditor(programClass, programMethod, false).addAttribute(codeAttribute);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.level != -1) {
            throw new IllegalArgumentException("Code fragment not ended [" + this.level + "]");
        }
        ++this.level;
        if (codeAttribute.u4codeLength < this.codeLength) {
            codeAttribute.code = new byte[this.codeLength];
        }
        codeAttribute.u4codeLength = this.codeLength;
        System.arraycopy(this.code, 0, codeAttribute.code, 0, this.codeLength);
        if (codeAttribute.exceptionTable.length < this.exceptionTableLength) {
            codeAttribute.exceptionTable = new ExceptionInfo[this.exceptionTableLength];
        }
        codeAttribute.u2exceptionTableLength = this.exceptionTableLength;
        System.arraycopy(this.exceptionTable, 0, codeAttribute.exceptionTable, 0, this.exceptionTableLength);
        this.stackSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        this.variableSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        if (this.lineNumberTableLength > 0 && codeAttribute.getAttribute(clazz, "LineNumberTable") == null) {
            ConstantPoolEditor constantPoolEditor = this.constantPoolEditor != null ? this.constantPoolEditor : new ConstantPoolEditor((ProgramClass)clazz);
            int attributeNameIndex = constantPoolEditor.addUtf8Constant("LineNumberTable");
            new AttributesEditor((ProgramClass)clazz, (ProgramMember)((Object)method), codeAttribute, false).addAttribute(new LineNumberTableAttribute(attributeNameIndex, 0, null));
        }
        codeAttribute.attributesAccept(clazz, method, this);
        this.instructionWriter.visitCodeAttribute(clazz, method, codeAttribute);
        --this.level;
    }

    @Override
    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.expectedStackMapFrameOffset = -1;
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.expectedStackMapFrameOffset = 0;
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        if (this.lineNumberTableLength == 0) {
            lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
        } else {
            lineNumberTableAttribute.lineNumberTable = new LineNumberInfo[this.lineNumberTableLength];
            lineNumberTableAttribute.u2lineNumberTableLength = this.lineNumberTableLength;
            System.arraycopy(this.lineNumberTable, 0, lineNumberTableAttribute.lineNumberTable, 0, this.lineNumberTableLength);
        }
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        localVariableTableAttribute.u2localVariableTableLength = this.removeEmptyLocalVariables(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength, codeAttribute.u2maxLocals);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.removeEmptyLocalVariableTypes(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength, codeAttribute.u2maxLocals);
    }

    @Override
    public void visitAnyTypeAnnotationsAttribute(Clazz clazz, TypeAnnotationsAttribute typeAnnotationsAttribute) {
        typeAnnotationsAttribute.typeAnnotationsAccept(clazz, this);
    }

    @Override
    public void visitRuntimeVisibleTypeAnnotationsAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, RuntimeVisibleTypeAnnotationsAttribute runtimeVisibleTypeAnnotationsAttribute) {
        runtimeVisibleTypeAnnotationsAttribute.typeAnnotationsAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitRuntimeInvisibleTypeAnnotationsAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, RuntimeInvisibleTypeAnnotationsAttribute runtimeInvisibleTypeAnnotationsAttribute) {
        runtimeInvisibleTypeAnnotationsAttribute.typeAnnotationsAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        block2: {
            try {
                branchInstruction.branchOffset = this.newBranchOffset(offset, branchInstruction.branchOffset);
                this.oldInstructionOffsets[offset] = -1;
            }
            catch (IllegalArgumentException e) {
                if (this.level != 0 && this.allowExternalBranchTargets) break block2;
                throw e;
            }
        }
    }

    @Override
    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
        block2: {
            try {
                switchInstruction.defaultOffset = this.newBranchOffset(offset, switchInstruction.defaultOffset);
                this.updateJumpOffsets(offset, switchInstruction.jumpOffsets);
                this.oldInstructionOffsets[offset] = -1;
            }
            catch (IllegalArgumentException e) {
                if (this.level != 0 && this.allowExternalBranchTargets) break block2;
                throw e;
            }
        }
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        int startPC = exceptionInfo.u2startPC;
        exceptionInfo.u2startPC = !this.allowExternalExceptionOffsets || this.remappableExceptionOffset(startPC) ? this.newInstructionOffset(startPC) : -startPC;
        int endPC = exceptionInfo.u2endPC;
        exceptionInfo.u2endPC = !this.allowExternalExceptionOffsets || this.remappableExceptionOffset(endPC) ? this.newInstructionOffset(endPC) : -endPC;
        int handlerPC = exceptionInfo.u2handlerPC;
        exceptionInfo.u2handlerPC = !this.allowExternalExceptionOffsets || this.remappableExceptionOffset(handlerPC) ? this.newInstructionOffset(handlerPC) : -handlerPC;
    }

    @Override
    public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, StackMapFrame stackMapFrame) {
        int stackMapFrameOffset;
        int offsetDelta = stackMapFrameOffset = this.newInstructionOffset(offset);
        if (this.expectedStackMapFrameOffset >= 0) {
            offsetDelta -= this.expectedStackMapFrameOffset;
            this.expectedStackMapFrameOffset = stackMapFrameOffset + 1;
        }
        stackMapFrame.u2offsetDelta = offsetDelta;
    }

    @Override
    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SameOneFrame sameOneFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, offset, sameOneFrame);
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, offset, this);
    }

    @Override
    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, MoreZeroFrame moreZeroFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, offset, moreZeroFrame);
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, offset, this);
    }

    @Override
    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, FullFrame fullFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, offset, fullFrame);
        fullFrame.variablesAccept(clazz, method, codeAttribute, offset, this);
        fullFrame.stackAccept(clazz, method, codeAttribute, offset, this);
    }

    @Override
    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VerificationType verificationType) {
    }

    @Override
    public void visitUninitializedType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, UninitializedType uninitializedType) {
        uninitializedType.u2newInstructionOffset = this.newInstructionOffset(uninitializedType.u2newInstructionOffset);
    }

    @Override
    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        lineNumberInfo.u2startPC = this.newInstructionOffset(lineNumberInfo.u2startPC);
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        int startPC = this.newInstructionOffset(localVariableInfo.u2startPC);
        int endPC = this.newInstructionOffset(localVariableInfo.u2startPC + localVariableInfo.u2length);
        localVariableInfo.u2startPC = startPC;
        localVariableInfo.u2length = endPC - startPC;
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        int startPC = this.newInstructionOffset(localVariableTypeInfo.u2startPC);
        int endPC = this.newInstructionOffset(localVariableTypeInfo.u2startPC + localVariableTypeInfo.u2length);
        localVariableTypeInfo.u2startPC = startPC;
        localVariableTypeInfo.u2length = endPC - startPC;
    }

    @Override
    public void visitTypeAnnotation(Clazz clazz, TypeAnnotation typeAnnotation) {
        typeAnnotation.targetInfoAccept(clazz, this);
    }

    @Override
    public void visitTypeAnnotation(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation) {
        typeAnnotation.targetInfoAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitAnyTargetInfo(Clazz clazz, TypeAnnotation typeAnnotation, TargetInfo targetInfo) {
    }

    @Override
    public void visitLocalVariableTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, LocalVariableTargetInfo localVariableTargetInfo) {
        localVariableTargetInfo.targetElementsAccept(clazz, method, codeAttribute, typeAnnotation, this);
        localVariableTargetInfo.u2tableLength = this.removeEmptyLocalVariableTargetElements(localVariableTargetInfo.table, localVariableTargetInfo.u2tableLength, codeAttribute.u2maxLocals);
    }

    @Override
    public void visitOffsetTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, OffsetTargetInfo offsetTargetInfo) {
        offsetTargetInfo.u2offset = this.newInstructionOffset(offsetTargetInfo.u2offset);
    }

    @Override
    public void visitTypeArgumentTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, TypeArgumentTargetInfo typeArgumentTargetInfo) {
        typeArgumentTargetInfo.u2offset = this.newInstructionOffset(typeArgumentTargetInfo.u2offset);
    }

    @Override
    public void visitLocalVariableTargetElement(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, LocalVariableTargetInfo localVariableTargetInfo, LocalVariableTargetElement localVariableTargetElement) {
        int startPC = this.newInstructionOffset(localVariableTargetElement.u2startPC);
        int endPC = this.newInstructionOffset(localVariableTargetElement.u2startPC + localVariableTargetElement.u2length);
        localVariableTargetElement.u2startPC = startPC;
        localVariableTargetElement.u2length = endPC - startPC;
    }

    private void ensureCodeLength(int newCodeLength) {
        if (this.code.length < newCodeLength) {
            newCodeLength = newCodeLength * 6 / 5;
            this.code = ArrayUtil.extendArray(this.code, newCodeLength);
            this.oldInstructionOffsets = ArrayUtil.extendArray(this.oldInstructionOffsets, newCodeLength);
            this.instructionWriter.extend(newCodeLength);
        }
    }

    private void ensureFragmentLength(int newFragmentLength) {
        if (this.codeFragmentLengths[this.level] < newFragmentLength) {
            this.codeFragmentLengths[this.level] = newFragmentLength;
            int oldFragmentLength = this.instructionOffsetMap[this.level].length;
            if (newFragmentLength > oldFragmentLength) {
                newFragmentLength = newFragmentLength * 6 / 5;
                this.instructionOffsetMap[this.level] = ArrayUtil.extendArray(this.instructionOffsetMap[this.level], newFragmentLength);
                Arrays.fill(this.instructionOffsetMap[this.level], oldFragmentLength, newFragmentLength, -1);
            }
        }
    }

    private void updateJumpOffsets(int offset, int[] jumpOffsets) {
        for (int index = 0; index < jumpOffsets.length; ++index) {
            jumpOffsets[index] = this.newBranchOffset(offset, jumpOffsets[index]);
        }
    }

    private int newBranchOffset(int newInstructionOffset, int oldBranchOffset) {
        if (newInstructionOffset < 0 || newInstructionOffset > this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + newInstructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        int oldInstructionOffset = this.absoluteBranchOffsets ? 0 : this.oldInstructionOffsets[newInstructionOffset];
        return this.newInstructionOffset(oldInstructionOffset + oldBranchOffset) - newInstructionOffset;
    }

    private int newInstructionOffset(int oldInstructionOffset) {
        if (oldInstructionOffset < 0 || oldInstructionOffset > this.codeFragmentLengths[this.level]) {
            throw new IllegalArgumentException("Instruction offset [" + oldInstructionOffset + "] out of range in code fragment with length [" + this.codeFragmentLengths[this.level] + "] at level " + this.level);
        }
        int newInstructionOffset = this.instructionOffsetMap[this.level][oldInstructionOffset];
        if (newInstructionOffset == -1) {
            throw new IllegalArgumentException("Invalid instruction offset [" + oldInstructionOffset + "] in code fragment at level " + this.level);
        }
        return newInstructionOffset;
    }

    private int remapExceptionOffset(int oldInstructionOffset) {
        if (oldInstructionOffset < 0) {
            if (this.remappableExceptionOffset(oldInstructionOffset = -oldInstructionOffset)) {
                return this.newInstructionOffset(oldInstructionOffset);
            }
            if (this.level == 0) {
                throw new IllegalStateException("Couldn't remap exception offset [" + oldInstructionOffset + "]");
            }
        }
        return oldInstructionOffset;
    }

    private boolean remappableExceptionOffset(int oldInstructionOffset) {
        if (oldInstructionOffset > this.codeFragmentLengths[this.level]) {
            return false;
        }
        int newInstructionOffset = this.instructionOffsetMap[this.level][oldInstructionOffset];
        return newInstructionOffset > -1;
    }

    private int removeEmptyExceptions(ExceptionInfo[] exceptionInfos, int exceptionInfoCount) {
        int newIndex = 0;
        for (int index = 0; index < exceptionInfoCount; ++index) {
            ExceptionInfo exceptionInfo = exceptionInfos[index];
            if (exceptionInfo.u2startPC >= exceptionInfo.u2endPC) continue;
            exceptionInfos[newIndex++] = exceptionInfo;
        }
        Arrays.fill(exceptionInfos, newIndex, exceptionInfoCount, null);
        return newIndex;
    }

    private int removeEmptyLineNumbers(LineNumberInfo[] lineNumberInfos, int lineNumberInfoCount, int codeLength) {
        int newIndex = 0;
        for (int index = 0; index < lineNumberInfoCount; ++index) {
            LineNumberInfo lineNumberInfo = lineNumberInfos[index];
            int startPC = lineNumberInfo.u2startPC;
            if (startPC >= codeLength || index != 0 && startPC <= lineNumberInfos[index - 1].u2startPC) continue;
            lineNumberInfos[newIndex++] = lineNumberInfo;
        }
        Arrays.fill(lineNumberInfos, newIndex, lineNumberInfoCount, null);
        return newIndex;
    }

    private int removeEmptyLocalVariables(LocalVariableInfo[] localVariableInfos, int localVariableInfoCount, int maxLocals) {
        int newIndex = 0;
        for (int index = 0; index < localVariableInfoCount; ++index) {
            LocalVariableInfo localVariableInfo = localVariableInfos[index];
            if (localVariableInfo.u2length <= 0 || localVariableInfo.u2index >= maxLocals) continue;
            localVariableInfos[newIndex++] = localVariableInfo;
        }
        Arrays.fill(localVariableInfos, newIndex, localVariableInfoCount, null);
        return newIndex;
    }

    private int removeEmptyLocalVariableTypes(LocalVariableTypeInfo[] localVariableTypeInfos, int localVariableTypeInfoCount, int maxLocals) {
        int newIndex = 0;
        for (int index = 0; index < localVariableTypeInfoCount; ++index) {
            LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeInfos[index];
            if (localVariableTypeInfo.u2length <= 0 || localVariableTypeInfo.u2index >= maxLocals) continue;
            localVariableTypeInfos[newIndex++] = localVariableTypeInfo;
        }
        Arrays.fill(localVariableTypeInfos, newIndex, localVariableTypeInfoCount, null);
        return newIndex;
    }

    private int removeEmptyLocalVariableTargetElements(LocalVariableTargetElement[] localVariableTargetElements, int localVariableTargetElementCount, int maxLocals) {
        int newIndex = 0;
        for (int index = 0; index < localVariableTargetElementCount; ++index) {
            LocalVariableTargetElement localVariableTargetElement = localVariableTargetElements[index];
            if (localVariableTargetElement.u2length <= 0 || localVariableTargetElement.u2index >= maxLocals) continue;
            localVariableTargetElements[newIndex++] = localVariableTargetElement;
        }
        Arrays.fill(localVariableTargetElements, newIndex, localVariableTargetElementCount, null);
        return newIndex;
    }

    private void println(String string1, String string2) {
        this.print(string1, string2);
        System.out.println();
    }

    private void print(String string1, String string2) {
        System.out.print(string1);
        for (int index = 0; index < this.level; ++index) {
            System.out.print("  ");
        }
        System.out.print(string2);
    }

    public static void main(String[] args) {
        ProgramClass programClass = new ProgramClass(0x340000, 1, new Constant[10], 1, 0, 0);
        ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
        programClass.u2thisClass = constantPoolEditor.addClassConstant("com/example/Test", (Clazz)programClass);
        programClass.u2superClass = constantPoolEditor.addClassConstant("java/lang/Object", null);
        ProgramMethod programMethod = new ProgramMethod(1, constantPoolEditor.addUtf8Constant("test"), constantPoolEditor.addUtf8Constant("()I"), null);
        ClassEditor classEditor = new ClassEditor(programClass);
        classEditor.addMethod(programMethod);
        int exceptionType = constantPoolEditor.addClassConstant("java/lang/Exception", null);
        CodeAttributeComposer composer = new CodeAttributeComposer();
        boolean TRY_LABEL = false;
        boolean IF_LABEL = true;
        int THEN_LABEL = 10;
        int ELSE_LABEL = 20;
        int CATCH_LABEL = 30;
        composer.beginCodeFragment(50);
        composer.appendLabel(0);
        composer.appendInstruction(new SimpleInstruction(4));
        composer.appendInstruction(new SimpleInstruction(5));
        composer.appendLabel(1);
        composer.appendInstruction(new BranchInstruction(-95, 19));
        composer.appendLabel(10);
        composer.appendInstruction(new SimpleInstruction(4));
        composer.appendInstruction(new SimpleInstruction(-84));
        composer.appendLabel(20);
        composer.appendInstruction(new SimpleInstruction(5));
        composer.appendInstruction(new SimpleInstruction(-84));
        composer.appendLabel(30);
        composer.appendException(new ExceptionInfo(0, 30, 30, exceptionType));
        composer.appendInstruction(new SimpleInstruction(2));
        composer.appendInstruction(new SimpleInstruction(-84));
        composer.endCodeFragment();
        composer.addCodeAttribute(programClass, programMethod, constantPoolEditor);
        programClass.accept(new ClassPrinter());
    }
}

