/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MultiValueMap<K, V> {
    private final Map<K, Set<V>> keyValueMap = this.createKeyMap();
    private final Set<V> values = this.createValueSet();

    protected Set<V> createValueSet() {
        return new LinkedHashSet();
    }

    protected Map<K, Set<V>> createKeyMap() {
        return new LinkedHashMap();
    }

    public int size() {
        return this.keyValueMap.size();
    }

    public Set<K> keySet() {
        return this.keyValueMap.keySet();
    }

    public Collection<Set<V>> values() {
        return this.keyValueMap.values();
    }

    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return this.keyValueMap.entrySet();
    }

    public void put(K key, V value) {
        this.putAll(key, Collections.singleton(value));
    }

    public void putAll(Set<K> key, V value) {
        this.putAll((K)key, Collections.singleton(value));
    }

    public void putAll(Set<K> keys2, Set<V> values2) {
        for (K key : keys2) {
            this.putAll(key, values2);
        }
    }

    public void putAll(K key, Set<V> values2) {
        this.values.addAll(values2);
        Set<V> existingValues = this.keyValueMap.get(key);
        if (existingValues == null) {
            existingValues = this.createValueSet();
            this.keyValueMap.put(key, existingValues);
        }
        existingValues.addAll(values2);
    }

    public boolean remove(K key, V value) {
        Set<V> values2 = this.keyValueMap.get(key);
        return values2 != null && values2.remove(value);
    }

    public Set<V> get(K key) {
        return this.keyValueMap.get(key);
    }

    public Set<V> getValues() {
        return this.values;
    }

    public void clear() {
        this.keyValueMap.clear();
        this.values.clear();
    }
}

