/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.logging.log4j.Level;

class ObjectHolderRef {
    private Field field;
    private String injectedObject;
    private boolean isBlock;
    private boolean isItem;
    private static Field modifiersField;
    private static Object reflectionFactory;
    private static Method newFieldAccessor;
    private static Method fieldAccessorSet;

    ObjectHolderRef(Field field, String injectedObject, boolean extractFromExistingValues) {
        this.field = field;
        this.isBlock = aji.class.isAssignableFrom(field.getType());
        this.isItem = adb.class.isAssignableFrom(field.getType());
        if (extractFromExistingValues) {
            try {
                Object existing = field.get(null);
                if (existing == null || existing == GameData.getBlockRegistry().getDefaultValue()) {
                    this.injectedObject = null;
                    this.field = null;
                    this.isBlock = false;
                    this.isItem = false;
                    return;
                }
                this.injectedObject = this.isBlock ? GameData.getBlockRegistry().c(existing) : (this.isItem ? GameData.getItemRegistry().c(existing) : null);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else {
            this.injectedObject = injectedObject;
        }
        if (this.injectedObject == null || !this.isValid()) {
            throw new IllegalStateException(String.format("The ObjectHolder annotation cannot apply to a field that is not an Item or Block (found : %s at %s.%s)", field.getType().getName(), field.getClass().getName(), field.getName()));
        }
        ObjectHolderRef.makeWritable(field);
    }

    private static void makeWritable(Field f) {
        try {
            if (modifiersField == null) {
                Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
                reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
                newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
                fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
                modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
            }
            modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public boolean isValid() {
        return this.isBlock || this.isItem;
    }

    public void apply() {
        Object thing;
        if (this.isBlock) {
            thing = GameData.getBlockRegistry().a(this.injectedObject);
            if (thing == ajn.a) {
                thing = null;
            }
        } else {
            thing = this.isItem ? GameData.getItemRegistry().a(this.injectedObject) : null;
        }
        if (thing == null) {
            FMLLog.getLogger().log(Level.DEBUG, "Unable to lookup {} for {}. This means the object wasn't registered. It's likely just mod options.", new Object[]{this.injectedObject, this.field});
            return;
        }
        try {
            Object fieldAccessor = newFieldAccessor.invoke(reflectionFactory, this.field, false);
            fieldAccessorSet.invoke(fieldAccessor, null, thing);
        }
        catch (Exception e) {
            FMLLog.log(Level.WARN, e, "Unable to set %s with value %s (%s)", this.field, thing, this.injectedObject);
        }
    }
}

