/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.minecraft.HttpMinecraftSessionService;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.request.JoinMinecraftServerRequest;
import com.mojang.authlib.yggdrasil.response.HasJoinedMinecraftServerResponse;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.authlib.yggdrasil.response.Response;
import com.mojang.util.UUIDTypeAdapter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class YggdrasilMinecraftSessionService
extends HttpMinecraftSessionService {
    private static final String[] WHITELISTED_DOMAINS = new String[]{".minecraft.net", ".mojang.com"};
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BASE_URL = "https://sessionserver.mojang.com/session/minecraft/";
    private static final URL JOIN_URL = HttpAuthenticationService.constantURL("https://sessionserver.mojang.com/session/minecraft/join");
    private static final URL CHECK_URL = HttpAuthenticationService.constantURL("https://sessionserver.mojang.com/session/minecraft/hasJoined");
    private static final String SERVER_ADDRESS = "http://auth.tlauncher.org";
    private static final String VERSION = "1.5.21";
    private final PublicKey publicKey;
    private final Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();
    private final LoadingCache<GameProfile, GameProfile> insecureProfiles = CacheBuilder.newBuilder().expireAfterWrite(6L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<GameProfile, GameProfile>(){

        public GameProfile load(GameProfile key) throws Exception {
            return YggdrasilMinecraftSessionService.this.fillGameProfile(key, false);
        }
    });
    private final TextureCache textureCache = new TextureCache();
    private boolean defaultCustomTextures = true;

    protected YggdrasilMinecraftSessionService(YggdrasilAuthenticationService authenticationService) {
        super(authenticationService);
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(IOUtils.toByteArray((InputStream)YggdrasilMinecraftSessionService.class.getResourceAsStream("/yggdrasil_session_pubkey.der")));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.publicKey = keyFactory.generatePublic(spec);
        }
        catch (Exception e) {
            throw new Error("Missing/invalid yggdrasil public key!");
        }
        try {
            Class.forName("org.tlauncher.skin.cape.TLSkinCape", false, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException e) {
            this.defaultCustomTextures = false;
            LOGGER.info("used the old auth tlauncher service");
        }
    }

    private static boolean isWhitelistedDomain(String url) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL '" + url + "'");
        }
        String domain = uri.getHost();
        for (int i = 0; i < WHITELISTED_DOMAINS.length; ++i) {
            if (!domain.endsWith(WHITELISTED_DOMAINS[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void joinServer(GameProfile profile, String authenticationToken, String serverId) throws AuthenticationException {
        try {
            JoinMinecraftServerRequest request = new JoinMinecraftServerRequest();
            request.accessToken = authenticationToken;
            request.selectedProfile = profile.getId();
            request.serverId = serverId;
            this.getAuthenticationService().makeRequest(JOIN_URL, request, Response.class);
        }
        catch (InvalidCredentialsException e) {
            LOGGER.debug((Object)e);
        }
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile user, String serverId) throws AuthenticationUnavailableException {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("username", user.getName());
        arguments.put("serverId", serverId);
        URL url = HttpAuthenticationService.concatenateURL(CHECK_URL, HttpAuthenticationService.buildQuery(arguments));
        try {
            HasJoinedMinecraftServerResponse response = this.getAuthenticationService().makeRequest(url, null, HasJoinedMinecraftServerResponse.class);
            if (response != null && response.getId() != null) {
                GameProfile result = new GameProfile(response.getId(), user.getName());
                if (response.getProperties() != null) {
                    result.getProperties().putAll((Multimap)response.getProperties());
                }
                return result;
            }
            return null;
        }
        catch (AuthenticationUnavailableException e) {
            throw e;
        }
        catch (AuthenticationException authenticationException) {
            return null;
        }
    }

    @Override
    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextures(GameProfile profile, boolean requireSecure) {
        LOGGER.info("defaultCustomTextures " + this.defaultCustomTextures);
        if (this.defaultCustomTextures) {
            return this.getDefaultTexturesAuthMethod(profile, requireSecure);
        }
        return this.requestTLAuthService(profile, requireSecure);
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getDefaultTexturesAuthMethod(GameProfile profile, boolean requireSecure) {
        MinecraftTexturesPayload result;
        Property textureProperty = (Property)Iterables.getFirst((Iterable)profile.getProperties().get("textures"), null);
        if (textureProperty == null) {
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        try {
            String json = new String(Base64.decodeBase64((String)textureProperty.getValue()), org.apache.commons.codec.Charsets.UTF_8);
            result = (MinecraftTexturesPayload)this.gson.fromJson(json, MinecraftTexturesPayload.class);
        }
        catch (JsonParseException e) {
            LOGGER.error("Could not decode textures payload", (Throwable)e);
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        if (result.getTextures() == null) {
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        for (Map.Entry<MinecraftProfileTexture.Type, MinecraftProfileTexture> entry : result.getTextures().entrySet()) {
            if (YggdrasilMinecraftSessionService.isWhitelistedDomain(entry.getValue().getUrl())) continue;
            LOGGER.error("Textures payload has been tampered with (non-whitelisted domain)");
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        LOGGER.info(String.format("name='%s', profilename='%s' additional = '%s'", profile.getName(), result.getProfileName(), result.getProfileId()));
        LOGGER.info(result.getTextures());
        return result.getTextures();
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> requestTLAuthService(GameProfile profile, boolean requireSecure) {
        if (Thread.currentThread().getName().equals("Client thread")) {
            MinecraftTexturesPayload result;
            Property textureProperty = (Property)Iterables.getFirst((Iterable)profile.getProperties().get("textures"), null);
            CachedTextureMap cached = this.textureCache.get(profile.getName());
            if (cached != null) {
                return cached.getTextureMap();
            }
            if (textureProperty == null) {
                return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
            }
            try {
                String json = new String(Base64.decodeBase64((String)textureProperty.getValue()), Charsets.UTF_8);
                result = (MinecraftTexturesPayload)this.gson.fromJson(json, MinecraftTexturesPayload.class);
            }
            catch (JsonParseException e) {
                LOGGER.error("Could not decode textures payload", (Throwable)e);
                return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
            }
            if (result.getTextures() == null) {
                return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
            }
            return result.getTextures();
        }
        return this.doTextureRequest(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> doTextureRequest(GameProfile profile) {
        Map<Object, Object> textureMap;
        block6: {
            block7: {
                CachedTextureMap cached = this.textureCache.get(profile.getName());
                if (cached != null) {
                    LOGGER.debug("Got from cache {}", new Object[]{cached.getTextureMap()});
                    return cached.getTextureMap();
                }
                textureMap = null;
                StringWriter writer = new StringWriter();
                String requestUrl = null;
                String response = null;
                if (profile.getName() == null || profile.getName().isEmpty()) break block7;
                InputStream inputStream = null;
                try {
                    long l = System.currentTimeMillis();
                    requestUrl = String.format("http://auth.tlauncher.org/skin/profile/texture/login/%s?auth_lib=%s", URLEncoder.encode(profile.getName(), "UTF-8"), VERSION);
                    URL url = new URL(requestUrl);
                    inputStream = url.openStream();
                    IOUtils.copy((InputStream)inputStream, (Writer)writer);
                    response = writer.toString();
                    textureMap = (Map)this.gson.fromJson(response, new TypeToken<HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>>(){}.getType());
                    LOGGER.debug(" request: {}\r\nresult: {} \r\nduring: {}", new Object[]{requestUrl, textureMap, (System.currentTimeMillis() - l) / 1000L});
                }
                catch (Exception e) {
                    try {
                        textureMap = new HashMap();
                        LOGGER.error("Could not fetch tlauncher skin. Profile: {}, URL: {}, response: \"{}\"", new Object[]{profile, requestUrl, response});
                        LOGGER.error((Object)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                    break block6;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                break block6;
            }
            textureMap = new HashMap();
        }
        if (textureMap.isEmpty()) {
            textureMap = this.getTexturesServer(profile);
            LOGGER.info(" get inner resource: {}\r\nresult: {} \r\n", new Object[]{profile.getName(), textureMap});
        }
        this.textureCache.add(profile.getName(), textureMap);
        return textureMap;
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTexturesServer(GameProfile profile) {
        MinecraftTexturesPayload result;
        Property textureProperty = (Property)Iterables.getFirst((Iterable)profile.getProperties().get("textures"), null);
        if (textureProperty == null) {
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        try {
            String json = new String(Base64.decodeBase64((String)textureProperty.getValue()), org.apache.commons.codec.Charsets.UTF_8);
            result = (MinecraftTexturesPayload)this.gson.fromJson(json, MinecraftTexturesPayload.class);
        }
        catch (JsonParseException e) {
            LOGGER.error("Could not decode textures payload", (Throwable)e);
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        if (result.getTextures() == null) {
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        return result.getTextures();
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile profile, boolean requireSecure) {
        if (profile.getId() == null) {
            return profile;
        }
        if (!requireSecure) {
            return (GameProfile)this.insecureProfiles.getUnchecked((Object)profile);
        }
        return this.fillGameProfile(profile, true);
    }

    protected GameProfile fillGameProfile(GameProfile profile, boolean requireSecure) {
        try {
            URL url = HttpAuthenticationService.constantURL("https://sessionserver.mojang.com/session/minecraft/profile/" + UUIDTypeAdapter.fromUUID(profile.getId()));
            url = HttpAuthenticationService.concatenateURL(url, "unsigned=" + !requireSecure);
            MinecraftProfilePropertiesResponse response = this.getAuthenticationService().makeRequest(url, null, MinecraftProfilePropertiesResponse.class);
            if (response == null) {
                LOGGER.debug("Couldn't fetch profile properties for " + profile + " as the profile does not exist");
                return profile;
            }
            GameProfile result = new GameProfile(response.getId(), response.getName());
            result.getProperties().putAll((Multimap)response.getProperties());
            profile.getProperties().putAll((Multimap)response.getProperties());
            LOGGER.debug("Successfully fetched profile properties for " + profile);
            return result;
        }
        catch (Throwable e) {
            LOGGER.warn("Couldn't look up profile properties for " + profile, e);
            return profile;
        }
    }

    @Override
    public YggdrasilAuthenticationService getAuthenticationService() {
        return (YggdrasilAuthenticationService)super.getAuthenticationService();
    }

    private class CachedTextureMap {
        private final Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textureMap;
        private final long expiration;

        public CachedTextureMap(long textureMap) {
            this.textureMap = new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
            this.expiration = textureMap;
        }

        public CachedTextureMap(YggdrasilMinecraftSessionService yggdrasilMinecraftSessionService2, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textureMap2, long l) {
            this.expiration = l;
            this.textureMap = textureMap2;
        }

        public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextureMap() {
            return this.textureMap;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expiration;
        }
    }

    private class TextureCache {
        private final Map<String, CachedTextureMap> cache = new HashMap<String, CachedTextureMap>();

        private TextureCache() {
        }

        public synchronized void add(String name, CachedTextureMap cachedTextureMap) {
            if (this.cache.containsKey(name)) {
                this.cache.remove(name);
            }
            this.cache.put(name, cachedTextureMap);
        }

        public synchronized void add(String name, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textureMap) {
            this.add(name, new CachedTextureMap(YggdrasilMinecraftSessionService.this, textureMap, System.currentTimeMillis() + 60000L));
        }

        public synchronized CachedTextureMap get(String name) {
            CachedTextureMap cached = this.cache.get(name);
            if (cached == null) {
                return null;
            }
            if (cached.isExpired()) {
                this.cache.remove(name);
                return null;
            }
            return cached;
        }
    }
}

