/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.security;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.security.AlertRule;
import com.jaquadro.minecraft.storagedrawers.security.Server;
import java.io.File;
import java.io.FileWriter;
import java.util.List;

public class ConfigManager {
    private static ConfigManager instance;
    private final String discordWebHookURL;
    private List<Server> servers;
    private List<AlertRule> alertRules;

    public ConfigManager() {
        instance = this;
        this.discordWebHookURL = ":)";
        this.servers = Lists.newArrayList();
        this.alertRules = Lists.newArrayList();
    }

    public void setInstance() {
        instance = this;
    }

    public static ConfigManager getInstance() {
        return instance;
    }

    public void save() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String content = gson.toJson((Object)this);
        File file = new File(StorageDrawers.configDirectory.getAbsolutePath(), "storagedrawers/DrawerSecurity.json");
        try {
            FileWriter writer = new FileWriter(file, false);
            writer.write(content);
            writer.close();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public void setServers(List<Server> servers) {
        this.servers = servers;
    }

    public List<AlertRule> getAlertRules() {
        return this.alertRules;
    }

    public void setAlertRules(List<AlertRule> alertRules) {
        this.alertRules = alertRules;
    }

    public String getDiscordWebHookURL() {
        return this.discordWebHookURL;
    }

    public static void setInstance(ConfigManager instance) {
        ConfigManager.instance = instance;
    }
}

