/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.block.utils;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.block.SpawnerBlock;
import fr.vartax.init.register.RegisterBlock;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;

public abstract class MobSpawnerBaseLogic {
    boolean truc = false;
    public int spawnDelay = 20;
    private int entityTypeName = 90;
    private List potentialEntitySpawns;
    private WeightedRandomMinecart randomEntity;
    public double field_98287_c;
    public double field_98284_d;
    private int minSpawnDelay = 50;
    private int maxSpawnDelay = 500;
    private int spawnCount = 5;
    private Entity field_98291_j;
    private int maxNearbyEntities = 6;
    private int activatingRangeFromPlayer = 16;
    private int spawnRange = 4;

    public int getEntityNameToSpawn() {
        return this.entityTypeName;
    }

    public void setEntityName(int p_98272_1_) {
        this.entityTypeName = p_98272_1_;
    }

    public boolean isActivated() {
        return this.getSpawnerWorld().func_72977_a((double)this.getSpawnerX() + 0.5, (double)this.getSpawnerY() + 0.5, (double)this.getSpawnerZ() + 0.5, (double)this.activatingRangeFromPlayer) != null;
    }

    public void updateSpawner() {
        if (this.isActivated()) {
            if (!this.truc) {
                Block temp = this.getSpawnerWorld().func_147439_a(this.getSpawnerX(), this.getSpawnerY(), this.getSpawnerZ());
                this.truc = true;
                if (temp instanceof SpawnerBlock) {
                    this.setEntityName(((SpawnerBlock)temp).id);
                }
            }
            if (this.truc) {
                if (this.getSpawnerWorld().field_72995_K) {
                    double d0 = (float)this.getSpawnerX() + this.getSpawnerWorld().field_73012_v.nextFloat();
                    double d1 = (float)this.getSpawnerY() + this.getSpawnerWorld().field_73012_v.nextFloat();
                    double d2 = (float)this.getSpawnerZ() + this.getSpawnerWorld().field_73012_v.nextFloat();
                    this.getSpawnerWorld().func_72869_a("smoke", d0, d1, d2, 0.0, 0.0, 0.0);
                    this.getSpawnerWorld().func_72869_a("flame", d0, d1, d2, 0.0, 0.0, 0.0);
                    if (this.spawnDelay > 0) {
                        --this.spawnDelay;
                    }
                    this.field_98284_d = this.field_98287_c;
                    this.field_98287_c = (this.field_98287_c + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
                } else {
                    if (this.spawnDelay == -1) {
                        this.resetTimer();
                    }
                    if (this.spawnDelay > 0) {
                        --this.spawnDelay;
                        return;
                    }
                    boolean flag = false;
                    int i = 0;
                    while (true) {
                        if (i >= this.spawnCount) {
                            if (!flag) break;
                            this.resetTimer();
                            break;
                        }
                        Object entity = null;
                        try {
                            Class classe = RegisterBlock.AllSpawner.get(this.entityTypeName);
                            Constructor constructeur = classe.getConstructor(World.class);
                            entity = (Entity)constructeur.newInstance(this.getSpawnerWorld());
                        }
                        catch (InstantiationException var12) {
                            var12.printStackTrace();
                        }
                        catch (IllegalAccessException var13) {
                            var13.printStackTrace();
                        }
                        catch (NoSuchMethodException var14) {
                            var14.printStackTrace();
                        }
                        catch (SecurityException var15) {
                            var15.printStackTrace();
                        }
                        catch (IllegalArgumentException var16) {
                            var16.printStackTrace();
                        }
                        catch (InvocationTargetException var17) {
                            var17.printStackTrace();
                        }
                        if (entity == null) {
                            return;
                        }
                        int j = this.getSpawnerWorld().func_72872_a(entity.getClass(), AxisAlignedBB.func_72330_a((double)this.getSpawnerX(), (double)this.getSpawnerY(), (double)this.getSpawnerZ(), (double)(this.getSpawnerX() + 1), (double)(this.getSpawnerY() + 1), (double)(this.getSpawnerZ() + 1)).func_72314_b((double)(this.spawnRange * 2), 4.0, (double)(this.spawnRange * 2))).size();
                        if (j >= this.maxNearbyEntities) {
                            this.resetTimer();
                            return;
                        }
                        double d2 = (double)this.getSpawnerX() + (this.getSpawnerWorld().field_73012_v.nextDouble() - this.getSpawnerWorld().field_73012_v.nextDouble()) * (double)this.spawnRange;
                        double d3 = this.getSpawnerY() + this.getSpawnerWorld().field_73012_v.nextInt(3) - 1;
                        double d4 = (double)this.getSpawnerZ() + (this.getSpawnerWorld().field_73012_v.nextDouble() - this.getSpawnerWorld().field_73012_v.nextDouble()) * (double)this.spawnRange;
                        EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                        entity.func_70012_b(d2, d3, d4, this.getSpawnerWorld().field_73012_v.nextFloat() * 360.0f, 0.0f);
                        if (entityliving == null || entityliving.func_70601_bi()) {
                            this.func_98265_a((Entity)entity);
                            this.getSpawnerWorld().func_72926_e(2004, this.getSpawnerX(), this.getSpawnerY(), this.getSpawnerZ(), 0);
                            if (entityliving != null) {
                                entityliving.func_70656_aK();
                            }
                            flag = true;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public Entity func_98265_a(Entity p_98265_1_) {
        if (this.getRandomEntity() != null) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            p_98265_1_.func_70039_c(nbttagcompound);
            for (String s : this.getRandomEntity().field_98222_b.func_150296_c()) {
                NBTBase nbtbase = this.getRandomEntity().field_98222_b.func_74781_a(s);
                nbttagcompound.func_74782_a(s, nbtbase.func_74737_b());
            }
            p_98265_1_.func_70020_e(nbttagcompound);
            if (p_98265_1_.field_70170_p != null) {
                p_98265_1_.field_70170_p.func_72838_d(p_98265_1_);
            }
            Entity entity1 = p_98265_1_;
            while (nbttagcompound.func_150297_b("Riding", 10)) {
                NBTTagCompound nbttagcompound2 = nbttagcompound.func_74775_l("Riding");
                Entity entity2 = EntityList.func_75620_a((String)nbttagcompound2.func_74779_i("id"), (World)p_98265_1_.field_70170_p);
                if (entity2 != null) {
                    NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                    entity2.func_70039_c(nbttagcompound1);
                    for (String s1 : nbttagcompound2.func_150296_c()) {
                        NBTBase nbtbase1 = nbttagcompound2.func_74781_a(s1);
                        nbttagcompound1.func_74782_a(s1, nbtbase1.func_74737_b());
                    }
                    entity2.func_70020_e(nbttagcompound1);
                    entity2.func_70012_b(entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v, entity1.field_70177_z, entity1.field_70125_A);
                    if (p_98265_1_.field_70170_p != null) {
                        p_98265_1_.field_70170_p.func_72838_d(entity2);
                    }
                    entity1.func_70078_a(entity2);
                }
                entity1 = entity2;
                nbttagcompound = nbttagcompound2;
            }
        } else if (p_98265_1_ instanceof EntityLivingBase && p_98265_1_.field_70170_p != null) {
            ((EntityLiving)p_98265_1_).func_110161_a((IEntityLivingData)null);
            this.getSpawnerWorld().func_72838_d(p_98265_1_);
        }
        return p_98265_1_;
    }

    private void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.getSpawnerWorld().field_73012_v.nextInt(i);
        }
        if (this.potentialEntitySpawns != null && this.potentialEntitySpawns.size() > 0) {
            this.setRandomEntity((WeightedRandomMinecart)WeightedRandom.func_76271_a((Random)this.getSpawnerWorld().field_73012_v, (Collection)this.potentialEntitySpawns));
        }
        this.func_98267_a(1);
    }

    public void readFromNBT(NBTTagCompound p_98270_1_) {
        this.entityTypeName = p_98270_1_.func_74762_e("EntityId");
        this.truc = p_98270_1_.func_74767_n("truc");
        this.spawnDelay = p_98270_1_.func_74765_d("Delay");
        if (p_98270_1_.func_150297_b("SpawnPotentials", 9)) {
            this.potentialEntitySpawns = new ArrayList();
            NBTTagList nbttaglist = p_98270_1_.func_150295_c("SpawnPotentials", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                this.potentialEntitySpawns.add(new WeightedRandomMinecart(nbttaglist.func_150305_b(i)));
            }
        } else {
            this.potentialEntitySpawns = null;
        }
        if (p_98270_1_.func_150297_b("MinSpawnDelay", 99)) {
            this.minSpawnDelay = p_98270_1_.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = p_98270_1_.func_74765_d("MaxSpawnDelay");
            this.spawnCount = p_98270_1_.func_74765_d("SpawnCount");
        }
        if (p_98270_1_.func_150297_b("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = p_98270_1_.func_74765_d("MaxNearbyEntities");
            this.activatingRangeFromPlayer = p_98270_1_.func_74765_d("RequiredPlayerRange");
        }
        if (p_98270_1_.func_150297_b("SpawnRange", 99)) {
            this.spawnRange = p_98270_1_.func_74765_d("SpawnRange");
        }
        if (this.getSpawnerWorld() != null && this.getSpawnerWorld().field_72995_K) {
            this.field_98291_j = null;
        }
    }

    public void writeToNBT(NBTTagCompound p_98280_1_) {
        p_98280_1_.func_74768_a("EntityId", this.entityTypeName);
        p_98280_1_.func_74757_a("truc", this.truc);
        p_98280_1_.func_74777_a("Delay", (short)this.spawnDelay);
        p_98280_1_.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
        p_98280_1_.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
        p_98280_1_.func_74777_a("SpawnCount", (short)this.spawnCount);
        p_98280_1_.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
        p_98280_1_.func_74777_a("RequiredPlayerRange", (short)this.activatingRangeFromPlayer);
        p_98280_1_.func_74777_a("SpawnRange", (short)this.spawnRange);
        if (this.getRandomEntity() != null) {
            p_98280_1_.func_74782_a("SpawnData", this.getRandomEntity().field_98222_b.func_74737_b());
        }
        if (this.getRandomEntity() != null || this.potentialEntitySpawns != null && this.potentialEntitySpawns.size() > 0) {
            NBTTagList nbttaglist = new NBTTagList();
            if (this.potentialEntitySpawns != null && this.potentialEntitySpawns.size() > 0) {
                for (WeightedRandomMinecart weightedrandomminecart : this.potentialEntitySpawns) {
                    nbttaglist.func_74742_a((NBTBase)weightedrandomminecart.func_98220_a());
                }
            } else {
                nbttaglist.func_74742_a((NBTBase)this.getRandomEntity().func_98220_a());
            }
            p_98280_1_.func_74782_a("SpawnPotentials", (NBTBase)nbttaglist);
        }
    }

    public boolean setDelayToMin(int p_98268_1_) {
        if (p_98268_1_ == 1 && this.getSpawnerWorld().field_72995_K) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity func_98281_h() {
        if (this.field_98291_j == null) {
            Entity entity = null;
            try {
                Class classe = RegisterBlock.AllSpawner.get(this.entityTypeName);
                Constructor constructeur = classe.getConstructor(World.class);
                entity = (Entity)constructeur.newInstance(this.getSpawnerWorld());
            }
            catch (InstantiationException var4) {
                var4.printStackTrace();
            }
            catch (IllegalAccessException var5) {
                var5.printStackTrace();
            }
            catch (NoSuchMethodException var6) {
                var6.printStackTrace();
            }
            catch (SecurityException var7) {
                var7.printStackTrace();
            }
            catch (IllegalArgumentException var8) {
                var8.printStackTrace();
            }
            catch (InvocationTargetException var9) {
                var9.printStackTrace();
            }
            if (entity == null) {
                return null;
            }
            this.field_98291_j = entity = this.func_98265_a(entity);
        }
        return this.field_98291_j;
    }

    public WeightedRandomMinecart getRandomEntity() {
        return this.randomEntity;
    }

    public void setRandomEntity(WeightedRandomMinecart p_98277_1_) {
        this.randomEntity = p_98277_1_;
    }

    public abstract void func_98267_a(int var1);

    public abstract World getSpawnerWorld();

    public abstract int getSpawnerX();

    public abstract int getSpawnerY();

    public abstract int getSpawnerZ();

    public class WeightedRandomMinecart
    extends WeightedRandom.Item {
        public final NBTTagCompound field_98222_b;
        public final String entityTypeName;
        private static final String __OBFID = "CL_00000130";

        public WeightedRandomMinecart(NBTTagCompound p_i1945_2_) {
            super(p_i1945_2_.func_74762_e("Weight"));
            NBTTagCompound nbttagcompound1 = p_i1945_2_.func_74775_l("Properties");
            String s = p_i1945_2_.func_74779_i("Type");
            if (s.equals("Minecart")) {
                if (nbttagcompound1 != null) {
                    switch (nbttagcompound1.func_74762_e("Type")) {
                        case 0: {
                            s = "MinecartRideable";
                            break;
                        }
                        case 1: {
                            s = "MinecartChest";
                            break;
                        }
                        case 2: {
                            s = "MinecartFurnace";
                        }
                    }
                } else {
                    s = "MinecartRideable";
                }
            }
            this.field_98222_b = nbttagcompound1;
            this.entityTypeName = s;
        }

        public WeightedRandomMinecart(NBTTagCompound p_i1946_2_, String p_i1946_3_) {
            super(1);
            if (p_i1946_3_.equals("Minecart")) {
                if (p_i1946_2_ != null) {
                    switch (p_i1946_2_.func_74762_e("Type")) {
                        case 0: {
                            p_i1946_3_ = "MinecartRideable";
                            break;
                        }
                        case 1: {
                            p_i1946_3_ = "MinecartChest";
                            break;
                        }
                        case 2: {
                            p_i1946_3_ = "MinecartFurnace";
                        }
                    }
                } else {
                    p_i1946_3_ = "MinecartRideable";
                }
            }
            this.field_98222_b = p_i1946_2_;
            this.entityTypeName = p_i1946_3_;
        }

        public NBTTagCompound func_98220_a() {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74782_a("Properties", (NBTBase)this.field_98222_b);
            nbttagcompound.func_74778_a("Type", this.entityTypeName);
            nbttagcompound.func_74768_a("Weight", this.field_76292_a);
            return nbttagcompound;
        }
    }
}

