/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.module.hud.HUDMod;
import fr.vartax.module.hud.config.HUDConfig;
import fr.vartax.module.hud.event.HUDElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuidHud
extends GuiScreen {
    private HUDMod hudMod;
    private HUDConfig config;
    private DisplayMode currentMode = DisplayMode.MAIN_MENU;
    private Tab currentTab = Tab.GENERAL;
    private HUDElement draggingElement = null;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private int panelX;
    private int panelY;
    private int panelWidth = 220;
    private int panelHeight = 240;

    public GuidHud() {
        this.hudMod = HUDMod.getInstance();
        this.config = this.hudMod.getConfig();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.panelX = (this.field_146294_l - this.panelWidth) / 2;
        this.panelY = (this.field_146295_m - this.panelHeight) / 2;
        if (this.currentMode == DisplayMode.MAIN_MENU) {
            this.initMainMenuButtons();
        } else {
            this.initEditScreenButtons();
        }
    }

    private void initMainMenuButtons() {
        int tabY = this.panelY + 10;
        int tabWidth = (this.panelWidth - 40) / 4;
        int tabHeight = 20;
        int tabSpacing = 5;
        this.field_146292_n.add(new GuiButton(100, this.panelX + 10, tabY, tabWidth, tabHeight, "General"));
        this.field_146292_n.add(new GuiButton(101, this.panelX + 10 + tabWidth + tabSpacing, tabY, tabWidth, tabHeight, "Armor"));
        this.field_146292_n.add(new GuiButton(102, this.panelX + 10 + (tabWidth + tabSpacing) * 2, tabY, tabWidth, tabHeight, "Keys"));
        this.field_146292_n.add(new GuiButton(103, this.panelX + 10 + (tabWidth + tabSpacing) * 3, tabY, tabWidth, tabHeight, "Info"));
        int contentY = tabY + tabHeight + 15;
        int buttonWidth = this.panelWidth - 40;
        int buttonHeight = 20;
        int spacing = 5;
        switch (this.currentTab) {
            case GENERAL: {
                this.field_146292_n.add(new GuiButton(1, this.panelX + 20, contentY, buttonWidth, buttonHeight, this.getToggleText("Potion HUD", this.config.isPotionHUDEnabled())));
                this.field_146292_n.add(new GuiButton(2, this.panelX + 20, contentY += buttonHeight + spacing, buttonWidth, buttonHeight, this.getToggleText("Armor HUD", this.config.isArmorHUDEnabled())));
                this.field_146292_n.add(new GuiButton(3, this.panelX + 20, contentY += buttonHeight + spacing, buttonWidth, buttonHeight, this.getToggleText("Keystroke HUD", this.config.isKeystrokeHUDEnabled())));
                break;
            }
            case ARMOR: {
                int smallButtonWidth = (buttonWidth - spacing) / 2;
                this.field_146292_n.add(new GuiButton(5, this.panelX + 20, contentY, smallButtonWidth, buttonHeight, this.getToggleText("Helmet", this.config.isArmorHelmetEnabled())));
                this.field_146292_n.add(new GuiButton(6, this.panelX + 20 + smallButtonWidth + spacing, contentY, smallButtonWidth, buttonHeight, this.getToggleText("Chest", this.config.isArmorChestplateEnabled())));
                this.field_146292_n.add(new GuiButton(7, this.panelX + 20, contentY += buttonHeight + spacing, smallButtonWidth, buttonHeight, this.getToggleText("Legs", this.config.isArmorLeggingsEnabled())));
                this.field_146292_n.add(new GuiButton(8, this.panelX + 20 + smallButtonWidth + spacing, contentY, smallButtonWidth, buttonHeight, this.getToggleText("Boots", this.config.isArmorBootsEnabled())));
                this.field_146292_n.add(new GuiButton(9, this.panelX + 20, contentY += buttonHeight + spacing, buttonWidth, buttonHeight, this.getToggleText("Held Item", this.config.isHeldItemEnabled())));
                break;
            }
            case KEYSTROKE: {
                this.func_73732_a(this.field_146289_q, "\u00a77No additional options", this.panelX + this.panelWidth / 2, contentY + 50, 0xFFFFFF);
                break;
            }
            case INFO: {
                this.field_146292_n.add(new GuiButton(10, this.panelX + 20, contentY, buttonWidth, buttonHeight, this.getToggleText("Toggle Sprint", this.config.isToggleSprintHUDEnabled())));
                this.field_146292_n.add(new GuiButton(11, this.panelX + 20, contentY += buttonHeight + spacing, buttonWidth, buttonHeight, this.getToggleText("CPS", this.config.isCPSHUDEnabled())));
                this.field_146292_n.add(new GuiButton(12, this.panelX + 20, contentY += buttonHeight + spacing, buttonWidth, buttonHeight, this.getToggleText("FPS", this.config.isFPSHUDEnabled())));
                this.field_146292_n.add(new GuiButton(13, this.panelX + 20, contentY += buttonHeight + spacing, buttonWidth, buttonHeight, this.getToggleText("Ping", this.config.isPingHUDEnabled())));
            }
        }
        int bottomY = this.panelY + this.panelHeight - 60;
        this.field_146292_n.add(new GuiButton(200, this.panelX + 20, bottomY, buttonWidth, buttonHeight, "\u00a7aEdit Screen Layout"));
        this.field_146292_n.add(new GuiButton(201, this.panelX + 20, bottomY += buttonHeight + spacing, (buttonWidth - spacing) / 2, buttonHeight, "Reset"));
        this.field_146292_n.add(new GuiButton(0, this.panelX + 20 + (buttonWidth - spacing) / 2 + spacing, bottomY, (buttonWidth - spacing) / 2, buttonHeight, "Done"));
    }

    private void initEditScreenButtons() {
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.config.saveConfig();
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 100: {
                this.currentTab = Tab.GENERAL;
                this.func_73866_w_();
                break;
            }
            case 101: {
                this.currentTab = Tab.ARMOR;
                this.func_73866_w_();
                break;
            }
            case 102: {
                this.currentTab = Tab.KEYSTROKE;
                this.func_73866_w_();
                break;
            }
            case 103: {
                this.currentTab = Tab.INFO;
                this.func_73866_w_();
                break;
            }
            case 1: {
                this.config.setPotionHUDEnabled(!this.config.isPotionHUDEnabled());
                this.func_73866_w_();
                break;
            }
            case 2: {
                this.config.setArmorHUDEnabled(!this.config.isArmorHUDEnabled());
                this.func_73866_w_();
                break;
            }
            case 3: {
                this.config.setKeystrokeHUDEnabled(!this.config.isKeystrokeHUDEnabled());
                this.func_73866_w_();
                break;
            }
            case 5: {
                this.config.setArmorHelmetEnabled(!this.config.isArmorHelmetEnabled());
                this.func_73866_w_();
                break;
            }
            case 6: {
                this.config.setArmorChestplateEnabled(!this.config.isArmorChestplateEnabled());
                this.func_73866_w_();
                break;
            }
            case 7: {
                this.config.setArmorLeggingsEnabled(!this.config.isArmorLeggingsEnabled());
                this.func_73866_w_();
                break;
            }
            case 8: {
                this.config.setArmorBootsEnabled(!this.config.isArmorBootsEnabled());
                this.func_73866_w_();
                break;
            }
            case 9: {
                this.config.setHeldItemEnabled(!this.config.isHeldItemEnabled());
                this.func_73866_w_();
                break;
            }
            case 10: {
                this.config.setToggleSprintHUDEnabled(!this.config.isToggleSprintHUDEnabled());
                this.func_73866_w_();
                break;
            }
            case 11: {
                this.config.setCPSHUDEnabled(!this.config.isCPSHUDEnabled());
                this.func_73866_w_();
                break;
            }
            case 12: {
                this.config.setFPSHUDEnabled(!this.config.isFPSHUDEnabled());
                this.func_73866_w_();
                break;
            }
            case 13: {
                this.config.setPingHUDEnabled(!this.config.isPingHUDEnabled());
                this.func_73866_w_();
                break;
            }
            case 200: {
                this.currentMode = DisplayMode.EDIT_SCREEN;
                this.func_73866_w_();
                break;
            }
            case 201: {
                this.resetAllPositions();
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.currentMode == DisplayMode.MAIN_MENU) {
            this.drawMainMenu(mouseX, mouseY, partialTicks);
        } else {
            this.drawEditScreen(mouseX, mouseY, partialTicks);
        }
    }

    private void drawMainMenu(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GuidHud.func_73734_a((int)this.panelX, (int)this.panelY, (int)(this.panelX + this.panelWidth), (int)(this.panelY + this.panelHeight), (int)-536870912);
        this.drawHollowRect(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, -11184811);
        String title = "\u00a7l\u00a7nHUD Configuration";
        int titleWidth = this.field_146289_q.func_78256_a(title);
        this.field_146289_q.func_78261_a(title, this.panelX + (this.panelWidth - titleWidth) / 2, this.panelY - 20, 0xFFFFFF);
        int tabY = this.panelY + 10;
        int tabWidth = (this.panelWidth - 40) / 4;
        int tabSpacing = 5;
        int activeTabX = 0;
        switch (this.currentTab) {
            case GENERAL: {
                activeTabX = this.panelX + 10;
                break;
            }
            case ARMOR: {
                activeTabX = this.panelX + 10 + tabWidth + tabSpacing;
                break;
            }
            case KEYSTROKE: {
                activeTabX = this.panelX + 10 + (tabWidth + tabSpacing) * 2;
                break;
            }
            case INFO: {
                activeTabX = this.panelX + 10 + (tabWidth + tabSpacing) * 3;
            }
        }
        GuidHud.func_73734_a((int)activeTabX, (int)(tabY + 20), (int)(activeTabX + tabWidth), (int)(tabY + 22), (int)-16733696);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String info = "\u00a77Tip: Use '\u00a7aEdit Screen Layout\u00a77' to position elements";
        this.field_146289_q.func_78276_b(info, this.panelX + 10, this.panelY + this.panelHeight + 5, 0xAAAAAA);
    }

    private void drawEditScreen(int mouseX, int mouseY, float partialTicks) {
        GuidHud.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)0x50000000);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String title = "\u00a7l\u00a7eEdit Screen Layout";
        this.func_73732_a(this.field_146289_q, title, this.field_146294_l / 2, 30, 0xFFFFFF);
        String inst1 = "\u00a77Drag elements to move them";
        String inst2 = "\u00a77Hold \u00a7fCtrl \u00a77+ Scroll to zoom";
        String inst3 = "\u00a77Press \u00a7fESC \u00a77to save and return";
        this.func_73732_a(this.field_146289_q, inst1, this.field_146294_l / 2, 45, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, inst2, this.field_146294_l / 2, 55, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, inst3, this.field_146294_l / 2, 65, 0xFFFFFF);
        ScaledResolution sr = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        this.renderHUDElements(sr, mouseX, mouseY);
        HUDElement hoveredElement = this.getHoveredElement(mouseX, mouseY);
        if (hoveredElement != null) {
            this.drawHoverInfo(hoveredElement, mouseX, mouseY);
        }
    }

    private void renderHUDElements(ScaledResolution sr, int mouseX, int mouseY) {
        List<HUDElement> elements = this.hudMod.getAllElements();
        for (HUDElement element : elements) {
            int borderColor;
            if (!element.isEnabled()) continue;
            GL11.glPushMatrix();
            element.render(sr);
            GL11.glPopMatrix();
            int scaledWidth = (int)((float)element.getWidth() * element.getScale());
            int scaledHeight = (int)((float)element.getHeight() * element.getScale());
            boolean isHovered = element.isMouseOver(mouseX, mouseY);
            int n = borderColor = isHovered ? -16711936 : -2130706433;
            if (this.draggingElement == element) {
                borderColor = -256;
            }
            this.drawHollowRect(element.getX(), element.getY(), element.getX() + scaledWidth, element.getY() + scaledHeight, borderColor);
            if (!isHovered && this.draggingElement != element) continue;
            String name = this.getElementName(element);
            int nameWidth = this.field_146289_q.func_78256_a(name);
            int nameX = element.getX() + (scaledWidth - nameWidth) / 2;
            int nameY = element.getY() - 12;
            GuidHud.func_73734_a((int)(nameX - 2), (int)(nameY - 1), (int)(nameX + nameWidth + 2), (int)(nameY + 9), (int)-536870912);
            this.field_146289_q.func_78261_a(name, nameX, nameY, 0xFFFFFF);
        }
    }

    private void drawHoverInfo(HUDElement element, int mouseX, int mouseY) {
        ArrayList<String> info = new ArrayList<String>();
        info.add("\u00a77Position: \u00a7f" + element.getX() + ", " + element.getY());
        info.add("\u00a77Scale: \u00a7f" + String.format("%.1f", Float.valueOf(element.getScale())) + "x");
        int boxWidth = 0;
        for (String line : info) {
            int lineWidth = this.field_146289_q.func_78256_a(line);
            if (lineWidth <= boxWidth) continue;
            boxWidth = lineWidth;
        }
        int boxHeight = info.size() * 10 + 4;
        int x = mouseX + 10;
        int y = mouseY;
        if (x + boxWidth + 8 > this.field_146294_l) {
            x = mouseX - boxWidth - 18;
        }
        if (y + boxHeight > this.field_146295_m) {
            y = this.field_146295_m - boxHeight;
        }
        GuidHud.func_73734_a((int)x, (int)y, (int)(x + boxWidth + 8), (int)(y + boxHeight), (int)-536870912);
        this.drawHollowRect(x, y, x + boxWidth + 8, y + boxHeight, -16733696);
        int textY = y + 2;
        for (String line : info) {
            this.field_146289_q.func_78261_a(line, x + 4, textY, 0xFFFFFF);
            textY += 10;
        }
    }

    private String getElementName(HUDElement element) {
        String className = element.getClass().getSimpleName();
        return className.replace("HUD", "");
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        HUDElement clickedElement;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.currentMode == DisplayMode.EDIT_SCREEN && mouseButton == 0 && (clickedElement = this.getHoveredElement(mouseX, mouseY)) != null) {
            this.draggingElement = clickedElement;
            this.dragOffsetX = mouseX - clickedElement.getX();
            this.dragOffsetY = mouseY - clickedElement.getY();
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.currentMode == DisplayMode.EDIT_SCREEN && this.draggingElement != null && clickedMouseButton == 0) {
            int newX = mouseX - this.dragOffsetX;
            int newY = mouseY - this.dragOffsetY;
            newX = Math.max(0, Math.min(newX, this.field_146294_l - (int)((float)this.draggingElement.getWidth() * this.draggingElement.getScale())));
            newY = Math.max(0, Math.min(newY, this.field_146295_m - (int)((float)this.draggingElement.getHeight() * this.draggingElement.getScale())));
            this.draggingElement.setX(newX);
            this.draggingElement.setY(newY);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.draggingElement = null;
    }

    protected void func_73869_a(char character, int keyCode) {
        if (keyCode == 1) {
            if (this.currentMode == DisplayMode.EDIT_SCREEN) {
                this.currentMode = DisplayMode.MAIN_MENU;
                this.config.saveConfig();
                this.func_73866_w_();
            } else {
                this.field_146297_k.func_147108_a(null);
                this.field_146297_k.func_71381_h();
            }
        }
    }

    public void func_146274_d() {
        if (this.currentMode == DisplayMode.EDIT_SCREEN) {
            HUDElement hoveredElement;
            int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            int wheel = Mouse.getEventDWheel();
            if (wheel != 0 && (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) && (hoveredElement = this.getHoveredElement(mouseX, mouseY)) != null) {
                float currentScale = hoveredElement.getScale();
                float delta = wheel > 0 ? 0.1f : -0.1f;
                float newScale = Math.max(0.5f, Math.min(3.0f, currentScale + delta));
                hoveredElement.setScale(newScale);
            }
        }
        super.func_146274_d();
    }

    private HUDElement getHoveredElement(int mouseX, int mouseY) {
        List<HUDElement> elements = this.hudMod.getAllElements();
        for (int i = elements.size() - 1; i >= 0; --i) {
            HUDElement element = elements.get(i);
            if (!element.isEnabled() || !element.isMouseOver(mouseX, mouseY)) continue;
            return element;
        }
        return null;
    }

    private void resetAllPositions() {
        this.config.setPotionPosition(10, 10);
        this.config.setPotionScale(1.0f);
        this.config.setArmorPosition(10, 50);
        this.config.setArmorScale(1.0f);
        this.config.setKeystrokePosition(10, 130);
        this.config.setKeystrokeScale(1.0f);
        this.config.setToggleSprintPosition(10, 250);
        this.config.setToggleSprintScale(1.0f);
        this.config.setCPSPosition(10, 290);
        this.config.setCPSScale(1.0f);
        this.config.setFPSPosition(10, 320);
        this.config.setFPSScale(1.0f);
        this.config.setPingPosition(10, 350);
        this.config.setPingScale(1.0f);
        this.config.saveConfig();
        this.hudMod.reloadElements();
    }

    private String getToggleText(String name, boolean enabled) {
        return name + ": " + (enabled ? "\u00a7aON" : "\u00a7cOFF");
    }

    private void drawHollowRect(int left, int top, int right, int bottom, int color) {
        GuidHud.func_73734_a((int)left, (int)top, (int)right, (int)(top + 1), (int)color);
        GuidHud.func_73734_a((int)left, (int)(bottom - 1), (int)right, (int)bottom, (int)color);
        GuidHud.func_73734_a((int)left, (int)top, (int)(left + 1), (int)bottom, (int)color);
        GuidHud.func_73734_a((int)(right - 1), (int)top, (int)right, (int)bottom, (int)color);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.config.saveConfig();
    }

    public boolean func_73868_f() {
        return true;
    }

    private static enum Tab {
        GENERAL,
        ARMOR,
        KEYSTROKE,
        INFO;

    }

    private static enum DisplayMode {
        MAIN_MENU,
        EDIT_SCREEN;

    }
}

