/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.client.gui;

import cpw.mods.fml.common.EnhancedRuntimeException;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.asm.FMLSanityChecker;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.SharedDrawable;
import org.lwjgl.util.glu.GLU;

public class VartaCraftSplash {
    private static Drawable d;
    private static volatile boolean pause;
    private static volatile boolean done;
    private static Thread thread;
    private static volatile Throwable threadError;
    private static int angle;
    private static final Lock lock;
    private static SplashFontRenderer fontRenderer;
    private static final IResourcePack mcPack;
    private static final IResourcePack fmlPack;
    private static IResourcePack miscPack;
    private static Texture fontTexture;
    private static Texture backgroundTexture;
    private static Texture loadingTexture;
    private static Properties config;
    private static boolean enabled;
    private static int backgroundColor;
    private static int fontColor;
    private static int barColor;
    private static int barBackgroundColor;
    private static String[] tipsList;
    private static String currentTip;
    public static final Semaphore mutex;
    private static final IntBuffer buf;

    private static String getString(String name, String def) {
        String value = config.getProperty(name, def);
        config.setProperty(name, value);
        return value;
    }

    private static boolean getBool(String name, boolean def) {
        return Boolean.parseBoolean(VartaCraftSplash.getString(name, Boolean.toString(def)));
    }

    private static int getInt(String name, int def) {
        return Integer.decode(VartaCraftSplash.getString(name, Integer.toString(def)));
    }

    private static int getHex(String name, int def) {
        return Integer.decode(VartaCraftSplash.getString(name, "0x" + Integer.toString(def, 16).toUpperCase()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        try {
            FMLLog.info((String)"[VartaCraft Splash] Starting splash screen...", (Object[])new Object[0]);
            currentTip = tipsList[new Random().nextInt(tipsList.length)];
            File configFile = new File(Minecraft.func_71410_x().field_71412_D, "config/vartacraft-splash.properties");
            FileReader r = null;
            config = new Properties();
            try {
                r = new FileReader(configFile);
                config.load(r);
                FMLLog.info((String)"[VartaCraft Splash] Configuration loaded", (Object[])new Object[0]);
            }
            catch (IOException e) {
                try {
                    FMLLog.info((String)"[VartaCraft Splash] Could not load vartacraft-splash.properties, will create a default one", (Object[])new Object[0]);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(r);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)r);
            }
            IOUtils.closeQuietly((Reader)r);
            if (!configFile.exists()) {
                enabled = true;
                FMLLog.info((String)"[VartaCraft Splash] First launch, enabling splash by default", (Object[])new Object[0]);
            } else {
                enabled = VartaCraftSplash.getBool("enabled", true);
            }
            FMLLog.info((String)("[VartaCraft Splash] Splash enabled: " + enabled), (Object[])new Object[0]);
            if (!enabled) {
                FMLLog.info((String)"[VartaCraft Splash] Splash is disabled, skipping", (Object[])new Object[0]);
                return;
            }
            backgroundColor = VartaCraftSplash.getHex("background", 1710638);
            fontColor = VartaCraftSplash.getHex("font", 0xFFFFFF);
            barColor = VartaCraftSplash.getHex("barColor", 54527);
            barBackgroundColor = VartaCraftSplash.getHex("barBackground", 1450302);
            FMLLog.info((String)"[VartaCraft Splash] Colors configured", (Object[])new Object[0]);
            final ResourceLocation fontLoc = new ResourceLocation(VartaCraftSplash.getString("fontTexture", "textures/font/ascii.png"));
            final ResourceLocation backgroundLoc = new ResourceLocation("vartacraft", "textures/splash/background.png");
            ResourceLocation loadingLoc = new ResourceLocation("vartacraft", "textures/splash/loading.gif");
            FMLLog.info((String)"[VartaCraft Splash] Resource locations created", (Object[])new Object[0]);
            File miscPackFile = new File(Minecraft.func_71410_x().field_71412_D, VartaCraftSplash.getString("resourcePackPath", "resources"));
            FileWriter w = null;
            try {
                w = new FileWriter(configFile);
                config.store(w, "VartaCraft Splash screen properties");
            }
            catch (IOException e) {
                try {
                    FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Could not save the vartacraft-splash.properties file", (Object[])new Object[0]);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(w);
                    throw throwable;
                }
                IOUtils.closeQuietly((Writer)w);
            }
            IOUtils.closeQuietly((Writer)w);
            miscPack = VartaCraftSplash.createResourcePack(miscPackFile);
            FMLLog.info((String)"[VartaCraft Splash] Misc pack created", (Object[])new Object[0]);
            FMLCommonHandler.instance().registerCrashCallable(new ICrashCallable(){

                public String call() throws Exception {
                    return "' Vendor: '" + GL11.glGetString((int)7936) + "' Version: '" + GL11.glGetString((int)7938) + "' Renderer: '" + GL11.glGetString((int)7937) + "'";
                }

                public String getLabel() {
                    return "GL info";
                }
            });
            CrashReport report = CrashReport.func_85055_a((Throwable)new Throwable(){

                @Override
                public String getMessage() {
                    return "This is just a prompt for computer specs to be printed. THIS IS NOT A ERROR";
                }

                @Override
                public void printStackTrace(PrintWriter s) {
                    s.println(this.getMessage());
                }

                @Override
                public void printStackTrace(PrintStream s) {
                    s.println(this.getMessage());
                }
            }, (String)"Loading screen debug info");
            System.out.println(report.func_71502_e());
            try {
                d = new SharedDrawable(Display.getDrawable());
                Display.getDrawable().releaseContext();
                d.makeCurrent();
            }
            catch (LWJGLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            Thread mainThread = Thread.currentThread();
            thread = new Thread(new Runnable(){
                private float progress = 0.0f;
                private float targetProgress = 0.0f;
                private int barWidth = 0;
                private int barHeight = 0;

                @Override
                public void run() {
                    try {
                        FMLLog.info((String)"[VartaCraft Splash] Render thread starting...", (Object[])new Object[0]);
                        this.setGL();
                        FMLLog.info((String)"[VartaCraft Splash] Loading textures...", (Object[])new Object[0]);
                        fontTexture = new Texture(fontLoc);
                        FMLLog.info((String)"[VartaCraft Splash] Font texture loaded", (Object[])new Object[0]);
                        backgroundTexture = new Texture(backgroundLoc);
                        FMLLog.info((String)"[VartaCraft Splash] Background texture loaded", (Object[])new Object[0]);
                        GL11.glEnable((int)3553);
                        fontRenderer = new SplashFontRenderer();
                        GL11.glDisable((int)3553);
                        while (!done) {
                            ProgressManager.ProgressBar first = null;
                            ProgressManager.ProgressBar penult = null;
                            ProgressManager.ProgressBar last = null;
                            Iterator i = ProgressManager.barIterator();
                            while (i.hasNext()) {
                                if (first == null) {
                                    first = (ProgressManager.ProgressBar)i.next();
                                    continue;
                                }
                                penult = last;
                                last = (ProgressManager.ProgressBar)i.next();
                            }
                            GL11.glClear((int)16384);
                            int w = Display.getWidth();
                            int h = Display.getHeight();
                            this.barWidth = w - 40;
                            this.barHeight = (int)((float)h * 0.017f);
                            GL11.glViewport((int)0, (int)0, (int)w, (int)h);
                            GL11.glMatrixMode((int)5889);
                            GL11.glLoadIdentity();
                            GL11.glOrtho((double)(320.0 - (double)(w / 2)), (double)(320.0 + (double)(w / 2)), (double)(240.0 + (double)(h / 2)), (double)(240.0 - (double)(h / 2)), (double)-1.0, (double)1.0);
                            GL11.glMatrixMode((int)5888);
                            GL11.glLoadIdentity();
                            try {
                                this.setColor(Color.WHITE.getRGB());
                                GL11.glEnable((int)3553);
                                backgroundTexture.bind();
                                GL11.glBegin((int)7);
                                backgroundTexture.texCoord(0, 0.0f, 0.0f);
                                GL11.glVertex2f((float)(320 - w / 2), (float)(240 - h / 2));
                                backgroundTexture.texCoord(0, 0.0f, 1.0f);
                                GL11.glVertex2f((float)(320 - w / 2), (float)(240 + h / 2));
                                backgroundTexture.texCoord(0, 1.0f, 1.0f);
                                GL11.glVertex2f((float)(320 + w / 2), (float)(240 + h / 2));
                                backgroundTexture.texCoord(0, 1.0f, 0.0f);
                                GL11.glVertex2f((float)(320 + w / 2), (float)(240 - h / 2));
                                GL11.glEnd();
                                GL11.glDisable((int)3553);
                            }
                            catch (Exception e) {
                                FMLLog.log((Level)Level.WARN, (String)"[VartaCraft Splash] Could not render background texture", (Object[])new Object[0]);
                            }
                            if (first != null) {
                                this.targetProgress = (float)(first.getStep() + 1) / (float)(first.getSteps() + 1);
                                this.progress = this.smoothValue(this.progress, this.targetProgress);
                                GL11.glPushMatrix();
                                GL11.glTranslatef((float)(320 - w / 2 + 20), (float)((float)(240 + h / 2) - (float)h * 0.1f + 5.0f), (float)0.0f);
                                this.setColor(barBackgroundColor);
                                this.drawBox(this.barWidth, this.barHeight);
                                this.setColor(barColor);
                                GL11.glTranslatef((float)2.0f, (float)2.0f, (float)0.0f);
                                this.drawBox((int)((float)(this.barWidth - 4) * this.progress), this.barHeight - 4);
                                GL11.glPopMatrix();
                            }
                            mutex.acquireUninterruptibly();
                            Display.update();
                            mutex.release();
                            if (pause) {
                                this.clearGL();
                                this.setGL();
                            }
                            Display.sync((int)100);
                        }
                        this.clearGL();
                    }
                    catch (Throwable t) {
                        FMLLog.log((Level)Level.ERROR, (Throwable)t, (String)"[VartaCraft Splash] Error in render thread", (Object[])new Object[0]);
                        threadError = t;
                    }
                }

                public List<String> getSplittedString(String text, double width) {
                    text = this.trimStringNewline(text);
                    List list = fontRenderer.func_78271_c(text, (int)width);
                    return list;
                }

                private String trimStringNewline(String text) {
                    while (text != null && text.endsWith("\n")) {
                        text = text.substring(0, text.length() - 1);
                    }
                    return text;
                }

                private void setColor(int color) {
                    GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
                }

                private void drawBox(float w, float h) {
                    GL11.glBegin((int)7);
                    GL11.glVertex2f((float)0.0f, (float)0.0f);
                    GL11.glVertex2f((float)0.0f, (float)h);
                    GL11.glVertex2f((float)w, (float)h);
                    GL11.glVertex2f((float)w, (float)0.0f);
                    GL11.glEnd();
                }

                private float smoothValue(float value, float target) {
                    if (value >= target) {
                        return target;
                    }
                    float diff = target - value;
                    float offset = 0.075f * diff / 3.0f;
                    if (diff <= 0.075f) {
                        return target;
                    }
                    return value += offset;
                }

                private void setGL() {
                    lock.lock();
                    try {
                        Display.getDrawable().makeCurrent();
                    }
                    catch (LWJGLException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                    GL11.glClearColor((float)((float)(backgroundColor >> 16 & 0xFF) / 255.0f), (float)((float)(backgroundColor >> 8 & 0xFF) / 255.0f), (float)((float)(backgroundColor & 0xFF) / 255.0f), (float)1.0f);
                    GL11.glDisable((int)2896);
                    GL11.glDisable((int)2929);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                }

                private void clearGL() {
                    Minecraft mc = Minecraft.func_71410_x();
                    mc.field_71443_c = Display.getWidth();
                    mc.field_71440_d = Display.getHeight();
                    mc.func_71370_a(mc.field_71443_c, mc.field_71440_d);
                    GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glEnable((int)2929);
                    GL11.glDepthFunc((int)515);
                    GL11.glEnable((int)3008);
                    GL11.glAlphaFunc((int)516, (float)0.1f);
                    try {
                        Display.getDrawable().releaseContext();
                    }
                    catch (LWJGLException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            });
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"VartaCraft Splash thread Exception", (Object[])new Object[0]);
                    threadError = e;
                }
            });
            thread.start();
            FMLLog.info((String)"[VartaCraft Splash] Splash thread started successfully", (Object[])new Object[0]);
            VartaCraftSplash.checkThreadState();
        }
        catch (Throwable t) {
            FMLLog.log((Level)Level.ERROR, (Throwable)t, (String)"[VartaCraft Splash] Fatal error starting splash screen, disabling it", (Object[])new Object[0]);
            enabled = false;
            threadError = t;
        }
    }

    private static void checkThreadState() {
        if (thread.getState() == Thread.State.TERMINATED || threadError != null) {
            throw new IllegalStateException("Splash thread", threadError);
        }
    }

    @Deprecated
    public static void pause() {
        if (!enabled) {
            return;
        }
        VartaCraftSplash.checkThreadState();
        pause = true;
        lock.lock();
        try {
            d.releaseContext();
            Display.getDrawable().makeCurrent();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void resume() {
        if (!enabled) {
            return;
        }
        VartaCraftSplash.checkThreadState();
        pause = false;
        try {
            Display.getDrawable().releaseContext();
            d.makeCurrent();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        lock.unlock();
    }

    public static void finish() {
        if (!enabled) {
            return;
        }
        try {
            VartaCraftSplash.checkThreadState();
            done = true;
            thread.join();
            d.releaseContext();
            Display.getDrawable().makeCurrent();
            fontTexture.delete();
            backgroundTexture.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (VartaCraftSplash.disableSplash()) {
                throw new EnhancedRuntimeException(e){

                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        stream.println("VartaCraft SplashProgress has detected an error loading Minecraft.");
                        stream.println("This can sometimes be caused by bad video drivers.");
                        stream.println("We have automatically disabled the new Splash Screen in config/vartacraft-splash.properties.");
                        stream.println("Try reloading minecraft before reporting any errors.");
                    }
                };
            }
            throw new EnhancedRuntimeException(e){

                protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                    stream.println("VartaCraft SplashProgress has detected an error loading Minecraft.");
                    stream.println("This can sometimes be caused by bad video drivers.");
                    stream.println("Please try disabling the new Splash Screen in config/vartacraft-splash.properties.");
                    stream.println("After doing so, try reloading minecraft before reporting any errors.");
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean disableSplash() {
        boolean bl;
        File configFile = new File(Minecraft.func_71410_x().field_71412_D, "config/vartacraft-splash.properties");
        File parent = configFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        Object r = null;
        enabled = false;
        config.setProperty("enabled", "false");
        FileWriter w = null;
        try {
            w = new FileWriter(configFile);
            config.store(w, "VartaCraft Splash screen properties");
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Could not save the vartacraft-splash.properties file", (Object[])new Object[0]);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(w);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)w);
            return bl2;
        }
        IOUtils.closeQuietly((Writer)w);
        return bl;
    }

    private static IResourcePack createResourcePack(File file) {
        if (file.isDirectory()) {
            return new FolderResourcePack(file);
        }
        return new FileResourcePack(file);
    }

    public static void drawVanillaScreen() throws LWJGLException {
        if (!enabled) {
            Minecraft.func_71410_x().func_71357_I();
        }
    }

    public static void clearVanillaResources(TextureManager renderEngine, ResourceLocation mojangLogo) {
        if (!enabled) {
            renderEngine.func_147645_c(mojangLogo);
        }
    }

    public static void checkGLError(String where) {
        int err = GL11.glGetError();
        if (err != 0) {
            throw new IllegalStateException(where + ": " + GLU.gluErrorString((int)err));
        }
    }

    private static InputStream open(ResourceLocation loc) throws IOException {
        try {
            if (miscPack.func_110589_b(loc)) {
                return miscPack.func_110590_a(loc);
            }
            if (fmlPack.func_110589_b(loc)) {
                return fmlPack.func_110590_a(loc);
            }
            return mcPack.func_110590_a(loc);
        }
        catch (IOException e) {
            FMLLog.log((Level)Level.WARN, (String)("Could not load splash resource: " + loc), (Object[])new Object[0]);
            throw e;
        }
    }

    static {
        pause = false;
        done = false;
        angle = 0;
        lock = new ReentrantLock(true);
        mcPack = Minecraft.func_71410_x().field_110450_ap;
        fmlPack = VartaCraftSplash.createResourcePack(FMLSanityChecker.fmlLocation);
        tipsList = new String[]{"Bienvenue sur VartaCraft !", "Explore un monde plein de myst\u00e8res et d'aventures !", "N'oublie pas de consulter le wiki pour les recettes de craft !", "Les minerais VartaCraft se trouvent dans des dimensions sp\u00e9ciales !", "Utilise /help pour voir toutes les commandes disponibles !", "Les boss VartaCraft apparaissent dans les donjons perdus !", "Fabrique des outils en VartaStone pour des bonus sp\u00e9ciaux !", "Les portails dimensionnels n\u00e9cessitent des cristaux rares !", "Rejoins notre Discord pour rester inform\u00e9 des nouveaut\u00e9s !", "Les qu\u00eates quotidiennes offrent de belles r\u00e9compenses !"};
        mutex = new Semaphore(1);
        buf = BufferUtils.createIntBuffer((int)0x400000);
    }

    private static class SplashFontRenderer
    extends FontRenderer {
        public SplashFontRenderer() {
            super(Minecraft.func_71410_x().field_71474_y, fontTexture.getLocation(), null, false);
            super.func_110549_a(null);
        }

        protected void bindTexture(ResourceLocation location) {
            if (location != this.field_111273_g) {
                throw new IllegalArgumentException();
            }
            fontTexture.bind();
        }

        protected InputStream getResourceInputStream(ResourceLocation location) throws IOException {
            return Minecraft.func_71410_x().field_110450_ap.func_110590_a(location);
        }
    }

    private static class Texture {
        private final ResourceLocation location;
        private final int name;
        private final int width;
        private final int height;
        private final int frames;
        private final int size;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Texture(ResourceLocation location) {
            InputStream s = null;
            try {
                this.location = location;
                s = VartaCraftSplash.open(location);
                if (s == null) {
                    throw new IOException("Resource not found: " + location);
                }
                ImageInputStream stream = ImageIO.createImageInputStream(s);
                Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                if (!readers.hasNext()) {
                    throw new IOException("No suitable reader found for image " + location);
                }
                ImageReader reader = readers.next();
                reader.setInput(stream);
                this.frames = reader.getNumImages(true);
                BufferedImage[] images = new BufferedImage[this.frames];
                for (int i = 0; i < this.frames; ++i) {
                    images[i] = reader.read(i);
                }
                reader.dispose();
                int size = 1;
                this.width = images[0].getWidth();
                this.height = images[0].getHeight();
                while (size / this.width * (size / this.height) < this.frames) {
                    size *= 2;
                }
                this.size = size;
                GL11.glEnable((int)3553);
                Class<VartaCraftSplash> clazz = VartaCraftSplash.class;
                synchronized (VartaCraftSplash.class) {
                    this.name = GL11.glGenTextures();
                    GL11.glBindTexture((int)3553, (int)this.name);
                    // ** MonitorExit[var8_9] (shouldn't be in output)
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)size, (int)size, (int)0, (int)32993, (int)33639, (IntBuffer)null);
                    VartaCraftSplash.checkGLError("Texture creation");
                    int i = 0;
                    while (i * (size / this.width) < this.frames) {
                        for (int j = 0; i * (size / this.width) + j < this.frames && j < size / this.width; ++j) {
                            buf.clear();
                            BufferedImage image = images[i * (size / this.width) + j];
                            for (int k = 0; k < this.height; ++k) {
                                for (int l = 0; l < this.width; ++l) {
                                    buf.put(image.getRGB(l, k));
                                }
                            }
                            buf.position(0).limit(this.width * this.height);
                            GL11.glTexSubImage2D((int)3553, (int)0, (int)(j * this.width), (int)(i * this.height), (int)this.width, (int)this.height, (int)32993, (int)33639, (IntBuffer)buf);
                            VartaCraftSplash.checkGLError("Texture uploading");
                        }
                        ++i;
                    }
                    GL11.glBindTexture((int)3553, (int)0);
                    GL11.glDisable((int)3553);
                }
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(s);
                    throw throwable;
                }
            }
            {
                IOUtils.closeQuietly((InputStream)s);
                return;
            }
        }

        public ResourceLocation getLocation() {
            return this.location;
        }

        public int getName() {
            return this.name;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getFrames() {
            return this.frames;
        }

        public int getSize() {
            return this.size;
        }

        public void bind() {
            GL11.glBindTexture((int)3553, (int)this.name);
        }

        public void delete() {
            GL11.glDeleteTextures((int)this.name);
        }

        public float getU(int frame, float u) {
            return (float)this.width * ((float)(frame % (this.size / this.width)) + u) / (float)this.size;
        }

        public float getV(int frame, float v) {
            return (float)this.height * ((float)(frame / (this.size / this.width)) + v) / (float)this.size;
        }

        public void texCoord(int frame, float u, float v) {
            GL11.glTexCoord2f((float)this.getU(frame, u), (float)this.getV(frame, v));
        }
    }
}

