/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.client.gui.container;

import java.awt.Color;
import java.util.Random;

public class GuiParticle {
    private int lives;
    private int x;
    private int y;
    private int particleColor = new Color(255, 255, 255, 255).getRGB();
    private boolean isDead = true;
    private long delayTimer;
    private int speedDevider;

    public GuiParticle(int lives, int speed, int x, int y) {
        this.lives = lives;
        this.x = x;
        this.y = y;
        this.speedDevider = speed == 0 ? 110 : (speed == 1 ? 85 : 60);
        this.delayTimer = System.nanoTime();
        if (lives > 0) {
            this.isDead = false;
        }
    }

    public void Step() {
        if (this.lives > 0) {
            long elapsed = (System.nanoTime() - this.delayTimer) / 1000000L;
            if (elapsed / (long)this.speedDevider % 2L == 0L) {
                return;
            }
            this.delayTimer = System.nanoTime();
            --this.lives;
            Random random = new Random();
            if ((double)random.nextFloat() > 0.5) {
                this.x += new Random().nextInt(2);
            }
            this.y -= new Random().nextInt(2);
        } else {
            this.isDead = true;
        }
    }

    public boolean isDead() {
        return this.isDead;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y - 4;
    }

    public int getColor() {
        return this.particleColor;
    }
}

