/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.client.gui.menu;

import com.google.common.collect.Iterators;
import fr.vartax.client.gui.menu.GuiContainer;
import fr.vartax.client.gui.menu.GuiCustomScreen;
import fr.vartax.client.gui.menu.GuiScrollerSlotText;
import fr.vartax.client.gui.menu.button.GuiScrollerSlot;
import fr.vartax.client.gui.menu.button.GuiScrollerSlotImage;
import fr.vartax.utils.renders.GuiUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class GuiScroller
extends GuiContainer {
    public static final int SCROLLBAR_HEIGHT = 20;
    public static final int SCROLLBAR_WIDTH = 6;
    public static final int SCROLLBAR_Y_PAD = 2;
    public ArrayList<GuiScrollerSlot> slots = new ArrayList();
    private int scrollbarY;
    private int scrollbarMinY;
    private int scrollbarMaxY;
    private int scrollbarX;
    private int smoothScrollTargetY = -1;
    private int selectedSlot = -1;
    private int totalHeight;
    private boolean scrollerClicked = false;
    private int scrollerClickMouseOffset;

    public GuiScroller(int containerID, int posX, int posY, int width, int height, GuiCustomScreen parentGUI) {
        super(containerID, posX, posY, width, height, parentGUI);
    }

    @Override
    public void initGui() {
        super.initGui();
        this.scrollbarMaxY = this.scrollbarMinY = this.posY + 4;
        this.scrollbarY = this.scrollbarMinY;
        this.scrollbarX = this.posX + this.width - 12;
        this.onSlotHeightChanged();
    }

    public void onSlotHeightChanged() {
        int currentHeight = 0;
        int n = this.slots.size();
        for (int i = 0; i < n; ++i) {
            GuiScrollerSlot slot = this.slots.get(i);
            slot.init(this, i, this.posX, this.posY + currentHeight);
            currentHeight += slot.height();
        }
        this.totalHeight = currentHeight;
        this.scrollbarMaxY = this.totalHeight > this.height ? this.posY + this.height - 4 - 20 : this.scrollbarMinY;
    }

    public void scrollTo(int y) {
        int maxTranslate = this.totalHeight - this.height;
        float translate = Math.min(maxTranslate, y - this.posY);
        this.smoothScrollTargetY = this.clampToScrollbar(this.scrollbarMinY + (int)(translate / (float)maxTranslate * (float)(this.scrollbarMaxY - this.scrollbarMinY)));
    }

    private void updateScrollPosition(int newPos) {
        this.scrollbarY = this.clampToScrollbar(newPos);
    }

    private int clampToScrollbar(int newPos) {
        return MathHelper.func_76125_a((int)newPos, (int)this.scrollbarMinY, (int)this.scrollbarMaxY);
    }

    private int getActualScrollbarPos() {
        return this.smoothScrollTargetY == -1 ? this.scrollbarY : this.smoothScrollTargetY;
    }

    @Override
    public void handleScroll(int mouseX, int mouseY, int dWheel) {
        super.handleScroll(mouseX, mouseY, dWheel);
        if (!this.scrollerClicked && !this.slots.isEmpty() && GuiUtils.isInBox(this.posX, this.posY, this.width, this.height, mouseX, mouseY)) {
            this.smoothScrollTargetY = this.clampToScrollbar((int)((float)this.getActualScrollbarPos() - (float)dWheel / (float)this.totalHeight * 30.0f));
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (GuiUtils.isInBox(this.scrollbarX, this.scrollbarY, 6, 20, mouseX, mouseY)) {
            this.smoothScrollTargetY = -1;
            this.scrollerClickMouseOffset = mouseY - this.scrollbarY;
            this.scrollerClicked = true;
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY) {
        super.mouseReleased(mouseX, mouseY);
        this.scrollerClicked = false;
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        if (this.scrollerClicked) {
            this.updateScrollPosition(mouseY - this.scrollerClickMouseOffset);
        } else if (this.smoothScrollTargetY != -1) {
            double amnt = (double)(this.smoothScrollTargetY - this.scrollbarY) / 6.0;
            this.updateScrollPosition((int)((double)this.scrollbarY + (amnt <= 0.0 ? Math.floor(amnt) : Math.ceil(amnt))));
            if (this.scrollbarY == this.smoothScrollTargetY) {
                this.smoothScrollTargetY = -1;
            }
        }
        for (GuiScrollerSlot slot : this.slots) {
            if (slot == null) continue;
            slot.preRenderCallback(mouseX, mouseY);
        }
        this.drawBackground();
        this.renderScrollbar();
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        int factor = sr.func_78325_e();
        GL11.glPushMatrix();
        int translation = this.getSlotYTranslation();
        GL11.glTranslatef((float)0.0f, (float)(-translation), (float)0.0f);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(this.posX * factor), (int)((this.parentGUI.field_146295_m - (this.posY + this.height - 4)) * factor - 8), (int)(this.width * factor - 30), (int)((this.height - 8) * factor + 15));
        for (GuiScrollerSlot slot : this.slots) {
            slot.doRender(mouseX, mouseY + translation);
        }
        GL11.glDisable((int)3089);
        for (GuiScrollerSlot slot : this.slots) {
            slot.renderNoClip(slot.posX, slot.posY, mouseX, mouseY);
        }
        GL11.glPopMatrix();
    }

    private int getSlotYTranslation() {
        int maxTranslate = this.totalHeight - this.height;
        return (int)((float)(this.scrollbarY - this.scrollbarMinY) / (float)(this.scrollbarMaxY - this.scrollbarMinY) * (float)maxTranslate);
    }

    private void renderScrollbar() {
        if (this.totalHeight > this.height) {
            GuiUtils.drawRect(this.scrollbarX - 2, this.posY + 2, 10, this.height - 4, "0x222222", 0.5f);
            GuiUtils.drawRect(this.scrollbarX, this.scrollbarY, 6, 20, "0xFFFFFF", 0.3f);
        }
    }

    public void setTextList(List<String> list) {
        this.slots.clear();
        for (String text : list) {
            if (text.startsWith("//")) continue;
            if (text.startsWith("<image>")) {
                String[] split = text.replace("<image>", "").split("<>");
                String imageUrl = split[0];
                int imageWidth = Integer.parseInt(split[1]);
                int imageHeight = Integer.parseInt(split[2]);
                GuiScrollerSlotImage imageSlot = new GuiScrollerSlotImage(imageUrl, imageWidth, imageHeight);
                imageSlot.scroller = this;
                this.slots.add(imageSlot);
                this.onSlotHeightChanged();
                continue;
            }
            boolean renderSmall = false;
            if (text.startsWith("<s>")) {
                renderSmall = true;
                text = text.replace("<s>", "");
            }
            GuiScrollerSlotText newSlot = new GuiScrollerSlotText(text);
            if (renderSmall) {
                newSlot.renderSmall();
            }
            newSlot.scroller = this;
            this.slots.add(newSlot);
            this.onSlotHeightChanged();
        }
    }

    public boolean isSelected(GuiScrollerSlot slot) {
        return slot.index == this.selectedSlot;
    }

    public void setSlotList(Iterator<? extends GuiScrollerSlot> newSlots) {
        this.slots.clear();
        Iterators.addAll(this.slots, newSlots);
        this.onSlotHeightChanged();
    }

    @Override
    public void onClose() {
        if (this.slots != null && this.slots.size() > 0) {
            this.slots.forEach(GuiScrollerSlot::onClose);
        }
    }
}

