/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.client.gui.menu;

import fr.vartax.client.gui.menu.GuiCustomMainMenu;
import fr.vartax.client.gui.menu.button.GuiScrollerSlot;
import fr.vartax.utils.renders.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class GuiScrollerSlotText
extends GuiScrollerSlot {
    private final String displayText;
    private boolean renderSmall = false;
    private String linkURL;

    public GuiScrollerSlotText(String text) {
        this.displayText = text;
    }

    public static String translateAlternateColorCodes(String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != '&' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    public GuiScrollerSlotText setUrl(String givenURL) {
        this.linkURL = givenURL;
        return this;
    }

    public GuiScrollerSlotText renderSmall() {
        this.renderSmall = true;
        return this;
    }

    @Override
    public boolean canSelect() {
        return true;
    }

    @Override
    public void doRender(int mouseX, int mouseY) {
        GuiUtils.renderTextScaled((this.isSelected() || this.isHovered(mouseX, mouseY) && this.linkURL != null ? EnumChatFormatting.WHITE : "") + GuiScrollerSlotText.translateAlternateColorCodes(this.displayText), this.posX + 2, this.posY + 2, this.renderSmall ? 0.5 : 1.0);
    }

    @Override
    public int height() {
        return this.renderSmall ? 6 : 11;
    }

    @Override
    public void clicked(int mouseX, int mouseY) {
        super.clicked(mouseX, mouseY);
        String[] words = this.displayText.split(" ");
        if (this.linkURL != null) {
            if (this.linkURL.startsWith("http://") || this.linkURL.startsWith("https://")) {
                GuiCustomMainMenu.openURL(this.linkURL);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                return;
            }
        } else {
            String[] var4 = words;
            int var5 = words.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                String word = var4[var6];
                if (word.length() > 2 && word.startsWith("&")) {
                    word = word.substring(2);
                }
                if (!word.startsWith("http://") && (!word.startsWith("https://") || !this.isHovered(mouseX, mouseY))) continue;
                GuiCustomMainMenu.openURL(word);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                return;
            }
        }
    }
}

