/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.client.gui.menu.button;

import fr.vartax.client.gui.menu.GuiScroller;
import fr.vartax.client.gui.menu.button.Buttons;
import fr.vartax.utils.renders.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;

public abstract class GuiScrollerSlot {
    protected final List<GuiButton> buttons = new ArrayList<GuiButton>();
    public GuiScroller scroller;
    public int posX;
    public int posY;
    public boolean isReady = true;
    public int index;

    public final void init(GuiScroller scroller, int index, int posX, int posY) {
        this.scroller = scroller;
        this.index = index;
        this.posX = posX;
        this.posY = posY;
        this.init();
    }

    protected void init() {
        this.buttons.clear();
    }

    public GuiButton addButton(GuiButton button) {
        this.buttons.add(button);
        return button;
    }

    public abstract boolean canSelect();

    protected void actionPerformed(GuiButton button) {
    }

    public void clicked(int mouseX, int mouseY) {
        Buttons.click(this.buttons, mouseX, mouseY, this::actionPerformed);
    }

    public final boolean isSelected() {
        return this.scroller.isSelected(this);
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return GuiUtils.isInBox(this.posX, this.posY, this.scroller.width, this.height(), mouseX, mouseY);
    }

    public void onClose() {
    }

    public void preRenderCallback(int mouseX, int mouseY) {
    }

    public void doRender(int mouseX, int mouseY) {
        this.drawBackground(mouseX, mouseY);
        Buttons.draw(this.buttons, mouseX, mouseY);
    }

    public void renderNoClip(int x, int y, int mouseX, int mouseY) {
    }

    protected void drawBackground(int mouseX, int mouseY) {
        int color = this.isDisabled() ? -12320768 : (this.isSelected() ? 436272896 : (this.isHovered(mouseX, mouseY) ? 0x21FFFFFF : 0x6F000000));
        Gui.func_73734_a((int)(this.posX + this.paddingLeft()), (int)(this.posY + this.paddingTop()), (int)(this.posX + this.scroller.width - this.paddingRight()), (int)(this.posY + this.height() - this.paddingBottom()), (int)color);
    }

    protected int paddingLeft() {
        return 2;
    }

    protected int paddingRight() {
        return 20;
    }

    protected int paddingTop() {
        return 2;
    }

    protected int paddingBottom() {
        return 0;
    }

    public boolean isDisabled() {
        return false;
    }

    public abstract int height();
}

