/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.client.gui.splash;

import java.nio.FloatBuffer;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL11;

public final class Color {
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Color YELLOW = new Color(1.0f, 1.0f, 0.0f, 1.0f);
    public static final Color RED = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    public static final Color BLUE = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    public static final Color GREEN = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    public static final Color BLACK = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Color GRAY = new Color(0.5f, 0.5f, 0.5f, 1.0f);
    public static final Color CYAN = new Color(0.0f, 1.0f, 1.0f, 1.0f);
    public static final Color DARKGRAY = new Color(0.3f, 0.3f, 0.3f, 1.0f);
    public static final Color LIGHTGRAY = new Color(0.7f, 0.7f, 0.7f, 1.0f);
    public static final Color PINK = new Color(1.0f, 0.7f, 0.7f, 1.0f);
    public static final Color ORANGE = new Color(1.0f, 0.8f, 0.0f, 1.0f);
    public static final Color MAGENTA = new Color(1.0f, 0.0f, 1.0f, 1.0f);
    public static final Color TRANSPARENT = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Color RAINBOW = new Color(1.0f, 1.0f, 1.0f, 1.0f, color -> {
        Color rainbow = Color.RAINBOW();
        color.r = rainbow.r;
        color.g = rainbow.g;
        color.b = rainbow.b;
        color.a = rainbow.a;
    });
    public static final Color LOADING = new Color(1.0f, 1.0f, 1.0f, 1.0f, color -> {
        Color loading = Color.LOADING();
        color.r = loading.r;
        color.g = loading.g;
        color.b = loading.b;
        color.a = loading.a;
    });
    public float r = 0.0f;
    public float g = 0.0f;
    public float b = 0.0f;
    public float a = 1.0f;
    public Consumer<Color> update;

    public Color(Color color) {
        this(color.r, color.g, color.b, color.a);
    }

    public Color(java.awt.Color color) {
        this((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
    }

    public Color(FloatBuffer buffer) {
        this(buffer.get(), buffer.get(), buffer.get(), buffer.get());
    }

    public Color(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public Color(int r, int g, int b) {
        this((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
    }

    public Color(int r, int g, int b, int a) {
        this((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public Color(int value) {
        int r = (value & 0xFF0000) >> 16;
        int g = (value & 0xFF00) >> 8;
        int b = value & 0xFF;
        int a = (value & 0xFF000000) >> 24;
        if (a < 0) {
            a += 256;
        }
        if (a == 0) {
            a = 255;
        }
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.a = (float)a / 255.0f;
    }

    public Color(float r, float g, float b, float a) {
        this.r = Math.min(r, 1.0f);
        this.g = Math.min(g, 1.0f);
        this.b = Math.min(b, 1.0f);
        this.a = Math.min(a, 1.0f);
    }

    public Color(float r, float g, float b, float a, Consumer<Color> update) {
        this.r = Math.min(r, 1.0f);
        this.g = Math.min(g, 1.0f);
        this.b = Math.min(b, 1.0f);
        this.a = Math.min(a, 1.0f);
        this.update = update;
    }

    public static Color decode(String nm) {
        if ("rainbow".equalsIgnoreCase(nm.replace("#", ""))) {
            return Color.RAINBOW();
        }
        if ("loading".equalsIgnoreCase(nm.replace("#", ""))) {
            return Color.LOADING();
        }
        if (nm.startsWith("rgb(")) {
            String[] parts = nm.substring(4, nm.length() - 1).split(",");
            return new Color(Integer.parseInt(parts[0].trim()), Integer.parseInt(parts[1].trim()), Integer.parseInt(parts[2].trim()));
        }
        if (nm.startsWith("rgba(")) {
            String[] parts = nm.substring(5, nm.length() - 1).split(",");
            return new Color(Integer.parseInt(parts[0].trim()), Integer.parseInt(parts[1].trim()), Integer.parseInt(parts[2].trim()), Integer.parseInt(parts[3].trim()));
        }
        if (!nm.startsWith("#")) {
            nm = "#" + nm;
        }
        if (nm.length() == 7) {
            return new Color(Integer.decode(nm.substring(0, 7)));
        }
        if (nm.length() == 9) {
            int intval = Integer.decode(nm);
            int red = intval >> 24 & 0xFF;
            int green = intval >> 16 & 0xFF;
            int blue = intval >> 8 & 0xFF;
            int alpha = intval >> 0 & 0xFF;
            return new Color(red, green, blue, alpha);
        }
        throw new NumberFormatException("Invalid color: " + nm);
    }

    public String encode() {
        String hexRed = Integer.toHexString(this.getRed());
        String hexGreen = Integer.toHexString(this.getGreen());
        String hexBlue = Integer.toHexString(this.getBlue());
        String hexAlpha = Integer.toHexString(this.getAlpha());
        hexRed = this.padZero(hexRed);
        hexGreen = this.padZero(hexGreen);
        hexBlue = this.padZero(hexBlue);
        hexAlpha = this.padZero(hexAlpha);
        String hexCode = "#" + hexRed + hexGreen + hexBlue + hexAlpha;
        return hexCode.toUpperCase();
    }

    private String padZero(String str) {
        return str.length() == 1 ? "0" + str : str;
    }

    public static Color fill(float color) {
        return new Color(color, color, color);
    }

    public static Color fill(int color) {
        return new Color(color, color, color);
    }

    public void bind() {
        this.update();
        GL11.glColor4f((float)this.r, (float)this.g, (float)this.b, (float)this.a);
    }

    public void bind(Runnable runnable) {
        this.bind();
        runnable.run();
        Color.reset();
    }

    public int getRGB() {
        return ((int)(this.a * 255.0f) & 0xFF) << 24 | ((int)(this.r * 255.0f) & 0xFF) << 16 | ((int)(this.g * 255.0f) & 0xFF) << 8 | ((int)(this.b * 255.0f) & 0xFF) << 0;
    }

    public Color darker() {
        return this.darker(0.5f);
    }

    public Color darker(float scale) {
        scale = 1.0f - scale;
        return new Color(this.r * scale, this.g * scale, this.b * scale, this.a);
    }

    public Color brighter() {
        return this.brighter(0.2f);
    }

    public int getRed() {
        return (int)(this.r * 255.0f);
    }

    public int getGreen() {
        return (int)(this.g * 255.0f);
    }

    public int getBlue() {
        return (int)(this.b * 255.0f);
    }

    public int getAlpha() {
        return (int)(this.a * 255.0f);
    }

    public int getRedByte() {
        return (int)(this.r * 255.0f);
    }

    public int getGreenByte() {
        return (int)(this.g * 255.0f);
    }

    public int getBlueByte() {
        return (int)(this.b * 255.0f);
    }

    public int getAlphaByte() {
        return (int)(this.a * 255.0f);
    }

    public Color brighter(float scale) {
        return new Color(this.r * (scale += 1.0f), this.g * scale, this.b * scale, this.a);
    }

    public Color multiply(Color c) {
        return new Color(this.r * c.r, this.g * c.g, this.b * c.b, this.a * c.a);
    }

    public void add(Color c) {
        this.r += c.r;
        this.g += c.g;
        this.b += c.b;
        this.a += c.a;
    }

    public void scale(float value) {
        this.r *= value;
        this.g *= value;
        this.b *= value;
        this.a *= value;
    }

    public Color addToCopy(Color c) {
        Color copy = new Color(this.r, this.g, this.b, this.a, this.update);
        copy.r += c.r;
        copy.g += c.g;
        copy.b += c.b;
        copy.a += c.a;
        return copy;
    }

    public Color scaleCopy(float value) {
        Color copy = new Color(this.r, this.g, this.b, this.a, this.update);
        copy.r *= value;
        copy.g *= value;
        copy.b *= value;
        copy.a *= value;
        return copy;
    }

    public Color to(Color target, float progress) {
        return Color.transition(this, target, progress);
    }

    public float[] RGBtoHSB(float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int n = cmax = this.getRed() > this.getGreen() ? this.getRed() : this.getGreen();
        if (this.getBlue() > cmax) {
            cmax = this.getBlue();
        }
        int n2 = cmin = this.getRed() < this.getGreen() ? this.getRed() : this.getGreen();
        if (this.getBlue() < cmin) {
            cmin = this.getBlue();
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)((cmax - cmin) / cmax) : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (cmax - this.getRed()) / (cmax - cmin);
            float greenc = (cmax - this.getGreen()) / (cmax - cmin);
            float bluec = (cmax - this.getBlue()) / (cmax - cmin);
            hue = this.getRed() == cmax ? bluec - greenc : (this.getGreen() == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public Color copy() {
        return new Color(this.r, this.g, this.b, this.a, this.update);
    }

    public Color copyAlpha(float alpha) {
        return new Color(this.r, this.g, this.b, alpha, this.update);
    }

    public Color copyRed(float red) {
        return new Color(red, this.g, this.b, this.a, this.update);
    }

    public Color copyGreen(float green) {
        return new Color(this.r, green, this.b, this.a, this.update);
    }

    public Color copyBlue(float blue) {
        return new Color(this.r, this.g, blue, this.a, this.update);
    }

    public Color update() {
        if (this.update != null) {
            this.update.accept(this);
        }
        return this;
    }

    public static float[] RGBtoHSB(int r, int g, int b, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)((cmax - cmin) / cmax) : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (cmax - r) / (cmax - cmin);
            float greenc = (cmax - g) / (cmax - cmin);
            float bluec = (cmax - b) / (cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public static void reset() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static Color transition(Color color1, Color color2, float progress) {
        if (progress == 0.0f) {
            return color1;
        }
        if (progress == 1.0f) {
            return color2;
        }
        return new Color(color1.r * (1.0f - progress) + color2.r * progress, color1.g * (1.0f - progress) + color2.g * progress, color1.b * (1.0f - progress) + color2.b * progress, color1.a * (1.0f - progress) + color2.a * progress, progress > 0.5f ? color2.update : color1.update);
    }

    public static Color RAINBOW() {
        return new Color(java.awt.Color.HSBtoRGB((float)(System.currentTimeMillis() % 3000L) / 3000.0f, 0.8f, 0.8f));
    }

    public static Color RAINBOW(long time) {
        return new Color(java.awt.Color.HSBtoRGB((float)(time % 3000L) / 3000.0f, 0.8f, 0.8f));
    }

    public static Color LOADING() {
        long now = System.currentTimeMillis();
        float color = (float)((Math.sin(Math.PI * 2 * (double)(now % 4000L) / 2000.0) + 1.0) / 50.0) + 0.15f;
        return new Color(color, color, color);
    }

    public String toString() {
        return String.format("Color(%d, %d, %d, %d) [%s]", this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha(), this.encode());
    }

    public int hashCode() {
        return (int)(this.r + this.g + this.b + this.a) * 255;
    }

    public boolean equals(Object other) {
        if (other instanceof Color) {
            Color o = (Color)other;
            return o.r == this.r && o.g == this.g && o.b == this.b && o.a == this.a;
        }
        return false;
    }
}

