/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.client.overley;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.overlay.DisplayMessage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class OverlayMessage {
    public static long time;
    public static ArrayList<DisplayMessage> messages;
    public static Minecraft mc;
    public static FontRenderer fr;

    public static void addMessageToQueue(DisplayMessage message) {
        messages.add(message);
    }

    public static void removeLast() {
        if (!messages.isEmpty()) {
            messages.remove(messages.size() - 1);
        }
    }

    public static DisplayMessage getLast() {
        if (messages.isEmpty()) {
            return null;
        }
        return messages.get(messages.size() - 1);
    }

    public static void reset() {
        time = 0L;
        OverlayMessage.removeLast();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onMessage(RenderGameOverlayEvent.Pre event) {
        if (event.type != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        if (messages.isEmpty()) {
            return;
        }
        DisplayMessage message = OverlayMessage.getLast();
        if (message == null) {
            return;
        }
        if (time == 0L) {
            time = System.currentTimeMillis() + (long)(message.time * 1000);
        }
        event.setCanceled(true);
        String title = message.title.replace("&", "").replace("_", " ");
        String subTitle = message.subTitle.replace("&", "").replace("_", " ");
        ScaledResolution scaled = new ScaledResolution(mc, OverlayMessage.mc.field_71443_c, OverlayMessage.mc.field_71440_d);
        int width = scaled.func_78326_a();
        int height = scaled.func_78328_b();
        int x1 = (width - fr.func_78256_a(title) * 3) / 2;
        int y1 = (height - 35) / 2;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x1, (double)y1, (double)0.0);
        GL11.glScaled((double)3.0, (double)3.0, (double)3.0);
        fr.func_78276_b(title, 0, 0, 0xFFFFFF);
        GL11.glPopMatrix();
        int x2 = (width - fr.func_78256_a(subTitle)) / 2;
        int y2 = (int)((double)height / 1.8);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x2, (double)y2, (double)0.0);
        fr.func_78276_b(subTitle, 0, 0, 0xFFFFFF);
        GL11.glPopMatrix();
        if (System.currentTimeMillis() >= time) {
            OverlayMessage.reset();
        }
    }

    static {
        messages = new ArrayList();
        mc = Minecraft.func_71410_x();
        fr = OverlayMessage.mc.field_71466_p;
    }
}

