/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class DatabaseConfig {
    private Properties properties;
    private File configFile;

    public DatabaseConfig(File configDir) {
        this.configFile = new File(configDir, "jobs_database.properties");
        this.properties = new Properties();
        this.loadConfig();
    }

    private void loadConfig() {
        if (!this.configFile.exists()) {
            this.createDefaultConfig();
        }
        try (FileInputStream fis = new FileInputStream(this.configFile);){
            this.properties.load(fis);
            System.out.println("[Jobs] Configuration charg\u00e9e depuis " + this.configFile.getPath());
        }
        catch (IOException e) {
            System.err.println("[Jobs] Erreur lors du chargement de la configuration !");
            e.printStackTrace();
            this.createDefaultConfig();
        }
    }

    private void createDefaultConfig() {
        try {
            this.configFile.getParentFile().mkdirs();
            this.configFile.createNewFile();
            this.properties.setProperty("database.type", "mysql");
            this.properties.setProperty("mysql.host", "localhost");
            this.properties.setProperty("mysql.port", "3306");
            this.properties.setProperty("mysql.database", "vartacraft");
            this.properties.setProperty("mysql.username", "root");
            this.properties.setProperty("mysql.password", "");
            this.properties.setProperty("mysql.table", "player_jobs");
            this.properties.setProperty("mysql.pool.minConnections", "2");
            this.properties.setProperty("mysql.pool.maxConnections", "10");
            this.properties.setProperty("mysql.pool.timeout", "30000");
            this.properties.setProperty("autosave.interval", "300");
            this.properties.setProperty("mysql.autoCreateTable", "true");
            this.properties.setProperty("mysql.showQueries", "false");
            this.saveConfig();
            System.out.println("[Jobs] Fichier de configuration cr\u00e9\u00e9 : " + this.configFile.getPath());
        }
        catch (IOException e) {
            System.err.println("[Jobs] Impossible de cr\u00e9er le fichier de configuration !");
            e.printStackTrace();
        }
    }

    public void saveConfig() {
        try (FileOutputStream fos = new FileOutputStream(this.configFile);){
            this.properties.store(fos, "VartaCraft Jobs - Configuration de la base de donn\u00e9es");
            System.out.println("[Jobs] Configuration sauvegard\u00e9e");
        }
        catch (IOException e) {
            System.err.println("[Jobs] Erreur lors de la sauvegarde de la configuration !");
            e.printStackTrace();
        }
    }

    public String getDatabaseType() {
        return this.properties.getProperty("database.type", "mysql");
    }

    public String getMySQLHost() {
        return this.properties.getProperty("mysql.host", "localhost");
    }

    public int getMySQLPort() {
        return Integer.parseInt(this.properties.getProperty("mysql.port", "3306"));
    }

    public String getMySQLDatabase() {
        return this.properties.getProperty("mysql.database", "vartacraft");
    }

    public String getMySQLUsername() {
        return this.properties.getProperty("mysql.username", "root");
    }

    public String getMySQLPassword() {
        return this.properties.getProperty("mysql.password", "");
    }

    public String getMySQLTable() {
        return this.properties.getProperty("mysql.table", "player_jobs");
    }

    public int getPoolMinConnections() {
        return Integer.parseInt(this.properties.getProperty("mysql.pool.minConnections", "2"));
    }

    public int getPoolMaxConnections() {
        return Integer.parseInt(this.properties.getProperty("mysql.pool.maxConnections", "10"));
    }

    public int getPoolTimeout() {
        return Integer.parseInt(this.properties.getProperty("mysql.pool.timeout", "30000"));
    }

    public int getAutosaveInterval() {
        return Integer.parseInt(this.properties.getProperty("autosave.interval", "300"));
    }

    public boolean isAutoCreateTable() {
        return Boolean.parseBoolean(this.properties.getProperty("mysql.autoCreateTable", "true"));
    }

    public boolean isShowQueries() {
        return Boolean.parseBoolean(this.properties.getProperty("mysql.showQueries", "false"));
    }

    public String getJdbcUrl() {
        return String.format("jdbc:mysql://%s:%d/%s?autoReconnect=true&useSSL=false", this.getMySQLHost(), this.getMySQLPort(), this.getMySQLDatabase());
    }
}

