/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.entity.mobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.Vartacraft;
import fr.vartax.client.overley.CustomBossStatus;
import fr.vartax.entity.GuardianHelper;
import fr.vartax.entity.mobs.EntityAIGardien;
import fr.vartax.init.register.RegisterItems;
import fr.vartax.items.ItemGardienUpgrade;
import fr.vartax.items.ItemWhitelist;
import fr.vartax.network.PacketGradien;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityGardien
extends EntityTameable
implements IAnimals,
IInventory,
IBossDisplayData {
    public ItemStack[] content;
    public ItemStack[] contentChest;
    private String name;
    private int attackCooldown;
    private int attackTimer;
    private boolean isUseable;
    private int level;
    private int subLevel;
    private int requiredXP;
    public String ownerUUID;
    private double life;
    private double speed;
    private double damages;
    private int textureid;
    private int xpmodifier;
    private int anchorX;
    private int anchorY;
    private int anchorZ;
    private boolean anchorInitialized = true;
    private int regenModifier = 1;
    private ItemStack weapon;
    private long lastDrop;
    private long lastXP;
    public final double HEALTH_UP = 100.0;
    public final double SPEED_UP = 0.02;
    public final double DAMAGE_UP = 1.0;
    public final double HEALTH_BASE = 100.0;
    public final double SPEED_BASE = 0.25;
    public final double DAMAGE_BASE = 1.0;
    public final int TEXTURE_DEFAULT = 0;

    public EntityGardien(World world) {
        super(world);
        this.func_70105_a(1.4f, 2.9f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70715_bh.func_75776_a(8, (EntityAIBase)new EntityAIGardien(this, EntityPlayer.class, 0.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityWither.class, 15.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityGardien.class, 15.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.requiredXP = 10;
        this.content = new ItemStack[7];
        this.isUseable = true;
        this.textureid = 0;
        this.name = "Guardian Golem";
        this.xpmodifier = 1;
        this.field_70158_ak = true;
        this.damages = 1.0;
        this.func_70062_b(0, new ItemStack(RegisterItems.vartoxSword));
    }

    public void addInformations(ItemStack[] content, int level, int subLevel, String player) {
        this.content = content;
        this.level = level;
        this.subLevel = subLevel;
        this.ownerUUID = player;
        this.func_70606_j(100.0f);
        this.setRequiredXP(level);
    }

    @SideOnly(value=Side.CLIENT)
    public void setClientInfos(int level, int subLevel, ItemStack weapon) {
        this.level = level;
        this.subLevel = subLevel;
        this.weapon = weapon;
        this.setRequiredXP(level);
    }

    public void sync() {
        PacketGradien packet = new PacketGradien();
        packet.addInformations(this.level, this.subLevel, this.func_145782_y());
        Vartacraft var10000 = Vartacraft.instance;
        Vartacraft.proxy.packetPipeline.sendToAll(packet);
        this.damages = 1.0 + 1.0 * (double)this.level;
        this.speed = 0.25 + 0.02 * (double)this.level;
        this.life = 100.0 + 100.0 * (double)this.level;
    }

    public void func_70636_d() {
        int k;
        int j;
        Block block;
        int i;
        super.func_70636_d();
        this.checkForUpgardes();
        if (this.field_70170_p.field_72995_K) {
            CustomBossStatus.setBossStatus(this, true);
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (!this.field_70170_p.field_72995_K && (double)this.func_110143_aJ() < this.life && this.field_70146_Z.nextInt(20) == 0 && this.isUseable) {
            if (GuardianHelper.hasUpgrade(this, 2)) {
                this.regenModifier = 2;
            }
            if (GuardianHelper.hasUpgrade(this, 3)) {
                this.regenModifier = 3;
            }
            if (GuardianHelper.hasUpgrade(this, 4)) {
                this.regenModifier = 4;
            }
            this.func_70606_j(this.func_110143_aJ() + (float)this.regenModifier);
        }
        if (!this.field_70170_p.field_72995_K && GuardianHelper.hasUpgrade(this, 21) && this.lastDrop + 300000L >= System.currentTimeMillis()) {
            this.lastDrop = System.currentTimeMillis();
            i = this.field_70170_p.field_73012_v.nextInt(4);
            switch (i) {
                case 0: {
                    new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(RegisterItems.jade, 1));
                    break;
                }
                case 1: {
                    new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(RegisterItems.titane, 1));
                    break;
                }
                case 2: {
                    new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(RegisterItems.vartox, 1));
                    break;
                }
                case 3: {
                    new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Items.field_151042_j, 1));
                    break;
                }
                case 4: {
                    new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Items.field_151045_i, 1));
                }
            }
        }
        if (GuardianHelper.hasUpgrade(this, 21) && this.lastXP + 300000L >= System.currentTimeMillis()) {
            i = this.field_70170_p.field_73012_v.nextInt(100);
            this.lastXP = System.currentTimeMillis();
            this.addXp(i);
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && (block = this.field_70170_p.func_147439_a(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), k = MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
            this.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)block) + "_" + this.field_70170_p.func_72805_g(i, j, k), this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.field_70121_D.field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
        }
        if (GuardianHelper.hasUpgrade(this, 7)) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.life * 1.1);
        }
        if (GuardianHelper.hasUpgrade(this, 8)) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.life * 1.3);
        }
        if (GuardianHelper.hasUpgrade(this, 9)) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.life * 1.5);
        }
        if (!(GuardianHelper.hasUpgrade(this, 9) || GuardianHelper.hasUpgrade(this, 8) || GuardianHelper.hasUpgrade(this, 7))) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.life);
        }
        if (!GuardianHelper.hasUpgrade(this, 20) && this.weapon != null) {
            ItemStack weaponCopy = this.weapon.func_77946_l();
            this.weapon = null;
            this.func_70062_b(0, null);
            EntityItem weaponEntity = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, weaponCopy);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)weaponEntity);
            }
        }
    }

    public void func_70645_a(DamageSource damage) {
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag;
        if (entity instanceof EntityPlayer && this.checkWhitelist((EntityPlayer)entity)) {
            return false;
        }
        if (this.attackTimer == 0) {
            this.attackTimer = this.attackCooldown;
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float damageMultiplier = 1.0f;
        float damageAdder = 0.0f;
        if (GuardianHelper.hasUpgrade(this, 10)) {
            damageMultiplier = 1.1f;
        }
        if (GuardianHelper.hasUpgrade(this, 11)) {
            damageMultiplier = 1.3f;
        }
        if (GuardianHelper.hasUpgrade(this, 12)) {
            damageMultiplier = 1.5f;
        }
        if (GuardianHelper.hasUpgrade(this, 13)) {
            damageAdder = 0.5f;
        }
        if (GuardianHelper.hasUpgrade(this, 14)) {
            damageAdder = 1.0f;
        }
        if (GuardianHelper.hasUpgrade(this, 15)) {
            damageAdder = 1.5f;
        }
        if (flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(this.damages + (double)this.field_70146_Z.nextInt(5)) * damageMultiplier + damageAdder)) {
            entity.field_70181_x += (double)0.4f;
        }
        this.func_85030_a("mob.irongolem.throw", 1.0f, 1.0f);
        return flag;
    }

    public boolean checkWhitelist(EntityPlayer entity) {
        if (entity == null) {
            return false;
        }
        return this.ownerUUID != null && entity.func_110124_au().toString().equals(this.ownerUUID) ? true : ItemWhitelist.check(this.content[6], entity.getDisplayName());
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (player.func_70093_af() && player.func_70694_bm() == null && this.weapon != null && GuardianHelper.hasUpgrade(this, 20)) {
            player.func_70062_b(0, this.weapon.func_77946_l());
            this.weapon = null;
            this.func_70062_b(0, this.weapon);
            this.sync();
            return true;
        }
        if (player.func_70694_bm() != null && (player.func_70694_bm().func_77973_b() instanceof ItemSword || player.func_70694_bm().func_77973_b() instanceof ItemAxe) && GuardianHelper.hasUpgrade(this, 20)) {
            ItemStack stack = player.func_70694_bm();
            this.weapon = stack.func_77946_l();
            this.func_70062_b(0, this.weapon);
            player.func_70062_b(0, (ItemStack)null);
            this.sync();
            return true;
        }
        if (player.func_70694_bm() != null && GuardianHelper.checkXPStuff(player.func_70694_bm().func_77973_b())) {
            if (this.level < 80) {
                this.consumeXP(player);
                this.field_70170_p.func_72869_a("happyVillager", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            this.sync();
            return true;
        }
        if (!this.field_70170_p.field_72995_K && this.checkWhitelist(player)) {
            player.openGui((Object)Vartacraft.instance, 5, this.field_70170_p, this.func_145782_y(), 0, 0);
            this.sync();
            return true;
        }
        return super.func_70085_c(player);
    }

    protected void func_82167_n(Entity entity) {
        if (entity instanceof IMob && this.func_70681_au().nextInt(20) == 0) {
            this.func_70624_b((EntityLivingBase)entity);
        }
        super.func_82167_n(entity);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void checkForUpgardes() {
        this.xpmodifier = 1;
        for (int i = 0; i < 3; ++i) {
            if (this.content[i] == null) continue;
            int type = ((ItemGardienUpgrade)this.content[i].func_77973_b()).getType();
            switch (type) {
                case 0: {
                    this.xpmodifier = 2;
                }
            }
        }
        this.name = "Gardien";
    }

    public int func_70302_i_() {
        return this.content.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.content[slot];
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        if (this.content[slotIndex] != null) {
            if (this.content[slotIndex].field_77994_a <= amount) {
                ItemStack itemstack = this.content[slotIndex];
                this.content[slotIndex] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.content[slotIndex].func_77979_a(amount);
            if (this.content[slotIndex].field_77994_a == 0) {
                this.content[slotIndex] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (this.content[slotIndex] != null) {
            ItemStack itemstack = this.content[slotIndex];
            this.content[slotIndex] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack stack) {
        this.content[slotIndex] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "Entity.GuardianGolem";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (!this.isUseable) {
            return false;
        }
        return player.func_70092_e(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public EntityAgeable func_90011_a(EntityAgeable p_90011_1_) {
        return null;
    }

    public boolean func_70909_n() {
        return true;
    }

    public void func_70109_d(NBTTagCompound compound) {
        super.func_70109_d(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.content[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        if (this.weapon != null) {
            NBTTagCompound weaponComp = new NBTTagCompound();
            this.weapon.func_77955_b(weaponComp);
            compound.func_74782_a("Weapon", (NBTBase)weaponComp);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        compound.func_74768_a("Levels", this.level);
        compound.func_74768_a("SubLevels", this.subLevel);
        compound.func_74778_a("player", this.ownerUUID);
        compound.func_74757_a("isUseable", this.isUseable);
        compound.func_74772_a("LastDrop", this.lastDrop);
        compound.func_74772_a("LastXP", this.lastXP);
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.content = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.content.length) continue;
            this.content[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.level = compound.func_74762_e("Levels");
        this.subLevel = compound.func_74762_e("SubLevels");
        this.ownerUUID = compound.func_74779_i("player");
        this.setRequiredXP(this.level);
        if (compound.func_74764_b("Weapon")) {
            this.weapon = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)compound.func_74781_a("Weapon")));
        }
        this.anchorInitialized = false;
        this.lastDrop = compound.func_74763_f("LastDrop");
        this.lastXP = compound.func_74763_f("LastXP");
        this.anchorX = compound.func_74762_e("anchorX");
        this.anchorY = compound.func_74762_e("anchorY");
        this.anchorZ = compound.func_74762_e("anchorZ");
    }

    public int getLevel() {
        return this.level;
    }

    @SideOnly(value=Side.CLIENT)
    public int getLife() {
        return (int)this.life;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSpeed() {
        return (int)(this.speed * 10.0);
    }

    @SideOnly(value=Side.CLIENT)
    public int getDamages() {
        return (int)this.damages;
    }

    @SideOnly(value=Side.CLIENT)
    public String getGuardianName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public float getScaledHealth() {
        return this.func_110143_aJ() / this.func_110138_aP();
    }

    @SideOnly(value=Side.CLIENT)
    public float getRequiredXP() {
        return this.requiredXP;
    }

    @SideOnly(value=Side.CLIENT)
    public int getTextureId() {
        return this.textureid;
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSubLevel() {
        return this.subLevel;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte byt) {
        if (byt == 4 && this.attackTimer == 0) {
            this.attackTimer = 10;
            this.func_85030_a("mob.irongolem.throw", 1.0f, 1.0f);
        } else {
            super.func_70103_a(byt);
        }
    }

    public void setOwner(EntityPlayer player) {
        this.ownerUUID = player.func_110124_au().toString();
    }

    public void setRequiredXP(int level) {
        this.requiredXP = 1 * level * level + 10;
    }

    public void addXp(int xp) {
        this.subLevel += xp * this.xpmodifier;
        if (this.subLevel >= this.requiredXP) {
            ++this.level;
            this.subLevel -= this.requiredXP;
            this.setRequiredXP(this.level);
            this.onLevelUp();
            this.addXp(0);
        }
    }

    public void onLevelUp() {
        this.speed += 0.02;
        this.damages += 1.0;
        this.life += 100.0;
        this.applyLevelModifiers();
    }

    public void applyLevelModifiers() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.life);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.speed);
    }

    private void consumeXP(EntityPlayer player) {
        ItemStack stack = player.func_70694_bm();
        this.addXp(GuardianHelper.getXpFromItem(stack.func_77973_b()));
        --stack.field_77994_a;
        if (stack.field_77994_a <= 0) {
            stack = null;
        }
    }

    public ItemStack fromGuardianToStone() {
        ItemStack stack = new ItemStack(RegisterItems.GardienCore);
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.content[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        compound.func_74768_a("Levels", this.level);
        compound.func_74768_a("SubLevels", this.subLevel);
        compound.func_74778_a("player", this.ownerUUID);
        compound.func_74757_a("isUseable", this.isUseable);
        stack.func_77982_d(compound);
        return stack;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxChestSlots() {
        return this.level / 3;
    }

    protected void func_70665_d(DamageSource source, float ammount) {
        EntityPlayer player;
        super.func_70665_d(source, ammount);
        if (source.func_76364_f() != null && source.func_76364_f() instanceof EntityPlayer && (player = (EntityPlayer)source.func_76364_f()) != null) {
            float back = 0.0f;
            if (GuardianHelper.hasUpgrade(this, 17)) {
                back = ammount * 0.1f;
            }
            if (GuardianHelper.hasUpgrade(this, 18)) {
                back = ammount * 0.15f;
            }
            if (GuardianHelper.hasUpgrade(this, 19)) {
                back = ammount * 0.2f;
            }
            player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), back);
        }
    }

    public ItemStack getWeapon() {
        return this.weapon;
    }
}

