/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.future.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.init.register.RegisterBlock;
import fr.vartax.init.tab.future;
import fr.vartax.utils.lib.RenderIDs;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ChorusFlower
extends Block {
    @SideOnly(value=Side.CLIENT)
    private IIcon deadIcon;

    public ChorusFlower() {
        super(Material.field_151575_d);
        this.func_149711_c(0.4f);
        this.func_149675_a(true);
        this.func_149672_a(field_149766_f);
        this.func_149658_d("chorus_flower");
        this.func_149663_c("chorus_flower");
        this.func_149647_a(future.future);
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return !(entity instanceof EntityDragon);
    }

    public int func_149645_b() {
        return RenderIDs.CHORUS_FLOWER;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return meta >= 5 ? this.deadIcon : this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        super.func_149651_a(reg);
        this.deadIcon = reg.func_94245_a("chorus_flower_dead");
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int meta;
        if (!world.field_72995_K && (meta = world.func_72805_g(x, y, z)) < 5) {
            if (!this.func_149718_j(world, x, y, z)) {
                world.func_147480_a(x, y, z, true);
            } else if (world.func_147437_c(x, y + 1, z)) {
                int par8;
                boolean canGrowUp = false;
                boolean isSegmentOnEndstone = false;
                Block lowerBlock = world.func_147439_a(x, y - 1, z);
                if (lowerBlock == Blocks.field_150377_bs) {
                    canGrowUp = true;
                } else if (lowerBlock != RegisterBlock.chorus_plant) {
                    if (lowerBlock.isAir((IBlockAccess)world, x, y - 1, z)) {
                        canGrowUp = true;
                    }
                } else {
                    int height;
                    par8 = 1;
                    for (height = 0; height < 4; ++height) {
                        Block b = world.func_147439_a(x, y - par8 + 1, z);
                        if (b != RegisterBlock.chorus_plant) {
                            if (b != Blocks.field_150377_bs) break;
                            isSegmentOnEndstone = true;
                            break;
                        }
                        ++par8;
                    }
                    height = 4;
                    if (isSegmentOnEndstone) {
                        ++height;
                    }
                    if (par8 < 2 || rand.nextInt(height) >= par8) {
                        canGrowUp = true;
                    }
                }
                if (canGrowUp && ChorusFlower.isSpaceAroundFree(world, x, y + 1, z, ForgeDirection.DOWN) && world.func_147437_c(x, y + 2, z)) {
                    world.func_147449_b(x, y, z, RegisterBlock.chorus_plant);
                    world.func_147465_d(x, y + 1, z, (Block)this, meta, 3);
                } else if (meta < 4) {
                    par8 = rand.nextInt(4);
                    boolean grew = false;
                    if (isSegmentOnEndstone) {
                        ++par8;
                    }
                    for (int i = 0; i < par8; ++i) {
                        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[rand.nextInt(ForgeDirection.VALID_DIRECTIONS.length)];
                        int xx = x + dir.offsetX;
                        int yy = y + dir.offsetY;
                        int zz = z + dir.offsetZ;
                        if (!world.func_147437_c(xx, yy, zz) || !ChorusFlower.isSpaceAroundFree(world, xx, yy, zz, dir.getOpposite())) continue;
                        world.func_147465_d(xx, yy, zz, (Block)this, meta + 1, 3);
                        grew = true;
                    }
                    if (grew) {
                        world.func_147465_d(x, y, z, RegisterBlock.chorus_plant, 0, 3);
                    } else {
                        world.func_147465_d(x, y, z, (Block)this, 5, 3);
                    }
                } else if (meta == 4) {
                    world.func_147465_d(x, y, z, (Block)this, 5, 3);
                }
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbour) {
        if (!this.func_149718_j(world, x, y, z)) {
            world.func_147480_a(x, y, z, false);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return ChorusFlower.canPlantStay(world, x, y, z);
    }

    public static boolean canPlantStay(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        if (block != RegisterBlock.chorus_plant && block != Blocks.field_150377_bs) {
            if (block.isAir((IBlockAccess)world, x, y - 1, z)) {
                int adjecentCount = 0;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    Block adjecentBlock = world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
                    if (adjecentBlock == RegisterBlock.chorus_plant) {
                        ++adjecentCount;
                        continue;
                    }
                    if (adjecentBlock.isAir((IBlockAccess)world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) continue;
                    return false;
                }
                return adjecentCount == 1;
            }
            return false;
        }
        return true;
    }

    public static boolean isSpaceAroundFree(World world, int x, int y, int z, ForgeDirection skip) {
        ForgeDirection dir;
        Iterator<ForgeDirection> iterator = Arrays.asList(ForgeDirection.VALID_DIRECTIONS).iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((dir = iterator.next()) == skip || world.func_147437_c(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ));
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && this.func_149718_j(world, x, y, z);
    }
}

