/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.init.mod;

import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ModEntityList {
    public static Item entity_egg;
    private static EntityData[] array;
    private static Map<Integer, Class<? extends Entity>> map;

    public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModEntityList.registerEntity(entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates, -1, -1, false);
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggColour1, int eggColour2) {
        ModEntityList.registerEntity(entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates, eggColour1, eggColour2, true);
    }

    private static void registerEntity(Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggColour1, int eggColour2, boolean hasEgg) {
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        if (id >= array.length) {
            EntityData[] newArray = new EntityData[id + 5];
            for (int i = 0; i < array.length; ++i) {
                newArray[i] = array[i];
            }
            array = newArray;
        }
        if (array[id] != null) {
            throw new IllegalArgumentException("ID " + id + " is already being used! Please report this error!");
        }
        ModEntityList.array[id] = new EntityData(entityName, id, eggColour1, eggColour2, hasEgg);
        map.put(id, entityClass);
    }

    public static String getName(int id) {
        EntityData data = ModEntityList.getData(id);
        return data == null ? null : "vartacraft." + data.name;
    }

    public static EntityData getData(int id) {
        return id >= array.length ? null : array[id];
    }

    public static boolean hasEntitiesWithEggs() {
        for (EntityData data : array) {
            if (data == null || !data.hasEgg) continue;
            return true;
        }
        return false;
    }

    public static Entity createEntityByID(int id, World world) {
        EntityData data = ModEntityList.getData(id);
        if (data != null && data.hasEgg) {
            try {
                Class<? extends Entity> cls = map.get(id);
                if (cls != null) {
                    return cls.getConstructor(World.class).newInstance(world);
                }
            }
            catch (Exception var4) {
                var4.printStackTrace();
            }
            return null;
        }
        return null;
    }

    public static EntityData[] getDatasWithEggs() {
        LinkedList<EntityData> list = new LinkedList<EntityData>();
        for (Integer id : map.keySet()) {
            EntityData data = ModEntityList.getData(id);
            if (data == null || !data.hasEgg) continue;
            list.add(data);
        }
        return list.toArray(new EntityData[list.size()]);
    }

    public static ItemStack getEggFor(Class<? extends Entity> entityCls) {
        Map.Entry<Integer, Class<? extends Entity>> entry;
        Iterator<Map.Entry<Integer, Class<? extends Entity>>> var1 = map.entrySet().iterator();
        do {
            if (var1.hasNext()) continue;
            return null;
        } while ((entry = var1.next()).getValue() != entityCls);
        return new ItemStack(entity_egg, 1, entry.getKey().intValue());
    }

    static {
        array = new EntityData[0];
        map = new HashMap<Integer, Class<? extends Entity>>();
    }

    public static class EntityData {
        public final String name;
        public final int id;
        public final int eggColour1;
        public final int eggColour2;
        public final boolean hasEgg;

        private EntityData(String name, int id, int eggColour1, int eggColour2, boolean hasEgg) {
            this.name = name;
            this.id = id;
            this.eggColour1 = eggColour1;
            this.eggColour2 = eggColour2;
            this.hasEgg = hasEgg;
        }

        EntityData(String x0, int x1, int x2, int x3, boolean x4, Object x5) {
            this(x0, x1, x2, x3, x4);
        }
    }
}

