/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.items;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.entity.EntityCustomArrow;
import fr.vartax.init.tab.vartacraft;
import fr.vartax.items.ItemArrowBase;
import fr.vartax.utils.renders.BowHelper;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class ItemVartoxBow
extends ItemBow {
    public static final String[] bowPullIconNames = new String[]{"VartoxBow_0", "VartoxBow_1", "VartoxBow_2"};
    private IIcon[] iconArray;
    public IIcon iconSpeed;
    public IIcon iconRange;

    public ItemVartoxBow() {
        this.func_77656_e(900);
        this.func_77625_d(1);
        this.func_77655_b("VartoxBow");
        this.func_111206_d("vartacraft:VartoxBow");
        this.func_77637_a(vartacraft.vartacraft);
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int time) {
        int maxItemUse = this.func_77626_a(stack) - time;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, maxItemUse);
        if (!event.isCanceled()) {
            boolean infiniteAmmo;
            maxItemUse = event.charge;
            MinecraftForge.EVENT_BUS.post((Event)event);
            ItemStack ammo = this.checkForAmmo(player);
            boolean bl = infiniteAmmo = !player.field_71075_bZ.field_75098_d && EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) <= 0;
            if (ammo != null || infiniteAmmo) {
                int type = ammo != null ? ((ItemArrowBase)ammo.func_77973_b()).getEffect() : 0;
                float scaledItemUse = (float)maxItemUse / 20.0f;
                if (!BowHelper.canApply(stack, 1)) {
                    scaledItemUse *= 2.0f;
                }
                if (!((double)(scaledItemUse = (scaledItemUse * scaledItemUse + scaledItemUse * 2.0f) / 3.0f) < 0.1)) {
                    int punchLevel;
                    int powerLevel;
                    if (scaledItemUse > 1.0f) {
                        scaledItemUse = 1.0f;
                    }
                    int[] modifiers = BowHelper.getModifiers(stack);
                    float range = 1.5f;
                    if (BowHelper.canApply(stack, 0)) {
                        range = 2.5f;
                    }
                    EntityCustomArrow entityarrow = new EntityCustomArrow(world, (EntityLivingBase)player, scaledItemUse * range / 2.0f, type, infiniteAmmo);
                    if (scaledItemUse == 1.0f) {
                        entityarrow.func_70243_d(true);
                    }
                    if ((powerLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack)) > 0) {
                        entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
                    }
                    if ((punchLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack)) > 0) {
                        entityarrow.func_70240_a(punchLevel);
                    }
                    if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
                        entityarrow.func_70015_d(100);
                    }
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + scaledItemUse * 0.5f);
                    if (infiniteAmmo) {
                        player.field_71071_by.func_146026_a(ammo.func_77973_b());
                    }
                    if (!world.field_72995_K) {
                        world.func_72838_d((Entity)entityarrow);
                    }
                }
            }
        }
    }

    private ItemStack checkForAmmo(EntityPlayer player) {
        InventoryPlayer inventory = player.field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack result = inventory.func_70301_a(i);
            if (result == null || !(result.func_77973_b() instanceof ItemArrowBase)) continue;
            return result;
        }
        return null;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list) {
        int[] modifiers = BowHelper.getModifiers(stack);
        if (modifiers != null) {
            if (modifiers.length != 0) {
                list.add("\\u00an Modifiers:");
                list.add("");
            }
            for (int i = 0; i < modifiers.length; ++i) {
                list.add(BowHelper.getModifierName(modifiers[i]));
            }
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        int time = 72000;
        if (!BowHelper.canApply(stack, 1)) {
            time = 31000;
        }
        return time;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.bow;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ArrowNockEvent event = new ArrowNockEvent(player, stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        if (player.field_71075_bZ.field_75098_d || this.checkForAmmo(player) != null) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    public boolean func_77623_v() {
        return true;
    }

    public int func_77619_b() {
        return 1;
    }

    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icons) {
        this.field_77791_bV = icons.func_94245_a(this.func_111208_A());
        this.iconArray = new IIcon[bowPullIconNames.length];
        this.iconSpeed = icons.func_94245_a("vartacraft:SpeedUpgrade");
        this.iconRange = icons.func_94245_a("vartacraft:RangeUpgrade");
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = icons.func_94245_a(this.func_111208_A() + "_" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_94599_c(int par1) {
        return this.iconArray[par1];
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (renderPass == 0) {
            int pulling;
            if (player.func_71011_bu() == null) {
                return this.field_77791_bV;
            }
            int pulling1 = 18;
            int pulling2 = 13;
            if (!BowHelper.canApply(stack, 1)) {
                pulling1 = 8;
                pulling2 = 7;
            }
            if ((pulling = stack.func_77988_m() - useRemaining) >= pulling1) {
                return this.iconArray[2];
            }
            return pulling > pulling2 ? this.iconArray[1] : this.iconArray[0];
        }
        if (renderPass == 1) {
            return !BowHelper.canApply(stack, 1) ? this.iconSpeed : null;
        }
        if (renderPass == 2) {
            return !BowHelper.canApply(stack, 0) ? this.iconRange : null;
        }
        return this.iconSpeed;
    }
}

