/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.items;

import fr.vartax.init.register.RegisterBlock;
import fr.vartax.module.jobs.JobType;
import fr.vartax.module.jobs.JobsSystem;
import fr.vartax.module.jobs.data.PlayerJobData;
import fr.vartax.module.jobs.manager.JobManager;
import fr.vartax.module.jobs.network.PacketJobNotification;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockObsidian;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ToolHandler {
    protected static ThreadLocal<Boolean> captureDrops = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    protected static ThreadLocal<List<ItemStack>> capturedDrops = new ThreadLocal<List<ItemStack>>(){

        @Override
        protected List<ItemStack> initialValue() {
            return new ArrayList<ItemStack>();
        }
    };
    public static Block[] minerals = new Block[]{RegisterBlock.jade_ore, Blocks.field_150365_q, Blocks.field_150450_ax, Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150449_bY, Blocks.field_150366_p, Blocks.field_150369_x, RegisterBlock.titane_ore, RegisterBlock.vartox_ore, Blocks.field_150352_o, Blocks.field_150439_ay, RegisterBlock.stoneandesite, RegisterBlock.stonediorite, RegisterBlock.stonegranite, Blocks.field_150343_Z};

    public static int removeBlocksInIteration(EntityPlayer player, ItemStack stack, World world, int x, int y, int z, int xs, int ys, int zs, int xe, int ye, int ze, Block block, Material[] materialsListing, boolean smelt, int fortune, boolean dispose, boolean obsidian) {
        float blockHardness = block == null ? 1.0f : block.func_149712_f(world, x, y, z);
        int blocksBroken = 0;
        for (int x1 = xs; x1 < xe; ++x1) {
            for (int y1 = ys; y1 < ye; ++y1) {
                for (int z1 = zs; z1 < ze; ++z1) {
                    Block currentBlock = world.func_147439_a(x1 + x, y1 + y, z1 + z);
                    if (!currentBlock.isToolEffective("pickaxe", 3) && !(currentBlock instanceof BlockRedstoneOre) && (!obsidian || !(currentBlock instanceof BlockObsidian))) continue;
                    ToolHandler.removeBlockWithDrops(player, stack, world, x1 + x, y1 + y, z1 + z, x, y, z, currentBlock, materialsListing, smelt, fortune, blockHardness, dispose, obsidian);
                    ++blocksBroken;
                    ToolHandler.giveJobsXP(player, currentBlock, world);
                }
            }
        }
        return blocksBroken;
    }

    private static void giveJobsXP(EntityPlayer player, Block block, World world) {
        if (world.field_72995_K) {
            return;
        }
        double xp = ToolHandler.getMiningXP(block);
        if (xp <= 0.0) {
            return;
        }
        PlayerJobData data = JobManager.getInstance().getPlayerData(player);
        data.addXP(JobType.MINEUR, xp);
        if (player instanceof EntityPlayerMP) {
            PacketJobNotification notification = new PacketJobNotification(JobType.MINEUR, xp);
            JobsSystem.packetPipeline.sendTo(notification, (EntityPlayerMP)player);
        }
        JobManager.getInstance().saveData();
    }

    private static double getMiningXP(Block block) {
        if (block == Blocks.field_150348_b || block == Blocks.field_150347_e) {
            return 0.5;
        }
        if (block == Blocks.field_150365_q) {
            return 0.7;
        }
        if (block == Blocks.field_150366_p) {
            return 0.8;
        }
        if (block == Blocks.field_150352_o) {
            return 0.9;
        }
        if (block == Blocks.field_150482_ag) {
            return 1.0;
        }
        if (block == Blocks.field_150412_bA) {
            return 1.2;
        }
        if (block == Blocks.field_150343_Z) {
            return 1.5;
        }
        if (block == RegisterBlock.titane_ore) {
            return 2.5;
        }
        if (block == RegisterBlock.jade_ore) {
            return 2.0;
        }
        if (block == RegisterBlock.vartox_ore) {
            return 3.0;
        }
        return 0.0;
    }

    public static void removeBlockWithDrops(EntityPlayer player, ItemStack stack, World world, int x, int y, int z, int bx, int by, int bz, Block block, Material[] materialsListing, boolean smelt, int fortune, float blockHardness, boolean dispose, boolean obsidian) {
        ToolHandler.removeBlockWithDrops(player, stack, world, x, y, z, bx, by, bz, block, materialsListing, smelt, fortune, blockHardness, dispose, true, obsidian);
    }

    public static void removeBlockWithDrops(EntityPlayer player, ItemStack stack, World world, int x, int y, int z, int bx, int by, int bz, Block block, Material[] materialsListing, boolean smelt, int fortune, float blockHardness, boolean dispose, boolean particles, boolean obsidian) {
        if (world.func_72899_e(x, y, z)) {
            Block blk = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (block == null || blk == block) {
                Material mat = world.func_147439_a(x, y, z).func_149688_o();
                boolean flag = false;
                if (!world.field_72995_K && blk != null && !blk.isAir((IBlockAccess)world, x, y, z) && blk.func_149737_a(player, world, x, y, z) > 0.0f) {
                    int localMeta;
                    if (!blk.canHarvestBlock(player, meta) || !ToolHandler.isRightMaterial(blk, materialsListing) || blk == Blocks.field_150343_Z && !obsidian) {
                        return;
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        localMeta = world.func_72805_g(x, y, z);
                        blk.func_149681_a(world, x, y, z, localMeta, player);
                        if (blk.removedByPlayer(world, player, x, y, z, true)) {
                            blk.func_149664_b(world, x, y, z, localMeta);
                        }
                        if (smelt) {
                            ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)blk.getDrops(world, x, y, z, blk.func_149643_k(world, x, y, z), fortune).get(0));
                            if (result == null) {
                                blk.func_149697_b(world, x, y, z, localMeta, fortune);
                            } else {
                                flag = true;
                                ItemStack resultCopy = result.func_77946_l();
                                float count = 1.0f;
                                if (fortune > 0 && ToolHandler.isMineral(block)) {
                                    count = 1 + (fortune - world.field_73012_v.nextInt(fortune)) / 2;
                                }
                                if (count <= 0.0f) {
                                    count = 1.0f;
                                }
                                resultCopy.field_77994_a = (int)count;
                                EntityItem entityItem = new EntityItem(world, (double)x, (double)y, (double)z, resultCopy);
                                world.func_72838_d((Entity)entityItem);
                            }
                        } else {
                            blk.func_149697_b(world, x, y, z, localMeta, fortune);
                        }
                    } else {
                        localMeta = world.func_72805_g(x, y, z);
                        blk.func_149697_b(world, x, y, z, localMeta, fortune);
                    }
                    localMeta = blk.getExpDrop((IBlockAccess)world, blk.func_149643_k(world, x, y, z), fortune);
                    EntityXPOrb xp = new EntityXPOrb(world, (double)x, (double)y, (double)z, localMeta);
                    if (localMeta > 0) {
                        world.func_72838_d((Entity)xp);
                    }
                } else {
                    world.func_147468_f(x, y, z);
                }
                world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)blk) + (meta << 12));
                world.func_147468_f(x, y, z);
                if (flag) {
                    world.func_72869_a("flame", (double)x + 0.5 + 0.5 * world.field_73012_v.nextDouble(), (double)y - 0.1, (double)z + 0.5 * world.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)x + 0.5 + 0.5 * world.field_73012_v.nextDouble(), (double)y - 0.1, (double)z + 0.5 * world.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
                    world.func_72869_a("smoke", (double)x + 0.5 + 0.5 * world.field_73012_v.nextDouble(), (double)y - 0.1, (double)z + 0.5 * world.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static boolean isMineral(Block block) {
        for (Block b : minerals) {
            if (b != block) continue;
            return true;
        }
        return false;
    }

    public static boolean isRightMaterial(Block block, Material[] materialsListing) {
        Material material = block.func_149688_o();
        Material[] var3 = materialsListing;
        int var4 = materialsListing.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            Material mat = var3[var5];
            if (material != mat) continue;
            return true;
        }
        return false;
    }

    public static boolean isRightBlock(Block block, Block[] list) {
        Block[] var2 = list;
        int var3 = list.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            Block blk = var2[var4];
            if (block != blk) continue;
            return false;
        }
        return true;
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += (double)((EntityPlayer)player).eyeHeight;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        Vec3 vec31 = vec3.func_72441_c((double)f7 * range, (double)f6 * range, (double)f8 * range);
        return world.func_72901_a(vec3, vec31, par3);
    }
}

