/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.ariane;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.vartax.module.ariane.result.ScanResult;
import fr.vartax.module.ariane.result.zone.SuspectZone;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;

public class ScanManager {
    public static ScanResult scan(String name) throws Exception {
        ScanResult result = new ScanResult();
        File dir = new File("config/scanmap");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (WorldServer world : DimensionManager.getWorlds()) {
            int dim = world.field_73011_w.field_76574_g;
            HashMap grouped = new HashMap();
            for (Object o : world.field_73059_b.field_73245_g) {
                Chunk chunk = (Chunk)o;
                for (TileEntity te : chunk.field_150816_i.values()) {
                    String type = te.getClass().getSimpleName();
                    result.count(type);
                    if (!grouped.containsKey(type)) {
                        grouped.put(type, new ArrayList());
                    }
                    ((List)grouped.get(type)).add(te);
                }
            }
            for (List list : grouped.values()) {
                for (TileEntity base : list) {
                    int chests = 0;
                    int spawners = 0;
                    int hoppers = 0;
                    int total = 0;
                    for (TileEntity other : list) {
                        if (Math.abs(base.field_145851_c - other.field_145851_c) > 8 || Math.abs(base.field_145848_d - other.field_145848_d) > 8 || Math.abs(base.field_145849_e - other.field_145849_e) > 8) continue;
                        ++total;
                        if (other instanceof TileEntityChest) {
                            ++chests;
                        }
                        if (other instanceof TileEntityMobSpawner) {
                            ++spawners;
                        }
                        if (!(other instanceof TileEntityHopper)) continue;
                        ++hoppers;
                    }
                    if (chests < 6 && spawners < 2 && hoppers < 5 && total < 12) continue;
                    result.suspectZones.add(new SuspectZone(dim, base.field_145851_c, base.field_145848_d, base.field_145849_e, chests, spawners, hoppers, total));
                }
            }
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileWriter writer = new FileWriter(new File(dir, name + ".json"));
        gson.toJson((Object)result, (Appendable)writer);
        writer.close();
        return result;
    }
}

