/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.border;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import fr.vartax.module.border.command.CommandWorldBorder;
import fr.vartax.module.border.config.WorldBorderConfig;
import fr.vartax.module.border.event.WorldBorderEventHandler;
import fr.vartax.module.border.network.PacketBorderFog;
import fr.vartax.module.border.render.WorldBorderFogRenderer;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;

public class WorldBorderModule {
    private static WorldBorderModule instance;
    private WorldBorderConfig config;
    private WorldBorderEventHandler eventHandler;
    private WorldBorderFogRenderer fogRenderer;
    public static SimpleNetworkWrapper network;

    public WorldBorderModule() {
        instance = this;
    }

    public static WorldBorderModule getInstance() {
        return instance;
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.config = new WorldBorderConfig(event.getModConfigurationDirectory());
        System.out.println("[WorldBorder] Configuration charg\u00e9e");
        network = NetworkRegistry.INSTANCE.newSimpleChannel("WorldBorder");
        network.registerMessage(PacketBorderFog.Handler.class, PacketBorderFog.class, 0, Side.CLIENT);
    }

    public void init(FMLInitializationEvent event) {
        this.eventHandler = new WorldBorderEventHandler(this.config);
        MinecraftForge.EVENT_BUS.register((Object)this.eventHandler);
        FMLCommonHandler.instance().bus().register((Object)this.eventHandler);
        if (event.getSide().isClient()) {
            this.fogRenderer = new WorldBorderFogRenderer();
            MinecraftForge.EVENT_BUS.register((Object)this.fogRenderer);
            System.out.println("[WorldBorder] Fog renderer enregistr\u00e9 (CLIENT)");
        }
        System.out.println("[WorldBorder] \u00c9v\u00e9nements enregistr\u00e9s sur les deux bus (Forge + FML)");
    }

    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandWorldBorder(this.config));
        System.out.println("[WorldBorder] Commandes enregistr\u00e9es");
    }

    public WorldBorderConfig getConfig() {
        return this.config;
    }

    public WorldBorderFogRenderer getFogRenderer() {
        return this.fogRenderer;
    }
}

