/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.border.command;

import fr.vartax.module.border.config.WorldBorderConfig;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CommandWorldBorder
extends CommandBase {
    private WorldBorderConfig config;

    public CommandWorldBorder(WorldBorderConfig config) {
        this.config = config;
    }

    public String func_71517_b() {
        return "border";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/border <on|off|set|edit|delete|info|help|test>";
    }

    public int func_82362_a() {
        return 2;
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandWorldBorder.func_71530_a((String[])args, (String[])new String[]{"on", "off", "set", "edit", "delete", "info", "help", "test"});
        }
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.showHelp(sender);
            return;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "on": {
                if (!this.config.isConfigured()) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "\u2718 Vous devez d'abord configurer la bordure avec /border set <largeur> <longueur>"));
                    return;
                }
                this.config.setEnabled(true);
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "\u2713 World border activ\u00e9e!"));
                break;
            }
            case "off": {
                this.config.setEnabled(false);
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "\u2713 World border d\u00e9sactiv\u00e9e!"));
                break;
            }
            case "set": {
                if (!(sender instanceof EntityPlayer)) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "\u2718 Cette commande doit \u00eatre ex\u00e9cut\u00e9e par un joueur!"));
                    return;
                }
                if (args.length < 3) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Usage: /border set <largeur> <longueur>"));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + "Exemple: /border set 2000 2000 (zone de 2000x2000 blocs)"));
                    return;
                }
                try {
                    int width = Integer.parseInt(args[1]);
                    int length = Integer.parseInt(args[2]);
                    if (width < 100 || width > 60000000 || length < 100 || length > 60000000) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Les dimensions doivent \u00eatre entre 100 et 60000000!"));
                        return;
                    }
                    EntityPlayer player = (EntityPlayer)sender;
                    int centerX = (int)player.field_70165_t;
                    int centerZ = (int)player.field_70161_v;
                    this.config.setCenterX(centerX);
                    this.config.setCenterZ(centerZ);
                    this.config.setBorderWidth(width);
                    this.config.setBorderLength(length);
                    this.config.setEnabled(true);
                    int minX = centerX - width / 2;
                    int maxX = centerX + width / 2;
                    int minZ = centerZ - length / 2;
                    int maxZ = centerZ + length / 2;
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "\u2713 World border configur\u00e9e!"));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Dimensions: " + EnumChatFormatting.WHITE + width + "x" + length + " blocs"));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Centre: " + EnumChatFormatting.WHITE + "X=" + centerX + " Z=" + centerZ));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Limites X: " + EnumChatFormatting.WHITE + minX + " \u00e0 " + maxX));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Limites Z: " + EnumChatFormatting.WHITE + minZ + " \u00e0 " + maxZ));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
                }
                catch (NumberFormatException e) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "\u2718 Dimensions invalides! Utilisez des nombres entiers."));
                }
                break;
            }
            case "edit": {
                if (!(sender instanceof EntityPlayer)) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "\u2718 Cette commande doit \u00eatre ex\u00e9cut\u00e9e par un joueur!"));
                    return;
                }
                if (!this.config.isConfigured()) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "\u2718 Aucune bordure n'est configur\u00e9e! Utilisez /border set d'abord."));
                    return;
                }
                if (args.length < 3) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Usage: /border edit <nouvelle_largeur> <nouvelle_longueur>"));
                    return;
                }
                try {
                    int newWidth = Integer.parseInt(args[1]);
                    int newLength = Integer.parseInt(args[2]);
                    if (newWidth < 100 || newWidth > 60000000 || newLength < 100 || newLength > 60000000) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Les dimensions doivent \u00eatre entre 100 et 60000000!"));
                        return;
                    }
                    int oldWidth = this.config.getBorderWidth();
                    int oldLength = this.config.getBorderLength();
                    this.config.setBorderWidth(newWidth);
                    this.config.setBorderLength(newLength);
                    String widthAction = newWidth > oldWidth ? "agrandie" : "r\u00e9duite";
                    String lengthAction = newLength > oldLength ? "agrandie" : "r\u00e9duite";
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "\u2713 World border modifi\u00e9e!"));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Largeur " + widthAction + ": " + EnumChatFormatting.WHITE + oldWidth + " \u2192 " + newWidth + " blocs"));
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Longueur " + lengthAction + ": " + EnumChatFormatting.WHITE + oldLength + " \u2192 " + newLength + " blocs"));
                }
                catch (NumberFormatException e) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "\u2718 Dimensions invalides!"));
                }
                break;
            }
            case "delete": {
                this.config.delete();
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "\u2713 World border supprim\u00e9e et d\u00e9sactiv\u00e9e!"));
                break;
            }
            case "info": {
                if (!this.config.isConfigured()) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "\u2718 Aucune bordure n'est configur\u00e9e!"));
                    return;
                }
                this.showInfo(sender);
                break;
            }
            case "test": {
                if (!(sender instanceof EntityPlayer)) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Cette commande doit \u00eatre ex\u00e9cut\u00e9e par un joueur!"));
                    return;
                }
                EntityPlayer player = (EntityPlayer)sender;
                double x = player.field_70165_t;
                double z = player.field_70161_v;
                boolean inside = this.config.isInsideBorder(x, z);
                double distance = this.config.getDistanceToBorder(x, z);
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "=== DEBUG WORLD BORDER ==="));
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Enabled: " + EnumChatFormatting.WHITE + this.config.isEnabled()));
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Configured: " + EnumChatFormatting.WHITE + this.config.isConfigured()));
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Votre position: " + EnumChatFormatting.WHITE + "X=" + (int)x + " Z=" + (int)z));
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Centre: " + EnumChatFormatting.WHITE + "X=" + this.config.getCenterX() + " Z=" + this.config.getCenterZ()));
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Dimensions: " + EnumChatFormatting.WHITE + this.config.getBorderWidth() + "x" + this.config.getBorderLength()));
                double halfWidth = (double)this.config.getBorderWidth() / 2.0;
                double halfLength = (double)this.config.getBorderLength() / 2.0;
                int minX = (int)((double)this.config.getCenterX() - halfWidth);
                int maxX = (int)((double)this.config.getCenterX() + halfWidth);
                int minZ = (int)((double)this.config.getCenterZ() - halfLength);
                int maxZ = (int)((double)this.config.getCenterZ() + halfLength);
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Limites X: " + EnumChatFormatting.WHITE + minX + " \u00e0 " + maxX));
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Limites Z: " + EnumChatFormatting.WHITE + minZ + " \u00e0 " + maxZ));
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Inside border: " + (inside ? EnumChatFormatting.GREEN + "OUI" : EnumChatFormatting.RED + "NON")));
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Distance to border: " + EnumChatFormatting.WHITE + (int)distance + " blocs"));
                break;
            }
            case "help": {
                this.showHelp(sender);
                break;
            }
            default: {
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "\u2718 Commande inconnue! Utilisez /border help"));
            }
        }
    }

    private void showInfo(ICommandSender sender) {
        int centerX = this.config.getCenterX();
        int centerZ = this.config.getCenterZ();
        int width = this.config.getBorderWidth();
        int length = this.config.getBorderLength();
        int minX = centerX - width / 2;
        int maxX = centerX + width / 2;
        int minZ = centerZ - length / 2;
        int maxZ = centerZ + length / 2;
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "========== World Border - Info =========="));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Statut: " + (this.config.isEnabled() ? EnumChatFormatting.GREEN + "ACTIVE" : EnumChatFormatting.RED + "INACTIVE")));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Dimensions: " + EnumChatFormatting.WHITE + width + "x" + length + " blocs"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Centre: " + EnumChatFormatting.WHITE + "X=" + centerX + " Z=" + centerZ));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Limites X: " + EnumChatFormatting.WHITE + minX + " \u00e0 " + maxX));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Limites Z: " + EnumChatFormatting.WHITE + minZ + " \u00e0 " + maxZ));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "========================================"));
    }

    private void showHelp(ICommandSender sender) {
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "========== World Border - Aide =========="));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "/border set <largeur> <longueur>" + EnumChatFormatting.WHITE + " - Cr\u00e9e une bordure centr\u00e9e sur vous"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + "  Exemple: /border set 2000 2000"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "/border on" + EnumChatFormatting.WHITE + " - Active la world border"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "/border off" + EnumChatFormatting.WHITE + " - D\u00e9sactive la world border"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "/border edit <largeur> <longueur>" + EnumChatFormatting.WHITE + " - Modifie les dimensions"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "/border delete" + EnumChatFormatting.WHITE + " - Supprime la world border"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "/border info" + EnumChatFormatting.WHITE + " - Affiche les informations"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "/border test" + EnumChatFormatting.WHITE + " - Mode debug (admin)"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "/border help" + EnumChatFormatting.WHITE + " - Affiche cette aide"));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "========================================"));
        if (this.config.isConfigured()) {
            if (this.config.isEnabled()) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Statut: ACTIVE - " + this.config.getBorderWidth() + "x" + this.config.getBorderLength() + " blocs"));
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Statut: INACTIVE (configur\u00e9e mais d\u00e9sactiv\u00e9e)"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Statut: NON CONFIGUR\u00c9E"));
        }
    }
}

