/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.border.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class WorldBorderConfig {
    private Configuration config;
    private File configFile;
    private boolean enabled = false;
    private boolean configured = false;
    private int borderWidth = 10000;
    private int borderLength = 10000;
    private int centerX = 0;
    private int centerZ = 0;
    private int warningDistance = 10;

    public WorldBorderConfig(File configDir) {
        this.configFile = new File(configDir, "worldborder.cfg");
        this.config = new Configuration(this.configFile);
        this.load();
    }

    public void load() {
        this.config.load();
        this.enabled = this.config.getBoolean("enabled", "general", false, "Active ou d\u00e9sactive la world border");
        this.configured = this.config.getBoolean("configured", "general", false, "Indique si la bordure a \u00e9t\u00e9 configur\u00e9e");
        this.borderWidth = this.config.getInt("borderWidth", "general", 10000, 100, 60000000, "Largeur de la bordure (axe X en blocs)");
        this.borderLength = this.config.getInt("borderLength", "general", 10000, 100, 60000000, "Longueur de la bordure (axe Z en blocs)");
        this.centerX = this.config.getInt("centerX", "general", 0, -30000000, 30000000, "Centre X de la bordure");
        this.centerZ = this.config.getInt("centerZ", "general", 0, -30000000, 30000000, "Centre Z de la bordure");
        this.warningDistance = this.config.getInt("warningDistance", "general", 10, 1, 100, "Distance d'avertissement avant la bordure");
        if (this.config.hasChanged()) {
            this.config.save();
        }
        System.out.println("[WorldBorder] Config charg\u00e9e: enabled=" + this.enabled + ", width=" + this.borderWidth + ", length=" + this.borderLength + ", centerX=" + this.centerX + ", centerZ=" + this.centerZ);
    }

    public void save() {
        this.config.get("general", "enabled", false).set(this.enabled);
        this.config.get("general", "configured", false).set(this.configured);
        this.config.get("general", "borderWidth", 10000).set(this.borderWidth);
        this.config.get("general", "borderLength", 10000).set(this.borderLength);
        this.config.get("general", "centerX", 0).set(this.centerX);
        this.config.get("general", "centerZ", 0).set(this.centerZ);
        this.config.get("general", "warningDistance", 10).set(this.warningDistance);
        this.config.save();
        System.out.println("[WorldBorder] Config sauvegard\u00e9e");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.save();
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
        this.configured = true;
        this.save();
    }

    public int getBorderLength() {
        return this.borderLength;
    }

    public void setBorderLength(int length) {
        this.borderLength = length;
        this.configured = true;
        this.save();
    }

    public int getCenterX() {
        return this.centerX;
    }

    public void setCenterX(int x) {
        this.centerX = x;
        this.save();
    }

    public int getCenterZ() {
        return this.centerZ;
    }

    public void setCenterZ(int z) {
        this.centerZ = z;
        this.save();
    }

    public int getWarningDistance() {
        return this.warningDistance;
    }

    public void delete() {
        this.enabled = false;
        this.configured = false;
        this.borderWidth = 10000;
        this.borderLength = 10000;
        this.centerX = 0;
        this.centerZ = 0;
        this.save();
    }

    public boolean isInsideBorder(double x, double z) {
        boolean inside;
        if (!this.configured) {
            return true;
        }
        double halfWidth = (double)this.borderWidth / 2.0;
        double halfLength = (double)this.borderLength / 2.0;
        double minX = (double)this.centerX - halfWidth;
        double maxX = (double)this.centerX + halfWidth;
        double minZ = (double)this.centerZ - halfLength;
        double maxZ = (double)this.centerZ + halfLength;
        boolean bl = inside = x >= minX && x <= maxX && z >= minZ && z <= maxZ;
        if (!inside) {
            System.out.println("[WorldBorder] Player OUTSIDE border! X=" + x + " Z=" + z + " | Limits: X[" + minX + "," + maxX + "] Z[" + minZ + "," + maxZ + "]");
        }
        return inside;
    }

    public double getDistanceToBorder(double x, double z) {
        if (!this.configured) {
            return Double.MAX_VALUE;
        }
        double halfWidth = (double)this.borderWidth / 2.0;
        double halfLength = (double)this.borderLength / 2.0;
        double minX = (double)this.centerX - halfWidth;
        double maxX = (double)this.centerX + halfWidth;
        double minZ = (double)this.centerZ - halfLength;
        double maxZ = (double)this.centerZ + halfLength;
        double distanceToWestBorder = Math.abs(x - minX);
        double distanceToEastBorder = Math.abs(x - maxX);
        double distanceToNorthBorder = Math.abs(z - minZ);
        double distanceToSouthBorder = Math.abs(z - maxZ);
        double closestDistance = Math.min(Math.min(distanceToWestBorder, distanceToEastBorder), Math.min(distanceToNorthBorder, distanceToSouthBorder));
        return closestDistance;
    }
}

