/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.border.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fr.vartax.module.border.WorldBorderModule;
import fr.vartax.module.border.config.WorldBorderConfig;
import fr.vartax.module.border.network.PacketBorderFog;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class WorldBorderEventHandler {
    private WorldBorderConfig config;
    private HashMap<UUID, Long> lastWarningTime = new HashMap();
    private HashMap<UUID, Boolean> wasInsideBorder = new HashMap();
    private HashMap<UUID, Long> lastDebugLog = new HashMap();
    private HashMap<UUID, Integer> tickCounter = new HashMap();

    public WorldBorderEventHandler(WorldBorderConfig config) {
        this.config = config;
        System.out.println("[WorldBorder] Event handler cr\u00e9\u00e9 avec config: enabled=" + config.isEnabled() + ", configured=" + config.isConfigured());
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!this.config.isEnabled()) {
            return;
        }
        if (!this.config.isConfigured()) {
            return;
        }
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.player;
        UUID uuid = player.func_110124_au();
        Integer ticks = this.tickCounter.get(uuid);
        if (ticks == null) {
            ticks = 0;
        }
        Integer n = ticks;
        Integer n2 = ticks = Integer.valueOf(ticks + 1);
        this.tickCounter.put(uuid, ticks);
        if (ticks % 10 != 0) {
            return;
        }
        double x = player.field_70165_t;
        double z = player.field_70161_v;
        boolean isInside = this.config.isInsideBorder(x, z);
        double distanceToBorder = this.config.getDistanceToBorder(x, z);
        Boolean wasInside = this.wasInsideBorder.get(uuid);
        if (wasInside == null) {
            wasInside = true;
        }
        if (!isInside) {
            double halfWidth = (double)this.config.getBorderWidth() / 2.0;
            double halfLength = (double)this.config.getBorderLength() / 2.0;
            double minX = (double)this.config.getCenterX() - halfWidth;
            double maxX = (double)this.config.getCenterX() + halfWidth;
            double minZ = (double)this.config.getCenterZ() - halfLength;
            double maxZ = (double)this.config.getCenterZ() + halfLength;
            double newX = x;
            double newZ = z;
            if (x < minX) {
                newX = minX + 1.0;
            }
            if (x > maxX) {
                newX = maxX - 1.0;
            }
            if (z < minZ) {
                newZ = minZ + 1.0;
            }
            if (z > maxZ) {
                newZ = maxZ - 1.0;
            }
            player.func_70634_a(newX, player.field_70163_u, newZ);
            player.func_70097_a(DamageSource.field_76376_m, 2.0f);
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "\u26a0 Vous \u00eates hors de la world border! Vous subissez des d\u00e9g\u00e2ts!"));
            if (player instanceof EntityPlayerMP) {
                WorldBorderModule.network.sendTo((IMessage)new PacketBorderFog(0.3f), (EntityPlayerMP)player);
            }
        } else if (distanceToBorder <= (double)this.config.getWarningDistance() && distanceToBorder > 0.0) {
            Long lastWarning = this.lastWarningTime.get(uuid);
            long currentTime = System.currentTimeMillis();
            if (lastWarning == null || currentTime - lastWarning > 3000L) {
                int blocksLeft = (int)distanceToBorder;
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "\u26a0 Attention! Vous approchez de la world border! " + EnumChatFormatting.RED + blocksLeft + " blocs restants"));
                this.lastWarningTime.put(uuid, currentTime);
            }
            float fogIntensity = 1.0f - (float)distanceToBorder / (float)this.config.getWarningDistance();
            fogIntensity = Math.max(0.0f, Math.min(0.2f, fogIntensity * 0.2f));
            if (player instanceof EntityPlayerMP) {
                WorldBorderModule.network.sendTo((IMessage)new PacketBorderFog(fogIntensity), (EntityPlayerMP)player);
            }
            if (player.field_70170_p.field_73012_v.nextInt(5) == 0) {
                for (int i = 0; i < 10; ++i) {
                    double particleX = x + (player.field_70170_p.field_73012_v.nextDouble() - 0.5) * 3.0;
                    double particleY = player.field_70163_u + player.field_70170_p.field_73012_v.nextDouble() * 2.5;
                    double particleZ = z + (player.field_70170_p.field_73012_v.nextDouble() - 0.5) * 3.0;
                    player.field_70170_p.func_72869_a("happyVillager", particleX, particleY, particleZ, 0.0, 0.0, 0.0);
                    player.field_70170_p.func_72869_a("portal", particleX, particleY, particleZ, 0.0, 0.5, 0.0);
                }
            }
        } else if (player instanceof EntityPlayerMP) {
            WorldBorderModule.network.sendTo((IMessage)new PacketBorderFog(0.0f), (EntityPlayerMP)player);
        }
        this.wasInsideBorder.put(uuid, isInside);
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (!this.config.isEnabled()) {
            return;
        }
        EntityPlayer player = event.player;
        if (player == null) {
            return;
        }
        double x = (double)event.x + 0.5;
        double z = (double)event.z + 0.5;
        if (!this.config.isInsideBorder(x, z)) {
            event.setCanceled(true);
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "\u2718 Vous ne pouvez pas placer de blocs hors de la world border!"));
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!this.config.isEnabled()) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        if (player == null) {
            return;
        }
        double x = (double)event.x + 0.5;
        double z = (double)event.z + 0.5;
        if (!this.config.isInsideBorder(x, z)) {
            event.setCanceled(true);
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "\u2718 Vous ne pouvez pas casser de blocs hors de la world border!"));
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.config.isEnabled()) {
            return;
        }
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        double x = (double)event.x + 0.5;
        double z = (double)event.z + 0.5;
        if (!this.config.isInsideBorder(x, z)) {
            event.setCanceled(true);
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "\u2718 Vous ne pouvez pas interagir avec des blocs hors de la world border!"));
        }
    }
}

