/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.border.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class WorldBorderFogRenderer {
    private float fogDensity = 0.0f;
    private float targetFogDensity = 0.0f;

    @SubscribeEvent
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (this.fogDensity < this.targetFogDensity) {
            this.fogDensity += 0.01f;
            if (this.fogDensity > this.targetFogDensity) {
                this.fogDensity = this.targetFogDensity;
            }
        } else if (this.fogDensity > this.targetFogDensity) {
            this.fogDensity -= 0.01f;
            if (this.fogDensity < this.targetFogDensity) {
                this.fogDensity = this.targetFogDensity;
            }
        }
        if (this.fogDensity > 0.0f) {
            GL11.glFogi((int)2917, (int)2049);
            GL11.glFogf((int)2914, (float)this.fogDensity);
            event.density = this.fogDensity;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onFogColors(EntityViewRenderEvent.FogColors event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (this.fogDensity > 0.0f) {
            float intensity = this.fogDensity * 2.0f;
            event.red = 0.0f + event.red * (1.0f - intensity);
            event.green = 0.4f + event.green * (1.0f - intensity);
            event.blue = 0.0f + event.blue * (1.0f - intensity);
        }
    }

    public void setFogIntensity(float intensity) {
        this.targetFogDensity = Math.max(0.0f, Math.min(0.3f, intensity));
    }

    public void clearFog() {
        this.targetFogDensity = 0.0f;
    }
}

