/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.hud;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import fr.vartax.module.hud.config.HUDConfig;
import fr.vartax.module.hud.event.HUDElement;
import fr.vartax.module.hud.module.ArmorHUD;
import fr.vartax.module.hud.module.CPSHUD;
import fr.vartax.module.hud.module.FPSHUD;
import fr.vartax.module.hud.module.KeystrokeHUD;
import fr.vartax.module.hud.module.PingHUD;
import fr.vartax.module.hud.module.PotionHUD;
import fr.vartax.module.hud.module.ToggleSprintHUD;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;

public class HUDMod {
    private static HUDMod instance;
    private Minecraft mc;
    private HUDConfig config;
    private PotionHUD potionHUD;
    private ArmorHUD armorHUD;
    private KeystrokeHUD keystrokeHUD;
    private ToggleSprintHUD toggleSprintHUD;
    private CPSHUD cpsHUD;
    private FPSHUD fpsHUD;
    private PingHUD pingHUD;

    public HUDMod() {
        instance = this;
        this.mc = Minecraft.func_71410_x();
        this.config = new HUDConfig();
        System.out.println("[HUDMod] Initializing HUD modules...");
        this.potionHUD = new PotionHUD(this.config);
        System.out.println("[HUDMod] Potion HUD initialized: " + this.config.isPotionHUDEnabled());
        this.armorHUD = new ArmorHUD(this.config);
        System.out.println("[HUDMod] Armor HUD initialized: " + this.config.isArmorHUDEnabled());
        this.keystrokeHUD = new KeystrokeHUD(this.config);
        System.out.println("[HUDMod] Keystroke HUD initialized: " + this.config.isKeystrokeHUDEnabled());
        this.toggleSprintHUD = new ToggleSprintHUD(this.config);
        System.out.println("[HUDMod] Toggle Sprint HUD initialized: " + this.config.isToggleSprintHUDEnabled());
        this.cpsHUD = new CPSHUD(this.config);
        System.out.println("[HUDMod] CPS HUD initialized: " + this.config.isCPSHUDEnabled());
        this.fpsHUD = new FPSHUD(this.config);
        System.out.println("[HUDMod] FPS HUD initialized: " + this.config.isFPSHUDEnabled());
        this.pingHUD = new PingHUD(this.config);
        System.out.println("[HUDMod] Ping HUD initialized: " + this.config.isPingHUDEnabled());
        System.out.println("[HUDMod] All HUD modules initialized successfully!");
        MinecraftForge.EVENT_BUS.register((Object)this);
        System.out.println("[HUDMod] Event handler registered!");
    }

    public static HUDMod getInstance() {
        return instance;
    }

    public HUDConfig getConfig() {
        return this.config;
    }

    public CPSHUD getCPSHUD() {
        return this.cpsHUD;
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        boolean anyRendered = false;
        if (this.config.isPotionHUDEnabled()) {
            this.potionHUD.render(sr);
            anyRendered = true;
        }
        if (this.config.isArmorHUDEnabled()) {
            this.armorHUD.render(sr);
            anyRendered = true;
        }
        if (this.config.isKeystrokeHUDEnabled()) {
            this.keystrokeHUD.render(sr);
            anyRendered = true;
        }
        if (this.config.isToggleSprintHUDEnabled()) {
            try {
                this.toggleSprintHUD.render(sr);
                anyRendered = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.config.isCPSHUDEnabled()) {
            try {
                this.cpsHUD.render(sr);
                anyRendered = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.config.isFPSHUDEnabled()) {
            try {
                this.fpsHUD.render(sr);
                anyRendered = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.config.isPingHUDEnabled()) {
            try {
                this.pingHUD.render(sr);
                anyRendered = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (anyRendered) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onMouseClick(MouseEvent event) {
        if (event.button == 0 && event.buttonstate) {
            this.cpsHUD.onLeftClick();
        } else if (event.button == 1 && event.buttonstate) {
            this.cpsHUD.onRightClick();
        }
    }

    public List<HUDElement> getAllElements() {
        ArrayList<HUDElement> elements = new ArrayList<HUDElement>();
        elements.add(this.potionHUD);
        elements.add(this.armorHUD);
        elements.add(this.keystrokeHUD);
        elements.add(this.toggleSprintHUD);
        elements.add(this.cpsHUD);
        elements.add(this.fpsHUD);
        elements.add(this.pingHUD);
        return elements;
    }

    public void reloadElements() {
        this.potionHUD.setX(this.config.getPotionX());
        this.potionHUD.setY(this.config.getPotionY());
        this.potionHUD.setScale(this.config.getPotionScale());
        this.armorHUD.setX(this.config.getArmorX());
        this.armorHUD.setY(this.config.getArmorY());
        this.armorHUD.setScale(this.config.getArmorScale());
        this.keystrokeHUD.setX(this.config.getKeystrokeX());
        this.keystrokeHUD.setY(this.config.getKeystrokeY());
        this.keystrokeHUD.setScale(this.config.getKeystrokeScale());
        this.toggleSprintHUD.setX(this.config.getToggleSprintX());
        this.toggleSprintHUD.setY(this.config.getToggleSprintY());
        this.toggleSprintHUD.setScale(this.config.getToggleSprintScale());
        this.cpsHUD.setX(this.config.getCPSX());
        this.cpsHUD.setY(this.config.getCPSY());
        this.cpsHUD.setScale(this.config.getCPSScale());
        this.fpsHUD.setX(this.config.getFPSX());
        this.fpsHUD.setY(this.config.getFPSY());
        this.fpsHUD.setScale(this.config.getFPSScale());
        this.pingHUD.setX(this.config.getPingX());
        this.pingHUD.setY(this.config.getPingY());
        this.pingHUD.setScale(this.config.getPingScale());
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)color);
    }
}

