/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.hud.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class HUDConfig {
    private Configuration config;
    private static final String CATEGORY_POTION = "potion_hud";
    private static final String CATEGORY_ARMOR = "armor_hud";
    private static final String CATEGORY_KEYSTROKE = "keystroke_hud";
    private static final String CATEGORY_TOGGLE_SPRINT = "toggle_sprint_hud";
    private static final String CATEGORY_CPS = "cps_hud";
    private static final String CATEGORY_FPS = "fps_hud";
    private static final String CATEGORY_PING = "ping_hud";
    private boolean potionHUDEnabled;
    private int potionX;
    private int potionY;
    private float potionScale;
    private boolean armorHUDEnabled;
    private int armorX;
    private int armorY;
    private float armorScale;
    private boolean armorHelmetEnabled;
    private boolean armorChestplateEnabled;
    private boolean armorLeggingsEnabled;
    private boolean armorBootsEnabled;
    private boolean heldItemEnabled;
    private boolean keystrokeHUDEnabled;
    private int keystrokeX;
    private int keystrokeY;
    private float keystrokeScale;
    private boolean toggleSprintHUDEnabled;
    private int toggleSprintX;
    private int toggleSprintY;
    private float toggleSprintScale;
    private boolean toggleSprintAlwaysShow;
    private boolean toggleSneakAlwaysShow;
    private boolean cpsHUDEnabled;
    private int cpsX;
    private int cpsY;
    private float cpsScale;
    private boolean cpsShowBoth;
    private boolean fpsHUDEnabled;
    private int fpsX;
    private int fpsY;
    private float fpsScale;
    private boolean pingHUDEnabled;
    private int pingX;
    private int pingY;
    private float pingScale;

    public HUDConfig() {
        File configDir = new File("config");
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        File configFile = new File(configDir, "hudmod.cfg");
        this.config = new Configuration(configFile);
        this.loadConfig();
    }

    public void loadConfig() {
        try {
            this.config.load();
            this.potionHUDEnabled = this.config.getBoolean("enabled", CATEGORY_POTION, true, "Enable Potion HUD");
            this.potionX = this.config.getInt("x", CATEGORY_POTION, 10, 0, 10000, "X Position");
            this.potionY = this.config.getInt("y", CATEGORY_POTION, 10, 0, 10000, "Y Position");
            this.potionScale = this.config.getFloat("scale", CATEGORY_POTION, 1.0f, 0.5f, 3.0f, "Scale");
            this.armorHUDEnabled = this.config.getBoolean("enabled", CATEGORY_ARMOR, true, "Enable Armor HUD");
            this.armorX = this.config.getInt("x", CATEGORY_ARMOR, 10, 0, 10000, "X Position");
            this.armorY = this.config.getInt("y", CATEGORY_ARMOR, 50, 0, 10000, "Y Position");
            this.armorScale = this.config.getFloat("scale", CATEGORY_ARMOR, 1.0f, 0.5f, 3.0f, "Scale");
            this.armorHelmetEnabled = this.config.getBoolean("helmet", CATEGORY_ARMOR, true, "Show Helmet");
            this.armorChestplateEnabled = this.config.getBoolean("chestplate", CATEGORY_ARMOR, true, "Show Chestplate");
            this.armorLeggingsEnabled = this.config.getBoolean("leggings", CATEGORY_ARMOR, true, "Show Leggings");
            this.armorBootsEnabled = this.config.getBoolean("boots", CATEGORY_ARMOR, true, "Show Boots");
            this.heldItemEnabled = this.config.getBoolean("held_item", CATEGORY_ARMOR, true, "Show Held Item");
            this.keystrokeHUDEnabled = this.config.getBoolean("enabled", CATEGORY_KEYSTROKE, true, "Enable Keystroke HUD");
            this.keystrokeX = this.config.getInt("x", CATEGORY_KEYSTROKE, 10, 0, 10000, "X Position");
            this.keystrokeY = this.config.getInt("y", CATEGORY_KEYSTROKE, 130, 0, 10000, "Y Position");
            this.keystrokeScale = this.config.getFloat("scale", CATEGORY_KEYSTROKE, 1.0f, 0.5f, 3.0f, "Scale");
            this.toggleSprintHUDEnabled = this.config.getBoolean("enabled", CATEGORY_TOGGLE_SPRINT, true, "Enable Toggle Sprint HUD");
            this.toggleSprintX = this.config.getInt("x", CATEGORY_TOGGLE_SPRINT, 10, 0, 10000, "X Position");
            this.toggleSprintY = this.config.getInt("y", CATEGORY_TOGGLE_SPRINT, 250, 0, 10000, "Y Position");
            this.toggleSprintScale = this.config.getFloat("scale", CATEGORY_TOGGLE_SPRINT, 1.0f, 0.5f, 3.0f, "Scale");
            this.toggleSprintAlwaysShow = this.config.getBoolean("always_show_sprint", CATEGORY_TOGGLE_SPRINT, false, "Always Show Sprint");
            this.toggleSneakAlwaysShow = this.config.getBoolean("always_show_sneak", CATEGORY_TOGGLE_SPRINT, false, "Always Show Sneak");
            this.cpsHUDEnabled = this.config.getBoolean("enabled", CATEGORY_CPS, true, "Enable CPS HUD");
            this.cpsX = this.config.getInt("x", CATEGORY_CPS, 10, 0, 10000, "X Position");
            this.cpsY = this.config.getInt("y", CATEGORY_CPS, 290, 0, 10000, "Y Position");
            this.cpsScale = this.config.getFloat("scale", CATEGORY_CPS, 1.0f, 0.5f, 3.0f, "Scale");
            this.cpsShowBoth = this.config.getBoolean("show_both", CATEGORY_CPS, true, "Show LMB and RMB separately");
            this.fpsHUDEnabled = this.config.getBoolean("enabled", CATEGORY_FPS, true, "Enable FPS HUD");
            this.fpsX = this.config.getInt("x", CATEGORY_FPS, 10, 0, 10000, "X Position");
            this.fpsY = this.config.getInt("y", CATEGORY_FPS, 320, 0, 10000, "Y Position");
            this.fpsScale = this.config.getFloat("scale", CATEGORY_FPS, 1.0f, 0.5f, 3.0f, "Scale");
            this.pingHUDEnabled = this.config.getBoolean("enabled", CATEGORY_PING, true, "Enable Ping HUD");
            this.pingX = this.config.getInt("x", CATEGORY_PING, 10, 0, 10000, "X Position");
            this.pingY = this.config.getInt("y", CATEGORY_PING, 350, 0, 10000, "Y Position");
            this.pingScale = this.config.getFloat("scale", CATEGORY_PING, 1.0f, 0.5f, 3.0f, "Scale");
        }
        catch (Exception e) {
            System.err.println("Error loading HUD config: " + e.getMessage());
        }
        finally {
            if (this.config.hasChanged()) {
                this.config.save();
            }
        }
    }

    public void saveConfig() {
        try {
            Property propPotionEnabled = this.config.get(CATEGORY_POTION, "enabled", true);
            propPotionEnabled.set(this.potionHUDEnabled);
            Property propPotionX = this.config.get(CATEGORY_POTION, "x", 10);
            propPotionX.set(this.potionX);
            Property propPotionY = this.config.get(CATEGORY_POTION, "y", 10);
            propPotionY.set(this.potionY);
            Property propPotionScale = this.config.get(CATEGORY_POTION, "scale", 1.0);
            propPotionScale.set((double)this.potionScale);
            Property propArmorEnabled = this.config.get(CATEGORY_ARMOR, "enabled", true);
            propArmorEnabled.set(this.armorHUDEnabled);
            Property propArmorX = this.config.get(CATEGORY_ARMOR, "x", 10);
            propArmorX.set(this.armorX);
            Property propArmorY = this.config.get(CATEGORY_ARMOR, "y", 50);
            propArmorY.set(this.armorY);
            Property propArmorScale = this.config.get(CATEGORY_ARMOR, "scale", 1.0);
            propArmorScale.set((double)this.armorScale);
            Property propArmorHelmet = this.config.get(CATEGORY_ARMOR, "helmet", true);
            propArmorHelmet.set(this.armorHelmetEnabled);
            Property propArmorChestplate = this.config.get(CATEGORY_ARMOR, "chestplate", true);
            propArmorChestplate.set(this.armorChestplateEnabled);
            Property propArmorLeggings = this.config.get(CATEGORY_ARMOR, "leggings", true);
            propArmorLeggings.set(this.armorLeggingsEnabled);
            Property propArmorBoots = this.config.get(CATEGORY_ARMOR, "boots", true);
            propArmorBoots.set(this.armorBootsEnabled);
            Property propHeldItem = this.config.get(CATEGORY_ARMOR, "held_item", true);
            propHeldItem.set(this.heldItemEnabled);
            Property propKeystrokeEnabled = this.config.get(CATEGORY_KEYSTROKE, "enabled", true);
            propKeystrokeEnabled.set(this.keystrokeHUDEnabled);
            Property propKeystrokeX = this.config.get(CATEGORY_KEYSTROKE, "x", 10);
            propKeystrokeX.set(this.keystrokeX);
            Property propKeystrokeY = this.config.get(CATEGORY_KEYSTROKE, "y", 130);
            propKeystrokeY.set(this.keystrokeY);
            Property propKeystrokeScale = this.config.get(CATEGORY_KEYSTROKE, "scale", 1.0);
            propKeystrokeScale.set((double)this.keystrokeScale);
            Property propToggleSprintEnabled = this.config.get(CATEGORY_TOGGLE_SPRINT, "enabled", true);
            propToggleSprintEnabled.set(this.toggleSprintHUDEnabled);
            Property propToggleSprintX = this.config.get(CATEGORY_TOGGLE_SPRINT, "x", 10);
            propToggleSprintX.set(this.toggleSprintX);
            Property propToggleSprintY = this.config.get(CATEGORY_TOGGLE_SPRINT, "y", 250);
            propToggleSprintY.set(this.toggleSprintY);
            Property propToggleSprintScale = this.config.get(CATEGORY_TOGGLE_SPRINT, "scale", 1.0);
            propToggleSprintScale.set((double)this.toggleSprintScale);
            Property propToggleSprintAlwaysShow = this.config.get(CATEGORY_TOGGLE_SPRINT, "always_show_sprint", false);
            propToggleSprintAlwaysShow.set(this.toggleSprintAlwaysShow);
            Property propToggleSneakAlwaysShow = this.config.get(CATEGORY_TOGGLE_SPRINT, "always_show_sneak", false);
            propToggleSneakAlwaysShow.set(this.toggleSneakAlwaysShow);
            Property propCPSEnabled = this.config.get(CATEGORY_CPS, "enabled", true);
            propCPSEnabled.set(this.cpsHUDEnabled);
            Property propCPSX = this.config.get(CATEGORY_CPS, "x", 10);
            propCPSX.set(this.cpsX);
            Property propCPSY = this.config.get(CATEGORY_CPS, "y", 290);
            propCPSY.set(this.cpsY);
            Property propCPSScale = this.config.get(CATEGORY_CPS, "scale", 1.0);
            propCPSScale.set((double)this.cpsScale);
            Property propCPSShowBoth = this.config.get(CATEGORY_CPS, "show_both", true);
            propCPSShowBoth.set(this.cpsShowBoth);
            Property propFPSEnabled = this.config.get(CATEGORY_FPS, "enabled", true);
            propFPSEnabled.set(this.fpsHUDEnabled);
            Property propFPSX = this.config.get(CATEGORY_FPS, "x", 10);
            propFPSX.set(this.fpsX);
            Property propFPSY = this.config.get(CATEGORY_FPS, "y", 320);
            propFPSY.set(this.fpsY);
            Property propFPSScale = this.config.get(CATEGORY_FPS, "scale", 1.0);
            propFPSScale.set((double)this.fpsScale);
            Property propPingEnabled = this.config.get(CATEGORY_PING, "enabled", true);
            propPingEnabled.set(this.pingHUDEnabled);
            Property propPingX = this.config.get(CATEGORY_PING, "x", 10);
            propPingX.set(this.pingX);
            Property propPingY = this.config.get(CATEGORY_PING, "y", 350);
            propPingY.set(this.pingY);
            Property propPingScale = this.config.get(CATEGORY_PING, "scale", 1.0);
            propPingScale.set((double)this.pingScale);
            this.config.save();
        }
        catch (Exception e) {
            System.err.println("Error saving HUD config: " + e.getMessage());
        }
    }

    public boolean isPotionHUDEnabled() {
        return this.potionHUDEnabled;
    }

    public void setPotionHUDEnabled(boolean enabled) {
        this.potionHUDEnabled = enabled;
        this.saveConfig();
    }

    public int getPotionX() {
        return this.potionX;
    }

    public int getPotionY() {
        return this.potionY;
    }

    public void setPotionPosition(int x, int y) {
        this.potionX = x;
        this.potionY = y;
    }

    public float getPotionScale() {
        return this.potionScale;
    }

    public void setPotionScale(float scale) {
        this.potionScale = scale;
    }

    public boolean isArmorHUDEnabled() {
        return this.armorHUDEnabled;
    }

    public void setArmorHUDEnabled(boolean enabled) {
        this.armorHUDEnabled = enabled;
        this.saveConfig();
    }

    public int getArmorX() {
        return this.armorX;
    }

    public int getArmorY() {
        return this.armorY;
    }

    public void setArmorPosition(int x, int y) {
        this.armorX = x;
        this.armorY = y;
    }

    public float getArmorScale() {
        return this.armorScale;
    }

    public void setArmorScale(float scale) {
        this.armorScale = scale;
    }

    public boolean isKeystrokeHUDEnabled() {
        return this.keystrokeHUDEnabled;
    }

    public void setKeystrokeHUDEnabled(boolean enabled) {
        this.keystrokeHUDEnabled = enabled;
        this.saveConfig();
    }

    public int getKeystrokeX() {
        return this.keystrokeX;
    }

    public int getKeystrokeY() {
        return this.keystrokeY;
    }

    public void setKeystrokePosition(int x, int y) {
        this.keystrokeX = x;
        this.keystrokeY = y;
    }

    public float getKeystrokeScale() {
        return this.keystrokeScale;
    }

    public void setKeystrokeScale(float scale) {
        this.keystrokeScale = scale;
    }

    public boolean isArmorSlotEnabled(int slot) {
        switch (slot) {
            case 3: {
                return this.armorHelmetEnabled;
            }
            case 2: {
                return this.armorChestplateEnabled;
            }
            case 1: {
                return this.armorLeggingsEnabled;
            }
            case 0: {
                return this.armorBootsEnabled;
            }
        }
        return false;
    }

    public void setArmorSlotEnabled(int slot, boolean enabled) {
        switch (slot) {
            case 3: {
                this.armorHelmetEnabled = enabled;
                break;
            }
            case 2: {
                this.armorChestplateEnabled = enabled;
                break;
            }
            case 1: {
                this.armorLeggingsEnabled = enabled;
                break;
            }
            case 0: {
                this.armorBootsEnabled = enabled;
            }
        }
        this.saveConfig();
    }

    public boolean isArmorHelmetEnabled() {
        return this.armorHelmetEnabled;
    }

    public void setArmorHelmetEnabled(boolean enabled) {
        this.armorHelmetEnabled = enabled;
        this.saveConfig();
    }

    public boolean isArmorChestplateEnabled() {
        return this.armorChestplateEnabled;
    }

    public void setArmorChestplateEnabled(boolean enabled) {
        this.armorChestplateEnabled = enabled;
        this.saveConfig();
    }

    public boolean isArmorLeggingsEnabled() {
        return this.armorLeggingsEnabled;
    }

    public void setArmorLeggingsEnabled(boolean enabled) {
        this.armorLeggingsEnabled = enabled;
        this.saveConfig();
    }

    public boolean isArmorBootsEnabled() {
        return this.armorBootsEnabled;
    }

    public void setArmorBootsEnabled(boolean enabled) {
        this.armorBootsEnabled = enabled;
        this.saveConfig();
    }

    public boolean isHeldItemEnabled() {
        return this.heldItemEnabled;
    }

    public void setHeldItemEnabled(boolean enabled) {
        this.heldItemEnabled = enabled;
        this.saveConfig();
    }

    public boolean isToggleSprintHUDEnabled() {
        return this.toggleSprintHUDEnabled;
    }

    public void setToggleSprintHUDEnabled(boolean enabled) {
        this.toggleSprintHUDEnabled = enabled;
        this.saveConfig();
    }

    public int getToggleSprintX() {
        return this.toggleSprintX;
    }

    public int getToggleSprintY() {
        return this.toggleSprintY;
    }

    public void setToggleSprintPosition(int x, int y) {
        this.toggleSprintX = x;
        this.toggleSprintY = y;
    }

    public float getToggleSprintScale() {
        return this.toggleSprintScale;
    }

    public void setToggleSprintScale(float scale) {
        this.toggleSprintScale = scale;
    }

    public boolean isToggleSprintAlwaysShow() {
        return this.toggleSprintAlwaysShow;
    }

    public void setToggleSprintAlwaysShow(boolean enabled) {
        this.toggleSprintAlwaysShow = enabled;
        this.saveConfig();
    }

    public boolean isToggleSneakAlwaysShow() {
        return this.toggleSneakAlwaysShow;
    }

    public void setToggleSneakAlwaysShow(boolean enabled) {
        this.toggleSneakAlwaysShow = enabled;
        this.saveConfig();
    }

    public boolean isCPSHUDEnabled() {
        return this.cpsHUDEnabled;
    }

    public void setCPSHUDEnabled(boolean enabled) {
        this.cpsHUDEnabled = enabled;
        this.saveConfig();
    }

    public int getCPSX() {
        return this.cpsX;
    }

    public int getCPSY() {
        return this.cpsY;
    }

    public void setCPSPosition(int x, int y) {
        this.cpsX = x;
        this.cpsY = y;
    }

    public float getCPSScale() {
        return this.cpsScale;
    }

    public void setCPSScale(float scale) {
        this.cpsScale = scale;
    }

    public boolean isCPSShowBoth() {
        return this.cpsShowBoth;
    }

    public void setCPSShowBoth(boolean enabled) {
        this.cpsShowBoth = enabled;
        this.saveConfig();
    }

    public boolean isFPSHUDEnabled() {
        return this.fpsHUDEnabled;
    }

    public void setFPSHUDEnabled(boolean enabled) {
        this.fpsHUDEnabled = enabled;
        this.saveConfig();
    }

    public int getFPSX() {
        return this.fpsX;
    }

    public int getFPSY() {
        return this.fpsY;
    }

    public void setFPSPosition(int x, int y) {
        this.fpsX = x;
        this.fpsY = y;
    }

    public float getFPSScale() {
        return this.fpsScale;
    }

    public void setFPSScale(float scale) {
        this.fpsScale = scale;
    }

    public boolean isPingHUDEnabled() {
        return this.pingHUDEnabled;
    }

    public void setPingHUDEnabled(boolean enabled) {
        this.pingHUDEnabled = enabled;
        this.saveConfig();
    }

    public int getPingX() {
        return this.pingX;
    }

    public int getPingY() {
        return this.pingY;
    }

    public void setPingPosition(int x, int y) {
        this.pingX = x;
        this.pingY = y;
    }

    public float getPingScale() {
        return this.pingScale;
    }

    public void setPingScale(float scale) {
        this.pingScale = scale;
    }
}

