/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.hud.module;

import fr.vartax.module.hud.config.HUDConfig;
import fr.vartax.module.hud.event.HUDElement;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ArmorHUD
extends HUDElement {
    private static RenderItem itemRenderer = new RenderItem();
    private HUDConfig config;

    public ArmorHUD(HUDConfig config) {
        super(10, 50);
        this.config = config;
        this.width = 20;
        this.height = 100;
        this.x = config.getArmorX();
        this.y = config.getArmorY();
        this.scale = config.getArmorScale();
        this.enabled = config.isArmorHUDEnabled();
    }

    @Override
    public void render(ScaledResolution sr) {
        ItemStack heldItem;
        ItemStack heldItem2;
        boolean hasAnything = false;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack;
            if (!this.config.isArmorSlotEnabled(i) || (stack = this.mc.field_71439_g.field_71071_by.field_70460_b[i]) == null) continue;
            hasAnything = true;
            break;
        }
        if (!hasAnything && this.config.isHeldItemEnabled() && (heldItem2 = this.mc.field_71439_g.func_70694_bm()) != null) {
            hasAnything = true;
        }
        if (!hasAnything) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        RenderHelper.func_74520_c();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        int yOffset = 0;
        int itemCount = 0;
        for (int i = 3; i >= 0; --i) {
            ItemStack stack;
            if (!this.config.isArmorSlotEnabled(i) || (stack = this.mc.field_71439_g.field_71071_by.field_70460_b[i]) == null) continue;
            this.renderItemWithDurability(stack, 2, yOffset);
            yOffset += 20;
            ++itemCount;
        }
        if (this.config.isHeldItemEnabled() && (heldItem = this.mc.field_71439_g.func_70694_bm()) != null) {
            this.renderItemWithDurability(heldItem, 2, yOffset);
            ++itemCount;
        }
        this.height = Math.max(20, itemCount * 20);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
        this.config.setArmorPosition(this.x, this.y);
        this.config.setArmorScale(this.scale);
    }

    private void renderItemWithDurability(ItemStack stack, int x, int y) {
        itemRenderer.func_82406_b(this.mc.field_71466_p, this.mc.func_110434_K(), stack, x, y);
        if (stack.func_77951_h()) {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int maxDamage = stack.func_77958_k();
            int damage = stack.func_77960_j();
            int durability = maxDamage - damage;
            double percentage = (double)durability / (double)maxDamage;
            int barWidth = (int)Math.round(13.0 * percentage);
            int barColor = percentage > 0.66 ? 65280 : (percentage > 0.33 ? 0xFFFF00 : 0xFF0000);
            int barX = x + 2;
            int barY = y + 13;
            this.drawRect(barX, barY, barX + 13, barY + 2, -16777216);
            if (barWidth > 0) {
                this.drawRect(barX, barY, barX + barWidth, barY + 1, barColor | 0xFF000000);
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        itemRenderer.func_77021_b(this.mc.field_71466_p, this.mc.func_110434_K(), stack, x, y);
    }

    private void drawRect(int left, int top, int right, int bottom, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)left, (double)bottom);
        GL11.glVertex2d((double)right, (double)bottom);
        GL11.glVertex2d((double)right, (double)top);
        GL11.glVertex2d((double)left, (double)top);
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }
}

