/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.hud.module;

import fr.vartax.module.hud.HUDMod;
import fr.vartax.module.hud.config.HUDConfig;
import fr.vartax.module.hud.event.HUDElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;

public class CPSHUD
extends HUDElement {
    private HUDConfig config;
    private List<Long> leftClicks = new ArrayList<Long>();
    private List<Long> rightClicks = new ArrayList<Long>();
    private int lastLeftCPS = 0;
    private int lastRightCPS = 0;

    public CPSHUD(HUDConfig config) {
        super(10, 290);
        this.config = config;
        this.width = 80;
        this.height = 20;
        this.x = config.getCPSX();
        this.y = config.getCPSY();
        this.scale = config.getCPSScale();
        this.enabled = config.isCPSHUDEnabled();
    }

    @Override
    public void render(ScaledResolution sr) {
        String cpsText;
        this.updateCPS();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        if (this.config.isCPSShowBoth()) {
            cpsText = "\u00a7fLMB: \u00a7a" + this.lastLeftCPS + " \u00a7f| RMB: \u00a7a" + this.lastRightCPS;
        } else {
            int totalCPS = this.lastLeftCPS + this.lastRightCPS;
            cpsText = "\u00a7fCPS: \u00a7a" + totalCPS;
        }
        int textWidth = this.mc.field_71466_p.func_78256_a(cpsText);
        HUDMod.drawRect(0, 0, textWidth + 4, 14, -1879048192);
        this.mc.field_71466_p.func_78261_a(cpsText, 2, 2, 0xFFFFFF);
        this.width = textWidth + 4;
        this.height = 14;
        GL11.glPopMatrix();
        this.config.setCPSPosition(this.x, this.y);
        this.config.setCPSScale(this.scale);
    }

    private void updateCPS() {
        long currentTime = System.currentTimeMillis();
        long oneSecondAgo = currentTime - 1000L;
        this.leftClicks.removeIf(time -> time < oneSecondAgo);
        this.rightClicks.removeIf(time -> time < oneSecondAgo);
        this.lastLeftCPS = this.leftClicks.size();
        this.lastRightCPS = this.rightClicks.size();
    }

    public void onLeftClick() {
        this.leftClicks.add(System.currentTimeMillis());
    }

    public void onRightClick() {
        this.rightClicks.add(System.currentTimeMillis());
    }
}

