/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.hud.module;

import fr.vartax.module.hud.HUDMod;
import fr.vartax.module.hud.config.HUDConfig;
import fr.vartax.module.hud.event.HUDElement;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class KeystrokeHUD
extends HUDElement {
    private HUDConfig config;
    private long[] keyPressTimes = new long[7];
    private static final long PRESS_DURATION = 100L;

    public KeystrokeHUD(HUDConfig config) {
        super(10, 130);
        this.config = config;
        this.width = 80;
        this.height = 106;
        this.x = config.getKeystrokeX();
        this.y = config.getKeystrokeY();
        this.scale = config.getKeystrokeScale();
        this.enabled = config.isKeystrokeHUDEnabled();
    }

    @Override
    public void render(ScaledResolution sr) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        GameSettings settings = this.mc.field_71474_y;
        long currentTime = System.currentTimeMillis();
        int buttonSize = 24;
        int spacing = 2;
        this.renderKey(settings.field_74351_w, 28, 0, buttonSize, "W", 0, currentTime);
        this.renderKey(settings.field_74370_x, 0, 26, buttonSize, "A", 1, currentTime);
        this.renderKey(settings.field_74368_y, 28, 26, buttonSize, "S", 2, currentTime);
        this.renderKey(settings.field_74366_z, 56, 26, buttonSize, "D", 3, currentTime);
        this.renderKey(settings.field_74314_A, 0, 52, 80, buttonSize, "SPACE", 4, currentTime);
        this.renderMouseButton(true, 0, 78, 38, buttonSize, "LMB", 5, currentTime);
        this.renderMouseButton(false, 42, 78, 38, buttonSize, "RMB", 6, currentTime);
        GL11.glPopMatrix();
        this.config.setKeystrokePosition(this.x, this.y);
        this.config.setKeystrokeScale(this.scale);
    }

    private void renderKey(KeyBinding keyBinding, int x, int y, int size, String defaultLabel, int index, long currentTime) {
        this.renderKey(keyBinding, x, y, size, size, defaultLabel, index, currentTime);
    }

    private void renderKey(KeyBinding keyBinding, int x, int y, int width, int height, String defaultLabel, int index, long currentTime) {
        boolean isPressed = Keyboard.isKeyDown((int)keyBinding.func_151463_i());
        if (isPressed) {
            this.keyPressTimes[index] = currentTime;
        }
        boolean shouldHighlight = currentTime - this.keyPressTimes[index] < 100L;
        int bgColor = shouldHighlight ? -855638017 : -1879048192;
        int textColor = shouldHighlight ? 0 : 0xFFFFFF;
        HUDMod.drawRect(x, y, x + width, y + height, bgColor);
        this.drawBorder(x, y, width, height);
        String keyName = Keyboard.getKeyName((int)keyBinding.func_151463_i());
        if (keyName == null || keyName.isEmpty()) {
            keyName = defaultLabel;
        }
        int textWidth = this.mc.field_71466_p.func_78256_a(keyName);
        int textX = x + (width - textWidth) / 2;
        int textY = y + (height - 8) / 2;
        this.mc.field_71466_p.func_78276_b(keyName, textX, textY, textColor);
    }

    private void renderMouseButton(boolean isLeftClick, int x, int y, int width, int height, String label, int index, long currentTime) {
        boolean isPressed;
        boolean bl = isPressed = isLeftClick ? Mouse.isButtonDown((int)0) : Mouse.isButtonDown((int)1);
        if (isPressed) {
            this.keyPressTimes[index] = currentTime;
        }
        boolean shouldHighlight = currentTime - this.keyPressTimes[index] < 100L;
        int bgColor = shouldHighlight ? -855638017 : -1879048192;
        int textColor = shouldHighlight ? 0 : 0xFFFFFF;
        HUDMod.drawRect(x, y, x + width, y + height, bgColor);
        this.drawBorder(x, y, width, height);
        int textWidth = this.mc.field_71466_p.func_78256_a(label);
        int textX = x + (width - textWidth) / 2;
        int textY = y + (height - 8) / 2;
        this.mc.field_71466_p.func_78276_b(label, textX, textY, textColor);
    }

    private void drawBorder(int x, int y, int size) {
        this.drawBorder(x, y, size, size);
    }

    private void drawBorder(int x, int y, int width, int height) {
        int borderColor = -11184811;
        HUDMod.drawRect(x, y, x + width, y + 1, borderColor);
        HUDMod.drawRect(x, y + height - 1, x + width, y + height, borderColor);
        HUDMod.drawRect(x, y, x + 1, y + height, borderColor);
        HUDMod.drawRect(x + width - 1, y, x + width, y + height, borderColor);
    }
}

