/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.hud.module;

import fr.vartax.module.hud.HUDMod;
import fr.vartax.module.hud.config.HUDConfig;
import fr.vartax.module.hud.event.HUDElement;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetHandlerPlayClient;
import org.lwjgl.opengl.GL11;

public class PingHUD
extends HUDElement {
    private HUDConfig config;

    public PingHUD(HUDConfig config) {
        super(10, 350);
        this.config = config;
        this.width = 80;
        this.height = 10;
        this.x = config.getPingX();
        this.y = config.getPingY();
        this.scale = config.getPingScale();
        this.enabled = config.isPingHUDEnabled();
    }

    @Override
    public void render(ScaledResolution sr) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        int ping = this.getPing();
        String color = "\u00a7a";
        if (ping > 150) {
            color = "\u00a7c";
        } else if (ping > 75) {
            color = "\u00a7e";
        }
        String pingText = "\u00a7fPing: " + color + ping + "ms";
        int textWidth = this.mc.field_71466_p.func_78256_a(pingText);
        HUDMod.drawRect(0, 0, textWidth + 4, 14, -1879048192);
        this.mc.field_71466_p.func_78261_a(pingText, 2, 2, 0xFFFFFF);
        this.width = textWidth + 4;
        this.height = 14;
        GL11.glPopMatrix();
        this.config.setPingPosition(this.x, this.y);
        this.config.setPingScale(this.scale);
    }

    private int getPing() {
        try {
            if (this.mc.field_71439_g == null) {
                return 0;
            }
            NetHandlerPlayClient netHandler = this.mc.field_71439_g.field_71174_a;
            if (netHandler == null) {
                return 0;
            }
            String playerName = this.mc.field_71439_g.func_146103_bH().getName();
            for (Object obj : netHandler.field_147303_b) {
                GuiPlayerInfo playerInfo = (GuiPlayerInfo)obj;
                if (playerInfo == null || playerInfo.field_78831_a == null || !playerInfo.field_78831_a.equals(playerName)) continue;
                return playerInfo.field_78829_b;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

