/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.hud.module;

import fr.vartax.module.hud.config.HUDConfig;
import fr.vartax.module.hud.event.HUDElement;
import java.util.Collection;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class PotionHUD
extends HUDElement {
    private static final ResourceLocation inventoryBackground = new ResourceLocation("textures/gui/container/inventory.png");
    private HUDConfig config;

    public PotionHUD(HUDConfig config) {
        super(10, 10);
        this.config = config;
        this.width = 120;
        this.height = 24;
        this.x = config.getPotionX();
        this.y = config.getPotionY();
        this.scale = config.getPotionScale();
        this.enabled = config.isPotionHUDEnabled();
    }

    @Override
    public void render(ScaledResolution sr) {
        Collection effects = this.mc.field_71439_g.func_70651_bq();
        if (effects.isEmpty()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        int yOffset = 0;
        for (PotionEffect effect : effects) {
            Potion potion = Potion.field_76425_a[effect.func_76456_a()];
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(inventoryBackground);
            if (potion.func_76400_d()) {
                int iconIndex = potion.func_76392_e();
                this.drawTexturedModalRect(2, yOffset + 4, iconIndex % 8 * 18, 198 + iconIndex / 8 * 18, 18, 18);
            }
            String name = I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]);
            this.mc.field_71466_p.func_78261_a(name, 24, yOffset + 4, 0xFFFFFF);
            String duration = Potion.func_76389_a((PotionEffect)effect);
            this.mc.field_71466_p.func_78261_a(duration, 24, yOffset + 14, 0x7F7F7F);
            yOffset += 26;
        }
        this.height = Math.max(24, yOffset);
        GL11.glPopMatrix();
        this.config.setPotionPosition(this.x, this.y);
        this.config.setPotionScale(this.scale);
    }

    private void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), 0.0, (double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), 0.0, (double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f1));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), 0.0, (double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1));
        tessellator.func_78381_a();
    }
}

