/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.hud.module;

import fr.vartax.module.hud.HUDMod;
import fr.vartax.module.hud.config.HUDConfig;
import fr.vartax.module.hud.event.HUDElement;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;

public class ToggleSprintHUD
extends HUDElement {
    private HUDConfig config;

    public ToggleSprintHUD(HUDConfig config) {
        super(10, 250);
        this.config = config;
        this.width = 100;
        this.height = 30;
        this.x = config.getToggleSprintX();
        this.y = config.getToggleSprintY();
        this.scale = config.getToggleSprintScale();
        this.enabled = config.isToggleSprintHUDEnabled();
    }

    @Override
    public void render(ScaledResolution sr) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        int yOffset = 0;
        int maxWidth = 0;
        boolean somethingRendered = false;
        boolean isSprinting = this.mc.field_71439_g != null && this.mc.field_71439_g.func_70051_ag();
        String sprintText = null;
        if (isSprinting || this.config.isToggleSprintAlwaysShow()) {
            sprintText = isSprinting ? "\u00a7a[Sprinting]" : "\u00a77[Sprinting]";
            maxWidth = Math.max(maxWidth, this.mc.field_71466_p.func_78256_a(sprintText));
            somethingRendered = true;
        }
        boolean isSneaking = this.mc.field_71439_g != null && this.mc.field_71439_g.func_70093_af();
        String sneakText = null;
        if (isSneaking || this.config.isToggleSneakAlwaysShow()) {
            sneakText = isSneaking ? "\u00a7a[Sneaking]" : "\u00a77[Sneaking]";
            maxWidth = Math.max(maxWidth, this.mc.field_71466_p.func_78256_a(sneakText));
            somethingRendered = true;
        }
        String defaultText = null;
        if (!somethingRendered) {
            defaultText = "\u00a77[Not Sprinting]";
            maxWidth = this.mc.field_71466_p.func_78256_a(defaultText);
        }
        int totalHeight = 0;
        if (sprintText != null) {
            totalHeight += 10;
        }
        if (sneakText != null) {
            totalHeight += 10;
        }
        if (defaultText != null) {
            totalHeight = 10;
        }
        HUDMod.drawRect(0, 0, maxWidth + 4, totalHeight + 4, -1879048192);
        if (sprintText != null) {
            this.mc.field_71466_p.func_78261_a(sprintText, 2, 2 + yOffset, 0xFFFFFF);
            yOffset += 10;
        }
        if (sneakText != null) {
            this.mc.field_71466_p.func_78261_a(sneakText, 2, 2 + yOffset, 0xFFFFFF);
            yOffset += 10;
        }
        if (defaultText != null) {
            this.mc.field_71466_p.func_78261_a(defaultText, 2, 2, 0xFFFFFF);
        }
        this.width = maxWidth + 4;
        this.height = Math.max(10, totalHeight + 4);
        GL11.glPopMatrix();
        this.config.setToggleSprintPosition(this.x, this.y);
        this.config.setToggleSprintScale(this.scale);
    }
}

