/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs;

import fr.vartax.client.tarantula.EntityTarantula;
import fr.vartax.future.entity.EntityEndermite;
import fr.vartax.future.entity.EntityRabbit;
import fr.vartax.future.entity.EntityZombieVillager;
import fr.vartax.init.register.RegisterBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum JobType {
    MINEUR("Mineur", "\u00a77\u26cf"){
        {
            this.addXP(Blocks.field_150348_b, 0.5);
            this.addXP(Blocks.field_150347_e, 0.5);
            this.addXP(Blocks.field_150365_q, 0.7);
            this.addXP(Blocks.field_150366_p, 0.8);
            this.addXP(Blocks.field_150352_o, 0.9);
            this.addXP(Blocks.field_150482_ag, 1.0);
            this.addXP(Blocks.field_150412_bA, 1.2);
            this.addXP(Blocks.field_150450_ax, 0.6);
            this.addXP(Blocks.field_150369_x, 0.6);
            this.addXP(Blocks.field_150343_Z, 1.5);
            this.addXP(RegisterBlock.titane_ore, 2.5);
            this.addXP(RegisterBlock.jade_ore, 2.0);
            this.addXP(RegisterBlock.vartox_ore, 3.0);
        }
    }
    ,
    FARMER("Farmer", "\u00a7a\ud83c\udf3e"){
        {
            this.addXP(Items.field_151015_O, 0.5);
            this.addXP(Items.field_151172_bF, 0.4);
            this.addXP(Items.field_151174_bG, 0.4);
            this.addXP(Items.field_151127_ba, 0.6);
            this.addXP(Items.field_151080_bb, 0.3);
            this.addXP(Items.field_151014_N, 0.2);
            this.addXP(Items.field_151102_aT, 0.3);
        }
    }
    ,
    ALCHIMISTE("Alchimiste", "\u00a7d\u2697"){
        {
            this.addXP(Items.field_151075_bm, 0.5);
            this.addXP(Items.field_151065_br, 1.0);
            this.addXP(Items.field_151064_bs, 1.0);
            this.addXP(Items.field_151070_bp, 0.6);
            this.addXP(Items.field_151071_bq, 0.8);
            this.addXP(Items.field_151073_bk, 1.5);
            this.addXP((Block)Blocks.field_150328_O, 0.3);
            this.addXP((Block)Blocks.field_150327_N, 0.3);
            this.addXP((Block)Blocks.field_150338_P, 0.5);
            this.addXP((Block)Blocks.field_150337_Q, 0.5);
            this.addXP(Blocks.field_150424_aL, 0.1);
        }
    }
    ,
    HUNTER("Hunter", "\u00a7c\u2694"){
        {
            this.addXP(EntityZombie.class, 1.0);
            this.addXP(EntityZombieVillager.class, 1.0);
            this.addXP(EntityCreeper.class, 1.0);
            this.addXP(EntitySkeleton.class, 1.0);
            this.addXP(EntityEndermite.class, 0.5);
            this.addXP(EntitySpider.class, 0.8);
            this.addXP(EntityEnderman.class, 2.0);
            this.addXP(EntityBlaze.class, 2.0);
            this.addXP(EntityGhast.class, 3.0);
            this.addXP(EntityWitch.class, 2.5);
            this.addXP(EntityRabbit.class, 4.0);
            this.addXP(EntityTarantula.class, 5000.0);
        }
    };

    private final String displayName;
    private final String icon;
    private final Map<Item, Double> itemXP = new HashMap<Item, Double>();
    private final Map<Block, Double> blockXP = new HashMap<Block, Double>();
    private final Map<Class<? extends Entity>, Double> mobXP = new HashMap<Class<? extends Entity>, Double>();

    private JobType(String displayName, String icon) {
        this.displayName = displayName;
        this.icon = icon;
    }

    protected void addXP(Item item, double xp) {
        this.itemXP.put(item, xp);
    }

    protected void addXP(Block block, double xp) {
        this.blockXP.put(block, xp);
    }

    protected void addXP(Class<? extends Entity> entityClass, double xp) {
        this.mobXP.put(entityClass, xp);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIcon() {
        return this.icon;
    }

    public double getXP(ItemStack stack) {
        if (stack == null) {
            return 0.0;
        }
        Double xp = this.itemXP.get(stack.func_77973_b());
        return xp == null ? 0.0 : xp;
    }

    public double getXP(Block block) {
        Double xp = this.blockXP.get(block);
        return xp == null ? 0.0 : xp;
    }

    public double getXP(Entity entity) {
        if (entity == null) {
            return 0.0;
        }
        for (Map.Entry<Class<? extends Entity>, Double> entry : this.mobXP.entrySet()) {
            if (!entry.getKey().isInstance(entity)) continue;
            return entry.getValue();
        }
        return 0.0;
    }

    public boolean isRelatedItem(ItemStack stack) {
        return stack != null && this.itemXP.containsKey(stack.func_77973_b());
    }

    public boolean isRelatedBlock(Block block) {
        return this.blockXP.containsKey(block);
    }

    public boolean isRelatedMob(Entity entity) {
        if (entity == null) {
            return false;
        }
        for (Class<? extends Entity> clazz : this.mobXP.keySet()) {
            if (!clazz.isInstance(entity)) continue;
            return true;
        }
        return false;
    }

    public static JobType fromString(String name) {
        for (JobType job : JobType.values()) {
            if (!job.name().equalsIgnoreCase(name) && !job.displayName.equalsIgnoreCase(name)) continue;
            return job;
        }
        return null;
    }
}

