/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.common.PlayerConnectionHandler;
import fr.vartax.config.DatabaseConfig;
import fr.vartax.module.jobs.command.CommandJobXP;
import fr.vartax.module.jobs.data.DatabaseManager;
import fr.vartax.module.jobs.display.XPDisplayHandler;
import fr.vartax.module.jobs.event.JobEventHandler;
import fr.vartax.module.jobs.manager.JobManager;
import fr.vartax.module.jobs.network.PacketPipeline;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;

public class JobsSystem {
    private static JobsSystem instance;
    private JobEventHandler eventHandler = new JobEventHandler();
    public static PacketPipeline packetPipeline;
    private DatabaseConfig databaseConfig;
    private DatabaseManager databaseManager;
    @SideOnly(value=Side.CLIENT)
    private XPDisplayHandler xpHandler;

    private JobsSystem() {
    }

    public static JobsSystem getInstance() {
        if (instance == null) {
            instance = new JobsSystem();
        }
        return instance;
    }

    public void preInit(FMLPreInitializationEvent event) {
        packetPipeline.initialise();
        System.out.println("[Jobs] PacketPipeline initialis\u00e9 !");
        File configDir = event.getModConfigurationDirectory();
        this.databaseConfig = new DatabaseConfig(configDir);
        this.databaseManager = DatabaseManager.getInstance();
        this.databaseManager.initialize(this.databaseConfig);
        JobManager.getInstance().initialize(this.databaseManager);
        System.out.println("[Jobs] Syst\u00e8me de base de donn\u00e9es initialis\u00e9 !");
    }

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this.eventHandler);
        FMLCommonHandler.instance().bus().register((Object)this.eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerConnectionHandler());
        System.out.println("[Jobs] Syst\u00e8me de jobs initialis\u00e9 !");
    }

    public void postInit() {
        packetPipeline.postInitialise();
        System.out.println("[Jobs] PacketPipeline finalis\u00e9 !");
    }

    public void registerCommands(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandJobXP());
        System.out.println("[Jobs] Commandes enregistr\u00e9es !");
    }

    public void shutdown() {
        JobManager.getInstance().saveData();
        if (this.databaseManager != null) {
            this.databaseManager.shutdown();
        }
        System.out.println("[Jobs] Syst\u00e8me arr\u00eat\u00e9 proprement !");
    }

    @SideOnly(value=Side.CLIENT)
    public XPDisplayHandler getXPDisplayHandler() {
        return this.xpHandler;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public DatabaseConfig getDatabaseConfig() {
        return this.databaseConfig;
    }

    static {
        packetPipeline = new PacketPipeline();
    }
}

