/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.command;

import fr.vartax.module.jobs.JobType;
import fr.vartax.module.jobs.data.PlayerJobData;
import fr.vartax.module.jobs.manager.JobManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandJobXP
extends CommandBase {
    public String func_71517_b() {
        return "jobxp";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/jobxp <add|remove> <joueur> <m\u00e9tier> <niveaux>";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        int levels;
        if (args.length < 4) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String action = args[0].toLowerCase();
        String playerName = args[1];
        String jobName = args[2];
        try {
            levels = Integer.parseInt(args[3]);
            if (levels < 1 || levels > 20) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7cLe nombre de niveaux doit \u00eatre compris entre 1 et 20 !"));
                return;
            }
        }
        catch (NumberFormatException e) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7cLe nombre de niveaux doit \u00eatre un nombre entier !"));
            return;
        }
        EntityPlayerMP target = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(playerName);
        if (target == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7cJoueur introuvable !"));
            return;
        }
        JobType jobType = JobType.fromString(jobName);
        if (jobType == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7cM\u00e9tier invalide ! M\u00e9tiers disponibles: mineur, farmer, alchimiste, hunter"));
            return;
        }
        PlayerJobData data = JobManager.getInstance().getPlayerData((EntityPlayer)target);
        if (action.equals("add")) {
            data.addLevels(jobType, levels);
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a\u2713 " + levels + " niveau(x) ajout\u00e9(s) au m\u00e9tier \u00a7e" + jobType.getDisplayName() + " \u00a7ade \u00a7e" + playerName));
            target.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a\u2713 Vous avez re\u00e7u \u00a7e" + levels + " \u00a7aniveau(x) en \u00a7e" + jobType.getDisplayName()));
        } else if (action.equals("remove")) {
            data.removeLevels(jobType, levels);
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c\u2713 " + levels + " niveau(x) retir\u00e9(s) du m\u00e9tier \u00a7e" + jobType.getDisplayName() + " \u00a7cde \u00a7e" + playerName));
            target.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c\u2713 Vous avez perdu \u00a7e" + levels + " \u00a7cniveau(x) en \u00a7e" + jobType.getDisplayName()));
        } else {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        JobManager.getInstance().saveData();
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandJobXP.func_71530_a((String[])args, (String[])new String[]{"add", "remove"});
        }
        if (args.length == 2) {
            return CommandJobXP.func_71530_a((String[])args, (String[])MinecraftServer.func_71276_C().func_71213_z());
        }
        if (args.length == 3) {
            ArrayList<String> jobs = new ArrayList<String>();
            for (JobType type : JobType.values()) {
                jobs.add(type.name().toLowerCase());
            }
            return CommandJobXP.func_71530_a((String[])args, (String[])jobs.toArray(new String[0]));
        }
        if (args.length == 4) {
            return CommandJobXP.func_71530_a((String[])args, (String[])new String[]{"1", "5", "10", "15", "20"});
        }
        return null;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 1;
    }
}

