/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.data;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.vartax.module.jobs.JobType;
import fr.vartax.module.jobs.data.JobData;
import fr.vartax.module.jobs.data.PlayerJobData;
import java.util.UUID;

@SideOnly(value=Side.CLIENT)
public class ClientJobCache {
    private static ClientJobCache instance;
    private PlayerJobData cachedData;

    private ClientJobCache() {
    }

    public static ClientJobCache getInstance() {
        if (instance == null) {
            instance = new ClientJobCache();
        }
        return instance;
    }

    public void updateCache(PlayerJobData data) {
        this.cachedData = data;
    }

    public PlayerJobData getCachedData() {
        return this.cachedData;
    }

    public void updateJobXP(JobType jobType, double xpGained) {
        if (this.cachedData != null) {
            JobData jobData = this.cachedData.getJobData(jobType);
            jobData.addXP(xpGained);
            System.out.println("[Jobs Client] XP mise \u00e0 jour: " + jobType.name() + " +" + xpGained);
        }
    }

    public void updateJobLevel(JobType jobType, int newLevel) {
        if (this.cachedData != null) {
            JobData jobData = this.cachedData.getJobData(jobType);
            jobData.setLevel(newLevel);
            System.out.println("[Jobs Client] Niveau mis \u00e0 jour: " + jobType.name() + " \u2192 " + newLevel);
        }
    }

    public void initCache(UUID uuid, String name) {
        if (this.cachedData == null) {
            this.cachedData = new PlayerJobData(uuid, name);
        }
    }

    public void clearCache() {
        this.cachedData = null;
    }
}

