/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.data;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import fr.vartax.config.DatabaseConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseManager {
    private static DatabaseManager instance;
    private HikariDataSource dataSource;
    private DatabaseConfig config;
    private boolean showQueries;

    private DatabaseManager() {
    }

    public static DatabaseManager getInstance() {
        if (instance == null) {
            instance = new DatabaseManager();
        }
        return instance;
    }

    public void initialize(DatabaseConfig config) {
        this.config = config;
        this.showQueries = config.isShowQueries();
        try {
            Class.forName("com.mysql.jdbc.Driver");
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setJdbcUrl(config.getJdbcUrl());
            hikariConfig.setUsername(config.getMySQLUsername());
            hikariConfig.setPassword(config.getMySQLPassword());
            hikariConfig.setMinimumIdle(config.getPoolMinConnections());
            hikariConfig.setMaximumPoolSize(config.getPoolMaxConnections());
            hikariConfig.setConnectionTimeout((long)config.getPoolTimeout());
            hikariConfig.setPoolName("VartaCraft-Jobs-Pool");
            this.dataSource = new HikariDataSource(hikariConfig);
            System.out.println("[Jobs] MySQL connect\u00e9 : " + config.getJdbcUrl());
            if (config.isAutoCreateTable()) {
                this.createTableIfNotExists();
            }
        }
        catch (Exception e) {
            System.err.println("[Jobs] Erreur MySQL !");
            e.printStackTrace();
        }
    }

    private void createTableIfNotExists() {
        String table = this.config.getMySQLTable();
        String sql = "CREATE TABLE IF NOT EXISTS `" + table + "` (`uuid` VARCHAR(36) PRIMARY KEY,`player_name` VARCHAR(16) NOT NULL,`mineur_level` INT DEFAULT 1,`mineur_xp` DOUBLE DEFAULT 0.0,`farmer_level` INT DEFAULT 1,`farmer_xp` DOUBLE DEFAULT 0.0,`alchimiste_level` INT DEFAULT 1,`alchimiste_xp` DOUBLE DEFAULT 0.0,`hunter_level` INT DEFAULT 1,`hunter_xp` DOUBLE DEFAULT 0.0,`last_update` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        try (Connection conn = this.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute(sql);
            System.out.println("[Jobs] Table '" + table + "' cr\u00e9\u00e9e/v\u00e9rifi\u00e9e");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void logQuery(String query) {
        if (this.showQueries) {
            System.out.println("[Jobs SQL] " + query);
        }
    }

    public void shutdown() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
            System.out.println("[Jobs] MySQL ferm\u00e9");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConnected() {
        try (Connection conn = this.getConnection();){
            boolean bl = conn != null && !conn.isClosed();
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public DatabaseConfig getConfig() {
        return this.config;
    }
}

