/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.module.jobs.data;

public class JobData {
    private int level;
    private double currentXP;

    public JobData() {
        this.level = 1;
        this.currentXP = 0.0;
    }

    public JobData(int level, double currentXP) {
        this.level = Math.max(1, Math.min(level, 20));
        this.currentXP = Math.max(0.0, currentXP);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = Math.max(1, Math.min(level, 20));
        if (this.level >= 20) {
            this.currentXP = 0.0;
        }
    }

    public double getCurrentXP() {
        return this.currentXP;
    }

    public void setCurrentXP(double xp) {
        this.currentXP = Math.max(0.0, xp);
    }

    public double getXPForNextLevel() {
        if (this.level <= 5) {
            return 100 * this.level;
        }
        if (this.level <= 10) {
            return 1000.0 * Math.pow(1.5, this.level - 6);
        }
        if (this.level <= 15) {
            return 10000.0 * Math.pow(1.7, this.level - 11);
        }
        return 150000.0 * Math.pow(1.6, this.level - 16);
    }

    public boolean addXP(double amount) {
        if (this.level >= 20) {
            this.currentXP = 0.0;
            return false;
        }
        this.currentXP += amount;
        double xpNeeded = this.getXPForNextLevel();
        if (this.currentXP >= xpNeeded) {
            this.currentXP -= xpNeeded;
            ++this.level;
            return true;
        }
        return false;
    }

    public void removeXP(double amount) {
        this.currentXP = Math.max(0.0, this.currentXP - amount);
    }

    public double getProgressPercentage() {
        if (this.level >= 20) {
            return 100.0;
        }
        return this.currentXP * 100.0 / this.getXPForNextLevel();
    }
}

